package cn.com.duiba.goods.center.biz.dao.item;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AmbExpressTemplateOptionDto;

/**
 * 加钱购运费模版
 */
public interface AmbExpressTemplateOptionDAO {

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	public AmbExpressTemplateOptionDto find(Long id);

	/**
	 * 新增记录
	 * 
	 * @param entity
	 * @return
	 */
	public void insert(AmbExpressTemplateOptionDto entity);

	/**
	 * 更新记录
	 * 
	 * @param entity
	 */
	public int update(AmbExpressTemplateOptionDto entity);

	/**
	 * 根据模版ID查询
	 * 
	 * @param expressTemplateId
	 * @return
	 */
	public List<AmbExpressTemplateOptionDto> findByTemplateId(Long expressTemplateId);

	/**
	 * 根据模版IDS查询
	 * 
	 * @param ids
	 * @return
	 */
	public List<AmbExpressTemplateOptionDto> findByTemplateIds(List<Long> ids);

	/**
	 * 删除
	 * 
	 * @param expressTemplateId
	 */
	public int deleteOptionByTemplateId(Long expressTemplateId);

	/**
	 * 批量添加
	 * 
	 * @param dtos
	 */
	public int batchInsert(List<AmbExpressTemplateOptionDto> dtos);

}
