package cn.com.duiba.goods.center.biz.dao.item;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;

/**
 * 
 * AppItemDao
 *
 */
public interface AppItemDao {
	
	/**
	 * 根据ID查询应用商品信息
	 * 
	 * @param id
	 * @return
	 */
	public AppItemEntity find(Long id);

	/**
	 * 根据ID集合查询应用商品信息
	 * 
	 * @param ids
	 * @return
	 */
	public List<AppItemEntity> findByIds(List<Long> ids);
	
	/**
	 * 根据itemID查询
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId);
	
	/**
	 * 统计开发者入库数
	 * @param itemId
	 * @return
	 */
	public Integer findCountByItemId(Long itemId);

	/**
	 * 批量查询
	 * @param appId
	 * @param itemIds
	 * @return
	 */
	public List<AppItemEntity> findByAppIdAndItemIds(Long appId, List<Long> itemIds);

	/**
	 * 创建商品
	 * 
	 * @param appItemEntity
	 * @return
	 */
	public void insert(AppItemEntity appItemEntity);

	/**
	 * 修改商品
	 * 
	 * @param appItemEntity
	 * @return
	 */
	public Integer update(AppItemEntity appItemEntity);

	/**
	 * 删除商品
	 *
	 * @param appId
	 * @param appItemId
	 */
	public Integer delete(Long appId, Long appItemId);
	
    /**
     * 删除或者恢复兑换项
     */
    public Integer deleteOrRecoverAppItem(Long appId, Long id, Boolean deleted, String status);

	/**
	 * 批量删除商品
	 * 
	 * @param appId
	 * @param appItemId
	 * @return
	 */
	public Integer deleteByIds(Long appId, List<Long> appItemId);

	/**
	 * 修改状态
	 * 
	 * @param appId
	 * @param appItemId
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public Integer updateStatus(Long appId, Long appItemId, String status);

	/**
	 * 批量修改状态
	 * 
	 * @param appId
	 * @param appItemIds
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public Integer updateStatusByIds(Long appId, List<Long> appItemIds, String status);

	/**
	 * 减一个库存
	 * 
	 * @param appItemId
	 * @return
	 */
	public Integer decrStock(Long appItemId);

	/**
	 * 加一个库存
	 * 
	 * @param appItemId
	 * @return
	 */
	public Integer incrStock(Long appItemId);

	/**
	 * 编辑商品，增加库存
	 * 
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public Integer appendStock(Long appItemId, Long number);

	/**
	 * 编辑商品，减少库存
	 * 
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public Integer deductStock(Long appItemId, Long number);
	
	/**
	 * 修改库存和过期时间
	 * @param appItemId
	 * @param totalStock
	 * @param validEndDate
	 * @return
	 */
	public Integer updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate);
	
	/**
	 * 修改EXPIED为null
	 * 
	 * @param itemId
	 * @return
	 */
	public Integer updateExpiedAppItem(Long itemId);

	/**
	 * 修改EXPIED为null
	 * 
	 * @param appItemId
	 * @return
	 */
	public Integer updateExpiedAppItemById(Long appItemId);
	
    /**
     * 获取的首展示的兑换项
     *
     * @param appId
     * @return
     */
    public List<AppItemDto> findhomeAppItemNeed(Long appId);

	/**
	 * 根据appId查询指定数量的已上架商品用于首页展示
	 * 条件：状态为开启且未删除、首页展示开关打开
	 * 按权重由大到小倒叙排列
	 * @param appId
	 * @param limitCount
	 * @return
	 */
	List<AppItemEntity> findHomeItemKeyByAppIdAndLimitCount(long appId, int limitCount);

    /**
     * 获取参加了某个活动的且打开商品区入口的appId
     *
     * @param activityId
     * @param type
     * @return
     */
    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type);
    
    /**
     * 根据SourceIds和SourceTypes批量查询AppItemId
     * @param sourceIds
     * @param sourceTypes
     * @param appId 可以为null
     * @return
     */
    public List<Long> findIDBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId);
    
    /**
     * 批量查询
     * @param sourceIds
     * @param sourceTypes
     * @param appId
     * @return
     */
    public List<AppItemEntity> findBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId);

    /**
     * 获取某个活动下的所有
     *
     * @param relationId
     * @return
     */
    public List<Long> findAppIdsByActivityId(Long relationId);
    
    /**
     * 根据ReleationID批量查询
     * @param relationIds
     * @return
     */
    public List<Long> findIdsByActivityIds(List<Long> relationIds);

    /**
     * 查询将将某些兑吧商品入库的appId
     *
     * @param itemIds
     * @return
     */
    public List<Long> findAppIdByItemIds(List<Long> itemIds);

    /**
     * 根据appId和ids查询商品项
     *
     * @param appId
     * @param status
     * @param ids
     * @return
     */
    public List<AppItemDto> findAppItemsByAppIdAndIds(Long appId, String status, List<Long> ids);

    /**
     * 查询入库商品对应的appIds
     *
     * @param ids
     * @return
     */
    public List<Long> findAppIdsByIds(List<Long> ids);
    
    /**
     * 根据兑吧商品ID查询ID
     * @param itemId
     * @return
     */
    public List<Long> findIdByItemId(Long itemId);
    
    /**
     * 根据条件查询
     * @param params
     * @return
     */
    public List<AppItemDto> findByLimit(Map<String, Object> params);
    
    /**
     * 查询数量
     * @param params
     * @return
     */
    public Integer findByLimitCount(Map<String, Object> params);
    
    /**
     * 得到普通上架项中的最大的权重
     * @param appId
     * @return
     */
    public int findAppMaxPayload(Long appId);

    /**
     * 修改状态根据SourceRelationId
     * @param status
     * @param delete
     * @param oids
     * @return
     */
    public int updateStatusByActivityIds(String status, Boolean delete, List<Long> oids);

    /**
     * 修改状态
     * @param status
     * @param delete
     * @param activityId
     * @param type
     * @return
     */
	public Integer updateStatusByActivityId(String status, Boolean delete, Long activityId, Integer type);
	
	/**
	 * 查询
	 * @param activityId
	 * @param type
	 * @return
	 */
	public List<Long> findIdsByInActivityId(Long activityId, Integer type);

	/**
	 * 查询当前已置顶的商品appItemId,按权重倒叙排序
	 * @param appId
	 * @return
	 */
	public List<Long> findTopAppItemIdsDescByPayload(Long appId);

	/**
	 * 更新商品权重
	 *
	 * @param appId
	 * @param appItemId
	 * @param payload
	 * @return
	 */
	public int updateAppItemPayload(Long appId, Long appItemId, Integer payload);

	/**
	 * 自动修复兑吧已经禁用的商品 比如： 商品被添加到AppItem，而后兑吧禁用或者删除了该商品，
	 * 此时在AppItem库中，该商品还是上架状态。 此时进行修复，将该商品标记为下架状态
	 * 使用场景：当开发者在后台调整首页兑换项顺序时触发该程序
	 */
	public int updateOfflineAppItem4Disable(Long appId);

	/**
	 * 查询符合如下条件的商品appItemId:
	 * 	1.兑吧商品，
	 * 	2.已禁用或删除，
	 * 	3.开发者appId已上架
	 * @param appId
	 * @return
	 */
	public List<Long> findOfflineAppItemIds4Disable(Long appId);
	
	/**
	 * item禁用日志需求，根据itemId获取上架状态的appItem
	 * @param itemId
	 * @return
	 */
    public List<AppItemDto> findOnShelfByItemId(Long itemId);
    
    /**
     * 上架或者下架
     * @param id
     * @param status
     * @param deleted
     * @param payload
     * @param homeDisplay
     */
    public int standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay);
    
    /**
     * 修改活动工具入口
     * @param id
     * @param title
     * @param smallImage
     * @param whiteImage
     * @param credits
     * @param customPrice
     * @param logo
     * @param operationsType
     * @return
     */
    public int updateHdtoolAppItem(Long id, String title, String smallImage, String whiteImage, Long credits, String customPrice, String logo,Integer operationsType);
    
    /**
     * 更新专题活动主推兑换项属性
     * @param id
     * @param title
     * @param logo
     * @param smallImage
     * @param whiteImage
     * @param bannerImage
     * @param credits
     * @param subtitle
     */
    public int updateMainPushAppItem(Long id, String title, String logo, String smallImage, String whiteImage, String bannerImage, Long credits, String subtitle);
    
    /**
     * findAllBySourceTypeAndRelationIdAndDeleted
     * @param sourceType
     * @param sourceRelationId
     * @param deleted
     * @return
     */
    public List<AppItemDto> findAllBySourceTypeAndRelationIdAndDeleted(Integer sourceType, Long sourceRelationId, Boolean deleted);
    
    /**
     * findPublishItemLimit
     * @param queryPublish
     * @return
     */
    public List<AppItemDto> findPublishItemLimit(Map<String, Object> queryPublish);
    
    /**
     * countPublishItemRow
     * @param queryPublish
     * @return
     */
    public Integer countPublishItemRow(Map<String, Object> queryPublish);
    
    /**
     * updateSubTypeById
     * @param id
     * @param subType
     * @return
     */
    public Integer updateSubTypeById(Long id, Integer subType);
    
    /**
     * updateValidEndDateById
     * @param appItemId
     * @param validEndDate
     * @return
     */
	public int updateValidEndDateById(Long appItemId, Date validEndDate);
	
	/**
	 * findAllByAppIdAndInType
	 * @param appId
	 * @param type
	 * @return
	 */
	public List<AppItemDto> findAllByAppIdAndInType(Long appId, String[] type); 
	
	/**
	 * 统计APP上架的商品数
	 * @param appId
	 * @return
	 */
	public Integer findOnlineCount(Long appId);
	
	/**
	 *  APP上架的商品
	 * @param appId
	 * @return
	 */
	public List<AppItemDto> findOnlineAppItems(Long appId);
	
	/**
	 * 查询上架的虚拟商品
	 * @param appId
	 * @return
	 */
	public List<AppItemDto> findAllUpVirtaulAppItems(Long appId);
	
	/**
	 * updateOperationsTypeById
	 * @param id
	 * @param operationsType
	 */
	public void updateOperationsTypeById(Long id, Integer operationsType);
	
    /**
     * setLimitNull
     * @param appItemId
     * @param limitCount
     * @param limitTimeBetween
     * @param limitEverydayQuantity
     */
    public void setLimitNull(Long appItemId, Integer limitCount, String limitTimeBetween, Integer limitEverydayQuantity);
    
    /**
     * 获取app下所有上架的可用的自有商品
     * 
     * @param appId
     * @param types 类型
     * @param warnLine 库存预警线(实物,虚拟商品)
     * @return
     */
    public List<Long> findSelfAppItemIdsByAppId(Long appId,List<String> types,Integer warnLine);
    
}
