/**
 * Project Name:goods-center-biz
 * File Name:ItemDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年6月20日上午11:36:21
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.item;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ExchangeStockWarnDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.StockWarnEmailDto;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;

/**
 * ClassName:ItemDao <br/>
 * Date:     2016年6月20日 上午11:36:21 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ItemDao {

	/**
	 * 通过ID查询
	 * @param id
	 * @return
	 */
    public ItemEntity find(long id);

    /**
     * 获取活动链接券商品
     * @param ids
     * @return
     */
    public List<ItemEntity> findLinkActivityCouponItemsByIds(List<Long> ids);

    /**
     * 根据 ids 获取 list
     * @param ids
     * @return
     */
    public List<ItemEntity> findAllByIds(List<Long> ids);
    
	/**
	 * 创建商品
	 * 
	 * @param itemEntity
	 * @return
	 */
	public void insert(ItemEntity itemEntity);

	/**
	 * 修改商品
	 * 
	 * @param itemEntity
	 * @return
	 */
	public Integer update(ItemEntity itemEntity);

	/**
	 * 删除商品
	 * 
	 * @param itemId
	 * @return
	 */
	public Integer delete(Long itemId);

	/**
	 * 修改启用禁用
	 * 
	 * @param itemId
	 * @param enable
	 * @return
	 */
	public Integer updateEnable(Long itemId, Boolean enable);

	/**
	 * 减少一个库存
	 * @param itemId
	 * @return
	 */
	public Integer decrStock(Long itemId);
	
	/**
	 * 增加一个库存
	 * @param itemId
	 * @param bizId
	 * @return
	 */
	public Integer incrStock(Long itemId);
	
	/**
	 * 编辑商品，增加库存
	 * @param itemId
	 * @param number
	 * @return
	 */
	public Integer appendStock(Long itemId, Long number);
	
	/**
	 * 编辑商品，减少库存
	 * 
	 * @param itemId
	 * @param number
	 * @return
	 */
	public Integer deductStock(Long itemId, Long number);
	
	/**
	 * 修改库存和过期时间
	 * @param itemId
	 * @param totalStock
	 * @param validEndDate
	 * @return
	 */
	public int updateRemainingAndvalidEndDate(Long itemId, Long totalStock, Date validEndDate);
	
	/**
	 * 查询首页兑换项
	 * @param ids
	 * @return
	 */
	public List<ItemDto> findHomeItems(List<Long> ids);
	
	/**
	 * 根据Type查询，只用户查询几个兑吧固定直冲类商品
	 * @param type
	 * @return
	 */
	public ItemEntity findByType(String type);
	
	/**
	 * 查询JSONVALUE
	 * @param id
	 * @param key
	 * @return
	 */
	public String getJsonValue(Long id, String key);
	/**
	 * 设置JSONVALUE
	 * @param id
	 * @param key
	 * @param value
	 * @return
	 */
    public Integer setJsonValue(Long id, String value);
    /**
     * 查询JSONVALUE for update
     * @param id
     * @return
     */
    public String findJson4Update(Long id);

	/**
	 * 根据sourceRelation和sourceType进行查询
	 */
	public ItemEntity findBySourceRelationIdAndSourceType(Long sourceRelationId, Integer sourceType);
	
	/**
	 * 根据type查询（仅限于自冲类）
	 */
	public List<ItemDto> findByInTypes(List<String> types);

	/**
	 * 根据名称搜索
	 * 
	 * @param name
	 * @return
	 */
	public List<ItemDto> findAllByName(String name);

	/**
	 * 根据模版ID查询引用的商品
	 * 
	 * @param expressTemplateId
	 * @return
	 */
	public List<ItemDto> findAllByExpressTemplateId(Long expressTemplateId);

	/**
	 * 自动关闭时间置为null
	 * 
	 * @param id
	 * @return
	 */
	public Integer updateAutoOffDateNull(Long id);

	/**
	 * 把限制次数置为空
	 * 
	 * @param id
	 * @return
	 */
	public Integer updateLimitCountNull(Long id);

	/**
	 * 根据ID
	 * 
	 * @param id
	 * @param validEndDate
	 * @return
	 */
	public Integer updateValidEndDateById(Long id, Date validEndDate);

	/**
	 * 修改位运算
	 * 
	 * @param id
	 * @param operationsType
	 */
	public Integer updateOperationsTypeById(Long id, Integer operationsType);

	/**
	 * 获取所有能添加到专题活动中的兑吧兑换项
	 * 
	 * @param enable
	 * @return
	 */
	public List<ItemDto> findAllActivityItemAndEnable(Boolean enable);

	/**
	 * 获取可以展示在秒杀专题中的兑换项
	 */
	public List<ItemDto> findAllForDuibaSecondsKill();

	/**
	 * 获取库存迁移目标Item列表
	 * 
	 * @param type
	 * @param deleted
	 * @param subType
	 * @return
	 */
	public List<ItemDto> findAllTargetItemList(String type, Boolean deleted, Integer subType);

	/**
	 * 管理员后台分页查询item列表
	 * 
	 * @param query
	 * @return
	 */
	public List<ItemDto> findAdminItemPage(Map<String, Object> query);
	
	/**
	 * 管理员后台分页查询item列表count
	 * @param query
	 * @return
	 */
	public Integer findAdminItemPageCount(Map<String, Object> query);

	/**
	 * 查询推荐中的兑换项，管理员后台使用
	 * 
	 * @param itemName
	 * @return
	 */
	public List<ItemDto> findRecommandItems(String itemName);
	
	/**
	 * 查询推荐中的兑换项，管理员后台使用count
	 * @param itemName
	 * @return
	 */
	public Integer findRecommandItemsCount(String itemName);

	/**
	 * 修改是否自动推荐
	 * 
	 * @param id
	 * @param autoRecommend
	 * @return
	 */
	public Integer updateAutoRecommendById(Long id, Boolean autoRecommend);

	/**
	 * 更新payload
	 * 
	 * @param id
	 * @param payload
	 * @return
	 */
	public Integer updatePayloadById(Long id, Integer payload);

	/**
	 * 系统推荐的兑换项 + 关联的兑换项（可能包含不是自动推荐的兑换项） 二者互斥关系
	 * 
	 * @param tagsId
	 * @return
	 */
	public List<Long> findAutoRecommendAndTagsItems(Long tagsId);

	/**
	 * 获取给活动用的items
	 * 
	 * @param name
	 * @param type
	 * @return
	 */
	public List<ItemDto> findAllByNameAndType4Lottery(String name, String type);

	/**
	 * 查询所有启用状态的兑换项的id
	 * 
	 * @param enable
	 * @return
	 */
	public List<Long> findIdAllByEnable(Boolean enable);

	/**
	 * 把分类ID置为空
	 * 
	 * @param id
	 * @return
	 */
	public Integer updateItemClassifyIdNullById(Long id);

	/**
	 * 根据分类ids进行in查询
	 * 
	 * @param classifyIds
	 * @return
	 */
	public List<ItemDto> findAllByClassify(List<Long> classifyIds);

	/**
	 * 查询所有管理员后台所有启用状态的优惠券，按id倒序
	 */
	public List<ItemDto> findAllEnableCoupon();

	/**
	 * 兑换项库存列表查询
	 * 
	 * @param queryMap
	 * @return
	 */
	public List<ExchangeStockWarnDto> findExchangeStockWarnList(Map<String, Object> queryMap);
	
	/**
	 * 兑换项库存列表查询 count
	 * 
	 * @param queryMap
	 * @return
	 */
	public Integer findExchangeStockWarnListCount(Map<String, Object> queryMap);

	/**
	 * 查询兑换项库存预警列表
	 * 
	 * @param queryMap
	 * @return
	 */
	public List<ExchangeStockWarnDto> findItemStockWarns(Map<String, Object> queryMap);

	/**
	 * 清空兑换项库存表
	 */
	public void emptyExchangeStockWarn();

	/**
	 * 插入兑换项库存表
	 * 
	 * @param exchangeStockWarn
	 */
	public void saveExchangeStockWarn(ExchangeStockWarnDto exchangeStockWarn);

	/**
	 * 库存邮箱预警列表
	 * @param queryMap
	 * @return
	 */
	public List<StockWarnEmailDto> findEmailStockList(Map<String, Object> queryMap);

	/**
	 * 库存邮箱预警保存
	 * @param emailStr
	 */
	public void saveEmailStockWarn(String emailStr);
	
    /**
     * 库存邮箱预警清空
     */
    public void emptyEmailStockWarn();
    
    /**
     * 修改优惠券商品类型
     * @param id
     * @param subType
     * @return
     */
    public Integer updateSubTypeById(Long id, Integer subType);
    
    /**
     * 开发者后台兑吧待选库的查询总数
     */
    public Long findDuibaItemChooseCount(Map<String, Object> paramMap);
    
    /**
     * 获取所有的黑名单兑换项
     */
    public List<ItemDto> findAllBlacklistItem();
    
    /**
     * 查询一天内autooff商品
     * @return
     */
    public List<ItemDto> findAutoOffItem();
    
    /**
     * 启用兑换项
     */
    public void enableById(Long id, Boolean enable, Date publishTime);

}

