package cn.com.duiba.goods.center.biz.dao.item;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.PreStockPointEntity;

/**
 * 
 * PreStockPointDao
 *
 */
public interface PreStockPointDao {

	/**
	 * findAllByItemId
	 * @param itemId
	 * @return
	 */
	public List<PreStockPointEntity> findAllByItemId(Long itemId);

	/**
	 * findAllAppIdByItemId
	 * @param itemId
	 * @return
	 */
	public List<Long> findAllAppIdByItemId(Long itemId);

	/**
	 * batchInsert
	 * @param prePointList
	 */
	public void batchInsert(List<PreStockPointEntity> prePointList);

	/**
	 * findAppIdAndItemId
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public PreStockPointEntity findAppIdAndItemId(Long appId, Long itemId);

	/**
	 * findItemIdAndNullApp
	 * @param itemId
	 * @return
	 */
	public PreStockPointEntity findItemIdAndNullApp(Long itemId);
	
	/**
	 * findByItemIdsAndNullApp
	 * @param itemIds
	 * @return
	 */
	public List<PreStockPointEntity> findByItemIdsAndNullApp(List<Long> itemIds);

	/**
	 * update
	 * @param point
	 */
	public void update(PreStockPointEntity point);

	/**
	 * insert
	 * @param pointStock
	 * @return
	 */
	public int insert(PreStockPointEntity pointStock);

	/**
	 * findAllPointAppItem
	 * @param itemIds
	 * @param appId
	 * @return
	 */
	public List<PreStockPointEntity> findAllPointAppItem(List<Long> itemIds, Long appId);

	/**
	 * find
	 * @param id
	 * @return
	 */
	public PreStockPointEntity find(Long id);
}
