package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AmbExpressTemplateDto;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.AmbExpressTemplateDAO;

/**
 * 加钱购运费模版
 */
@Repository
public class AmbExpressTemplateDAOImpl extends BaseCreditsDao implements AmbExpressTemplateDAO {

	@Override
	public AmbExpressTemplateDto find(Long id) {
		return getSqlSession().selectOne(getStamentNameSpace("find"), id);
	}

	@Override
	public void insert(AmbExpressTemplateDto entity) {
		getSqlSession().insert(getStamentNameSpace("insert"), entity);
	}

	@Override
	public int update(AmbExpressTemplateDto entity) {
		return getSqlSession().update(getStamentNameSpace("update"), entity);
	}

	@Override
	public List<AmbExpressTemplateDto> findPageList(Map<String, Object> params) {
		return getSqlSession().selectList(getStamentNameSpace("findPageList"), params);
	}

	@Override
	public long findPageCount(Map<String, Object> params) {
		return getSqlSession().selectOne(getStamentNameSpace("findPageCount"), params);
	}

	@Override
	public int deleteTemplateById(Long id) {
		return getSqlSession().update(getStamentNameSpace("deleteTemplateById"), id);
	}

	@Override
	public List<AmbExpressTemplateDto> findByAppIdAndType(Long appId, String type) {
		Map<String, Object> params = getBlankParams();
		params.put("appId", appId);
		params.put("type", type);
		return getSqlSession().selectList(getStamentNameSpace("findByAppIdAndType"), params);
	}

	@Override
	public List<AmbExpressTemplateDto> findByAppIdAndName(Long appId, String name) {
		Map<String, Object> params = getBlankParams();
		params.put("appId", appId);
		params.put("name", name);
		return getSqlSession().selectList(getStamentNameSpace("findByAppIdAndName"), params);
	}

}
