package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.AppItemMaskDao;
import cn.com.duiba.goods.center.biz.entity.AppItemMaskingEntity;

/**
 * 
 * AppItemMaskDaoImpl
 *
 */
@Repository
public class AppItemMaskDaoImpl extends BaseCreditsDao implements AppItemMaskDao {
	
	private String appIdKey = "appId";

	@Override
	public AppItemMaskingEntity findByItem(Long itemId) {
		Map<String, Object> map = new HashMap<>();
		map.put("itemId", itemId);
		return getSqlSession().selectOne("findByItem", map);
	}

	@Override
	public void delete(Long id) {
		Map<String, Object> map = new HashMap<>();
		map.put("id", id);
		getSqlSession().delete("delete", map);
	}

	@Override
	public List<AppItemMaskingEntity> findAllByApp(Long appId) {
		Map<String, Object> map = new HashMap<>();
		map.put(appIdKey, appId);
		return getSqlSession().selectList("findAllByApp", map);
	}

	@Override
	public AppItemMaskingEntity findByAppIdAndItemId(Long appId, Long itemId) {
		Map<String, Object> map = new HashMap<>();
		map.put(appIdKey, appId);
		map.put("itemId", itemId);
		return getSqlSession().selectOne("findByAppIdAndItemId", map);
	}

	@Override
	public void insert(AppItemMaskingEntity appItemMaskingEntity) {
		getSqlSession().insert("insert", appItemMaskingEntity);
	}

	@Override
	public AppItemMaskingEntity find(Long id) {
		return getSqlSession().selectOne("find", id);
	}

	@Override
	public List<Long> findItemAppMasking(Long appId) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		return getSqlSession().selectList("findItemAppMasking", queryMap);
	}

}
