package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemAppSpecifyDao;
import cn.com.duiba.goods.center.biz.entity.ItemAppSpecifyEntity;

/**
 * EverydayLimitDAOImpl
 */
@Repository
public class ItemAppSpecifyDaoImpl extends BaseCreditsDao implements ItemAppSpecifyDao {

	private String appIdKey = "appId";
	private String itemIdKey = "itemId";
	
	@Override
	public List<ItemAppSpecifyEntity> findSpecifyByItemIdsAndAppId(List<Long> itemIds, Long appId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("itemIds", itemIds);
		paramMap.put(appIdKey, appId);
		return getSqlSession().selectList(getStamentNameSpace("findSpecifyByItemIdsAndAppId"), paramMap);
	}

	@Override
	public List<ItemAppSpecifyEntity> findAllByItemId(Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		return getSqlSession().selectList(getStamentNameSpace("findAllByItemId"), paramMap);
	}

	@Override
	public void delete(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		getSqlSession().delete(getStamentNameSpace("delete"), paramMap);
	}

	@Override
	public int reduceRemaining(Long itemId, Long appId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		paramMap.put(appIdKey, appId);
		return getSqlSession().update(getStamentNameSpace("reduceRemaining"), paramMap);
	}

	@Override
	public int increaseRemaining(Long itemId, Long appId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		paramMap.put(appIdKey, appId);
		return getSqlSession().update(getStamentNameSpace("increaseRemaining"), paramMap);
	}

	@Override
	public Long findSpecifyRemaining(Long itemId, Long appId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		paramMap.put(appIdKey, appId);
		return getSqlSession().selectOne(getStamentNameSpace("findSpecifyRemaining"), paramMap);
	}

	@Override
	public List<Long> findNOSpecify4App(Long appId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appIdKey, appId);
		return getSqlSession().selectList(getStamentNameSpace("findNOSpecify4App"), paramMap);
	}

	@Override
	public List<Long> findNOSpecify4AppNew(Long appId, Date newItemTime) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appIdKey, appId);
		paramMap.put("newItemTime", newItemTime);
		return getSqlSession().selectList(getStamentNameSpace("findNOSpecify4AppNew"), paramMap);
	}

	@Override
	public ItemAppSpecifyEntity findByItemIdAndAppId(Long itemId, Long appId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		paramMap.put(appIdKey, appId);
		return getSqlSession().selectOne(getStamentNameSpace("findByItemIdAndAppId"), paramMap);
	}

	@Override
	public ItemAppSpecifyEntity findByItemIdAndAppIdLock(Long itemId, Long appId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		paramMap.put(appIdKey, appId);
		return getSqlSession().selectOne(getStamentNameSpace("findByItemIdAndAppIdLock"), paramMap);
	}

	@Override
	public void insert(ItemAppSpecifyEntity itemAppSpecifyEntity) {
		getSqlSession().insert(getStamentNameSpace("insert"), itemAppSpecifyEntity);
	}

	@Override
	public ItemAppSpecifyEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		return getSqlSession().selectOne(getStamentNameSpace("find"), paramMap);
	}

	@Override
	public void updateRemaining(Long id, Integer remaining) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		paramMap.put("remaining", remaining);
		getSqlSession().update(getStamentNameSpace("updateRemaining"), paramMap);
	}

	@Override
	public List<Long> findItemSpecify(Long appId) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		return getSqlSession().selectList(getStamentNameSpace("findItemSpecify"), queryMap);
	}
}
