/**
 * Project Name:goods-center-biz
 * File Name:ItemDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年6月20日上午11:37:10
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ExchangeStockWarnDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.StockWarnEmailDto;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemDao;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;

/**
 * 兑吧商品DAO
 */
@Repository("itemDao")
public class ItemDaoImpl extends BaseCreditsDao implements ItemDao{

    @Override
    public ItemEntity find(long id) {
        return getSqlSession().selectOne(getStamentNameSpace("find"),id);
    }

    @Override
    public List<ItemEntity> findLinkActivityCouponItemsByIds(List<Long> ids) {
    	if(ids.isEmpty()){
    		return new ArrayList<>();
    	}
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("ids", ids);
        return getSqlSession().selectList(getStamentNameSpace("findLinkActivityCouponItemsByIds"), paramMap);
    }

    @Override
    public List<ItemEntity> findAllByIds(List<Long> ids) {
    	if(ids.isEmpty()){
    		return new ArrayList<>();
    	}
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("ids", ids);
        return getSqlSession().selectList(getStamentNameSpace("findAllByIds"), paramMap);
    }

	@Override
	public void insert(ItemEntity itemEntity) {
		getSqlSession().insert(getStamentNameSpace("insert"), itemEntity);
	}

	@Override
	public Integer update(ItemEntity itemEntity) {
		return getSqlSession().update(getStamentNameSpace("update"), itemEntity);
	}

	@Override
	public Integer delete(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("delete"), paramMap);
	}

	@Override
	public Integer updateEnable(Long id, Boolean enable) {
		Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("enable", enable);
		return getSqlSession().update(getStamentNameSpace("updateEnable"), paramMap);
	}

	@Override
	public Integer decrStock(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("decrStock"), paramMap);
	}

	@Override
	public Integer incrStock(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("incrStock"), paramMap);
	}

	@Override
	public Integer appendStock(Long id, Long number) {
		Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("number", number);
		return getSqlSession().update(getStamentNameSpace("appendStock"), paramMap);
	}

	@Override
	public Integer deductStock(Long id, Long number) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		paramMap.put("number", number);
		return getSqlSession().update(getStamentNameSpace("deductStock"), paramMap);
	}

	@Override
	public int updateRemainingAndvalidEndDate(Long itemId, Long totalStock, Date validEndDate) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("itemId", itemId);
		paramMap.put("totalStock", totalStock);
		paramMap.put("validEndDate", validEndDate);
		return getSqlSession().update(getStamentNameSpace("updateRemainingAndvalidEndDate"), paramMap);
	}
	
	@Override
	public List<ItemDto> findHomeItems(List<Long> ids) {
		if(ids.isEmpty()){
    		return new ArrayList<>();
    	}
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("ids", ids);
		return getSqlSession().selectList(getStamentNameSpace("findHomeItems"), paramMap);
	}

	@Override
	public ItemEntity findByType(String type) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("type", type);
		return getSqlSession().selectOne(getStamentNameSpace("findByType"), paramMap);
	}

	@Override
	public String getJsonValue(Long id, String key) {
		String jsonText = getSqlSession().selectOne(getStamentNameSpace("findExtraJsonById"), id);
		if (StringUtils.isBlank(jsonText)) {
			return null;
		}
		JSONObject json = JSONObject.parseObject(jsonText);
		return json.getString(key);
	}
	
	@Override
	public String findJson4Update(Long id) {
		return getSqlSession().selectOne(getStamentNameSpace("findJson4Update"), id);
	}

	@Override
	public Integer setJsonValue(Long id, String value) {
		Map<String, Object> param = new HashMap<>();
		param.put("id", id);
		param.put("json", value);
		return getSqlSession().update(getStamentNameSpace("updateJson"), param);
	}

	@Override
	public ItemEntity findBySourceRelationIdAndSourceType(Long sourceRelationId, Integer sourceType) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("sourceRelationId", sourceRelationId);
		paramMap.put("sourceType", sourceType);
		return getSqlSession().selectOne(getStamentNameSpace("findBySourceRelationIdAndSourceType"), paramMap);
	}

	@Override
	public List<ItemDto> findByInTypes(List<String> types) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("types", types);
		return getSqlSession().selectList(getStamentNameSpace("findBySourceRelationIdAndSourceType"), paramMap);
	}

	@Override
	public List<ItemDto> findAllByName(String name) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("name", name);
		return getSqlSession().selectList(getStamentNameSpace("findAllByName"), paramMap);
	}

	@Override
	public List<ItemDto> findAllByExpressTemplateId(Long expressTemplateId) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("expressTemplateId", expressTemplateId);
		return getSqlSession().selectList(getStamentNameSpace("findAllByExpressTemplateId"), paramMap);
	}

	@Override
	public Integer updateAutoOffDateNull(Long id) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("updateAutoOffDateNull"), paramMap);
	}

	@Override
	public Integer updateLimitCountNull(Long id) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("updateLimitCountNull"), paramMap);
	}

	@Override
	public Integer updateValidEndDateById(Long id, Date validEndDate) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("id", id);
        paramMap.put("validEndDate", validEndDate);
        return getSqlSession().update(getStamentNameSpace("updateValidEndDateById"), paramMap);
	}

	@Override
	public Integer updateOperationsTypeById(Long id, Integer operationsType) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("id", id);
        paramMap.put("operationsType", operationsType);
        return getSqlSession().update(getStamentNameSpace("updateOperationsTypeById"), paramMap);
	}

	@Override
	public List<ItemDto> findAllActivityItemAndEnable(Boolean enable) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("enable", enable);
		return getSqlSession().selectList(getStamentNameSpace("findAllActivityItemAndEnable"), paramMap);
	}

	@Override
	public List<ItemDto> findAllForDuibaSecondsKill() {
		return getSqlSession().selectList(getStamentNameSpace("findAllForDuibaSecondsKill"));
	}

	@Override
	public List<ItemDto> findAllTargetItemList(String type, Boolean deleted, Integer subType) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("type", type);
        paramMap.put("deleted", deleted);
        paramMap.put("subType", subType);
        return getSqlSession().selectList(getStamentNameSpace("findAllTargetItemList"), paramMap);
	}

	@Override
	public List<ItemDto> findAdminItemPage(Map<String, Object> query) {
        return getSqlSession().selectList(getStamentNameSpace("findAdminItemPage"), query);
	}
	
	@Override
	public Integer findAdminItemPageCount(Map<String, Object> query) {
		return getSqlSession().selectOne(getStamentNameSpace("findAdminItemPageCount"), query);
	}

	@Override
	public Integer updateAutoRecommendById(Long id, Boolean autoRecommend) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("id", id);
        paramMap.put("autoRecommend", autoRecommend);
        return getSqlSession().update(getStamentNameSpace("updateAutoRecommendById"), paramMap);
	}

	@Override
	public Integer updatePayloadById(Long id, Integer payload) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("id", id);
        paramMap.put("payload", payload);
        return getSqlSession().update(getStamentNameSpace("updatePayloadById"), paramMap);
	}

	@Override
	public List<Long> findAutoRecommendAndTagsItems(Long tagsId) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("tagsId", tagsId);
        return getSqlSession().selectList(getStamentNameSpace("findAutoRecommendAndTagsItems"), paramMap);
	}

	@Override
	public List<ItemDto> findAllByNameAndType4Lottery(String name, String type) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("name", name);
        paramMap.put("type", type);
        return getSqlSession().selectList(getStamentNameSpace("findAllByNameAndType4Lottery"), paramMap);
	}

	@Override
	public List<Long> findIdAllByEnable(Boolean enable) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("enable", enable);
        return getSqlSession().selectList(getStamentNameSpace("findIdAllByEnable"), paramMap);
	}

	@Override
	public Integer updateItemClassifyIdNullById(Long id) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("id", id);
        return getSqlSession().update(getStamentNameSpace("updateItemClassifyIdNullById"), paramMap);
	}

	@Override
	public List<ItemDto> findAllByClassify(List<Long> classifyIds) {
		Map<String, Object> paramMap = getBlankParams();
        paramMap.put("classifyIds", classifyIds);
        return getSqlSession().selectList(getStamentNameSpace("findAllByClassify"), paramMap);
	}

	@Override
	public List<ItemDto> findAllEnableCoupon() {
		return getSqlSession().selectList(getStamentNameSpace("findAllEnableCoupon"));
	}

	@Override
	public List<ExchangeStockWarnDto> findItemStockWarns(Map<String, Object> queryMap) {
		return getSqlSession().selectList(getStamentNameSpace("findItemStockWarns"), queryMap);
	}

	@Override
	public void emptyExchangeStockWarn() {
		getSqlSession().delete(getStamentNameSpace("emptyExchangeStockWarn"));
	}

	@Override
	public void saveExchangeStockWarn(ExchangeStockWarnDto exchangeStockWarn) {
		getSqlSession().insert(getStamentNameSpace("saveExchangeStockWarn"), exchangeStockWarn);
	}

	@Override
	public List<StockWarnEmailDto> findEmailStockList(Map<String, Object> queryMap) {
		return getSqlSession().selectList(getStamentNameSpace("findEmailStockList"), queryMap);
	}

	@Override
	public void saveEmailStockWarn(String emailStr) {
		getSqlSession().insert(getStamentNameSpace("saveEmailStockWarn"), emailStr);
	}

	@Override
	public void emptyEmailStockWarn() {
		getSqlSession().delete(getStamentNameSpace("emptyEmailStockWarn"));
	}

	@Override
	public List<ItemDto> findRecommandItems(String itemName) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("itemName", itemName);
        return getSqlSession().selectList(getStamentNameSpace("findRecommandItems"), paramMap);
	}

	@Override
	public Integer findRecommandItemsCount(String itemName) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("itemName", itemName);
		return getSqlSession().selectOne(getStamentNameSpace("findRecommandItemsCount"), paramMap);
	}

	@Override
	public List<ExchangeStockWarnDto> findExchangeStockWarnList(Map<String, Object> queryMap) {
		return getSqlSession().selectList(getStamentNameSpace("findExchangeStockWarnList"), queryMap);
	}

	@Override
	public Integer findExchangeStockWarnListCount(Map<String, Object> queryMap) {
		return getSqlSession().selectOne(getStamentNameSpace("findExchangeStockWarnCount"), queryMap);
	}

	@Override
	public Integer updateSubTypeById(Long id, Integer subType) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("id", id);
		paramMap.put("subType", subType);
		return getSqlSession().update(getStamentNameSpace("updateSubTypeById"), paramMap);
	}

	@Override
	public Long findDuibaItemChooseCount(Map<String, Object> paramMap) {
        return getSqlSession().selectOne(getStamentNameSpace("findDuibaItemChooseCount"), paramMap);
	}

	@Override
	public List<ItemDto> findAllBlacklistItem() {
		 return getSqlSession().selectList(getStamentNameSpace("findAllBlacklistItem"));
	}

    @Override
    public List<ItemDto> findAutoOffItem() {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(new Date());
        cal1.add(Calendar.DATE, -1);
        Date startTime = cal1.getTime();

        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", new Date());
        return getSqlSession().selectList(getStamentNameSpace("findAutoOffItem"), paramMap);
    }

	@Override
	public void enableById(Long id, Boolean enable, Date publishTime) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("enable", enable);
        paramMap.put("publishTime", publishTime);
        getSqlSession().update(getStamentNameSpace("enableById"), paramMap);
	}

}

