package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockManualChangeDao;
import cn.com.duiba.goods.center.biz.entity.PreStockManualChangeEntity;

/**
 * 
 * PreStockManualChangeDaoImpl
 *
 */
@Repository
public class PreStockManualChangeDaoImpl extends BaseCreditsDao implements PreStockManualChangeDao {

	@Override
	public PreStockManualChangeEntity insert(PreStockManualChangeEntity instance) {
		int ret = getSqlSession().insert(getStamentNameSpace("insert"), instance);
		if (ret == 1) {
			return instance;
		}
		return null;
	}

	@Override
	public PreStockManualChangeEntity find(Long id) {
		Map<String, Object> params = new HashMap<>();
		params.put("id", id);
		return getSqlSession().selectOne(getStamentNameSpace("find"), params);
	}

	@Override
	public PreStockManualChangeEntity findByStockIdAndBizId(Long stockId, Long bizId) {
		Map<String, Object> params = new HashMap<>();
		params.put("stockId", stockId);
		params.put("bizId", bizId);
		return getSqlSession().selectOne(getStamentNameSpace("findByStockIdAndBizId"), params);
	}
}
