package cn.com.duiba.goods.center.biz.remoteservice.impl;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.RemoteAppItemClassifyService;
import cn.com.duiba.goods.center.api.remoteservice.dto.AppItemClassifyDto;
import cn.com.duiba.goods.center.biz.service.AppItemClassifyRelationService;
import cn.com.duiba.goods.center.biz.service.AppItemClassifyService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xiaoxuda on 2016/11/17.
 */
@Service("remoteAppItemClassifyService")
public class RemoteAppItemClassifyServiceImpl implements RemoteAppItemClassifyService {
    @Autowired
    private AppItemClassifyService appItemClassifyService;
    @Resource
    private AppItemClassifyRelationService appItemClassifyRelationService;

    @Override
    public DubboResult<AppItemClassifyDto> find(Long id) {
        return new DubboResult<>(true, null, appItemClassifyService.find(id));
    }

    @Override
    public DubboResult<Integer> deleteRelationAppItem(Long appItemId){
        Integer ret = appItemClassifyRelationService.deleteRelationAppItem(appItemId);
        return DubboResult.successResult(ret);
    }
}
