package cn.com.duiba.goods.center.biz.remoteservice.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.RemoteDevCustomizedBackendService;
import cn.com.duiba.goods.center.biz.service.DevCustomizedService;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xiaoxuda on 2017/3/27.
 */
@Service("remoteDevCustomizedBackendService")
public class RemoteDevCustomizedBackendServiceImpl implements RemoteDevCustomizedBackendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDevCustomizedBackendServiceImpl.class);
    @Autowired
    private DevCustomizedService devCustomizedService;

    @Override
    public DubboResult<Boolean> indexItemSort(Long appId, List<Long> sortAppItemIds) {
        try {
            boolean result = devCustomizedService.indexItemSort(appId, sortAppItemIds);
            return DubboResult.successResult(result);
        } catch (GoodsException e) {
            LOGGER.info("权重排序失败", e);
            DubboResult result = DubboResult.successResult(false);
            result.setMsg(e.getResultMessage());
            return result;
        } catch (Exception e) {
            LOGGER.error("权重排序失败", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> setTop4IndexItem(Long appId, Long appItemId) {
        try {
            boolean result = devCustomizedService.setTop4IndexItem(appId, appItemId);
            return DubboResult.successResult(result);
        } catch (GoodsException e) {
            LOGGER.info("置顶失败", e);
            DubboResult result = DubboResult.successResult(false);
            result.setMsg(e.getResultMessage());
            return result;
        } catch (Exception e) {
            LOGGER.error("置顶失败", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> cancelTop4IndexItem(Long appId, Long appItemId) {
        try {
            boolean result = devCustomizedService.cancelTop4IndexItem(appId, appItemId);
            return DubboResult.successResult(result);
        } catch (GoodsException e) {
            LOGGER.info("取消置顶失败", e);
            DubboResult result = DubboResult.successResult(false);
            result.setMsg(e.getResultMessage());
            return result;
        } catch (Exception e) {
            LOGGER.error("取消置顶失败", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
