package cn.com.duiba.goods.center.biz.remoteservice.item;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AmbExpressTemplateOptionDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteAmbExpressTemplateOptionService;
import cn.com.duiba.goods.center.biz.service.item.AmbExpressTemplateOptionService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 加钱购运费模版选项
 */
@Service
public class RemoteAmbExpressTemplateOptionServiceImpl implements RemoteAmbExpressTemplateOptionService {

	@Autowired
	private AmbExpressTemplateOptionService ambExpressTemplateOptionService;

	@Override
	public DubboResult<AmbExpressTemplateOptionDto> find(Long id) {
		if (id == null) {
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
		return DubboResult.successResult(ambExpressTemplateOptionService.find(id));
	}

	@Override
	public DubboResult<Long> insert(AmbExpressTemplateOptionDto entity) {
		ambExpressTemplateOptionService.insert(entity);
		return DubboResult.successResult(entity.getId());
	}

	@Override
	public DubboResult<Integer> update(AmbExpressTemplateOptionDto entity) {
		if (entity == null || entity.getId() == null) {
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
		int ret = ambExpressTemplateOptionService.update(entity);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<AmbExpressTemplateOptionDto>> findByTemplateId(Long expressTemplateId) {
		if (expressTemplateId == null) {
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
		return DubboResult.successResult(ambExpressTemplateOptionService.findByTemplateId(expressTemplateId));
	}

	@Override
	public DubboResult<List<AmbExpressTemplateOptionDto>> findByTemplateIds(List<Long> ids) {
		return DubboResult.successResult(ambExpressTemplateOptionService.findByTemplateIds(ids));
	}

	@Override
	public DubboResult<Integer> deleteOptionByTemplateId(Long expressTemplateId) {
		if (expressTemplateId == null) {
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
		return DubboResult.successResult(ambExpressTemplateOptionService.deleteOptionByTemplateId(expressTemplateId));
	}

	@Override
	public DubboResult<Integer> batchInsert(List<AmbExpressTemplateOptionDto> ambExpressTemplateOptionDOs) {
		if (ambExpressTemplateOptionDOs.isEmpty()) {
			return DubboResult.successResult(0);
		}
		return DubboResult.successResult(ambExpressTemplateOptionService.batchInsert(ambExpressTemplateOptionDOs));
	}

}
