package cn.com.duiba.goods.center.biz.remoteservice.item;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AmbExpressTemplateDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteAmbExpressTemplateService;
import cn.com.duiba.goods.center.biz.service.item.AmbExpressTemplateService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 加钱购运费模版
 */
@Service
public class RemoteAmbExpressTemplateServiceImpl implements RemoteAmbExpressTemplateService {

	@Autowired
	private AmbExpressTemplateService ambExpressTemplateService;

	@Override
	public DubboResult<AmbExpressTemplateDto> find(Long id) {
		if (id == null) {
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
		AmbExpressTemplateDto dto = ambExpressTemplateService.find(id);
		return DubboResult.successResult(dto);
	}

	@Override
	public DubboResult<Long> insert(AmbExpressTemplateDto entity) {
		ambExpressTemplateService.insert(entity);
		return DubboResult.successResult(entity.getId());
	}

	@Override
	public DubboResult<Integer> update(AmbExpressTemplateDto entity) {
		if (entity == null || entity.getId() == null) {
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
		int ret = ambExpressTemplateService.update(entity);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<AmbExpressTemplateDto>> findPageList(Map<String, Object> params) {
		if (params.get("offset") == null || params.get("max") == null) {
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
		List<AmbExpressTemplateDto> ret = ambExpressTemplateService.findPageList(params);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Long> findPageCount(Map<String, Object> params) {
		Long ret = ambExpressTemplateService.findPageCount(params);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> deleteTemplateById(Long id) {
		if (id == null) {
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
		Integer ret = ambExpressTemplateService.deleteTemplateById(id);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<AmbExpressTemplateDto>> findByAppIdAndType(Long appId, String type) {
		List<AmbExpressTemplateDto> ret = ambExpressTemplateService.findByAppIdAndType(appId, type);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<AmbExpressTemplateDto>> findByAppIdAndName(Long appId, String name) {
		List<AmbExpressTemplateDto> ret = ambExpressTemplateService.findByAppIdAndName(appId, name);
		return DubboResult.successResult(ret);
	}

}
