package cn.com.duiba.goods.center.biz.remoteservice.item;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteAppItemGoodsBackendService;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.service.AppItemClassifyService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.wolf.dubbo.DubboResult;

@Service
public class RemoteAppItemGoodsBackendServiceImpl implements RemoteAppItemGoodsBackendService {

	@Autowired
	private AppItemService appItemService;
	@Autowired
	private ItemService itemService;
	@Autowired
	private AppItemClassifyService appItemClassifyService;

	@Override
	public DubboResult<Integer> updateStatusByActivityId(String status, Boolean deleted, Long activityId, int type) {
		Integer ret = appItemService.updateStatusByActivityId(status, deleted, activityId, type);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> findCountByItemId(Long itemId) {
		Integer ret = appItemService.findCountByItemId(itemId);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<AppItemDto>> findOnShelfByItemId(Long itemId) {
		List<AppItemDto> ret = appItemService.findOnShelfByItemId(itemId);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay) {
		Integer ret = appItemService.standUpOrDownAppItem(id, status, deleted, payload, homeDisplay);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> updateHdtoolAppItem(Long id, String title, String smallImage, String whiteImage, Long credits, String customPrice, String logo, Integer operationsType) {
		Integer ret = appItemService.updateHdtoolAppItem(id, title, smallImage, whiteImage, credits, customPrice, logo, operationsType);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> updateMainPushAppItem(Long id, String title, String logo, String smallImage, String whiteImage, String bannerImage, Long credits, String subtitle) {
		Integer ret = appItemService.updateMainPushAppItem(id, title, logo, smallImage, whiteImage, bannerImage, credits, subtitle);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<AppItemDto>> findAllBySourceTypeAndRelationIdAndDeleted(int sourceType, long sourceRelationId, Boolean deleted) {
		List<AppItemDto> ret = appItemService.findAllBySourceTypeAndRelationIdAndDeleted(sourceType, sourceRelationId, deleted);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Page<AppItemDto>> findPublishItemLimit(Map<String, Object> queryPublish) {
		Page<AppItemDto> ret = appItemService.findPublishItemLimit(queryPublish);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Page<AppItemDto>> findByLimit(Map<String, Object> params) {
		Page<AppItemDto> ret = appItemService.findByLimit(params);
		return DubboResult.successResult(ret);
	}
	
	@Override
    public DubboResult<List<Long>> findSelfAppItemIdsByAppId(Long appId,List<String> types,Integer warnLine){
	    List<Long> ret = appItemService.findSelfAppItemIdsByAppId(appId,types,warnLine);
	    return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<AppItemDto>> findAllByAppIdAndInType(Long appId, String[] types) {
		if(appId == null || types == null || types.length < 1){
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
		for(String type : types){
			if(!itemService.isRechargeGoods(type)){
				return DubboResult.failResult(ErrorCode.E0404004.getDesc());
			}
		}
        return DubboResult.successResult(appItemService.findAllByAppIdAndInType(appId, types));
	}

	@Override
	public DubboResult<Integer> findOnlineCount(Long appId) {
		if(appId == null){
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
		return DubboResult.successResult(appItemService.findOnlineCount(appId));
	}

	@Override
	public DubboResult<Integer> getRemaining0Count(Long appId) {
		if(appId == null){
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
		return DubboResult.successResult(appItemService.getRemaining0Count(appId));
	}

	@Override
	public DubboResult<Long> getOrAddAppItemId(String type, Long appId, Long appCreditsRate) {
		if (StringUtils.isEmpty(type) || appId == null || appCreditsRate == null) {
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
		Long id = appItemService.getOrAddAppItemId(type, appId, appCreditsRate);
		return DubboResult.successResult(id);
	}

	@Override
	public DubboResult<List<AppItemDto>> findAllUpVirtaulAppItems(Long appId) {
		if(appId == null){
			return DubboResult.failResult(ErrorCode.E0404004.getDesc());
		}
        return DubboResult.successResult(appItemService.findAllUpVirtaulAppItems(appId));
	}

	@Override
	public DubboResult<Boolean> doBatchDel(Long appId, Long developerId, List<Long> appItemIds) {
		return DubboResult.successResult(appItemService.doBatchDel(appId, appItemIds));
	}

	@Override
	public DubboResult<Long> addTestAppItem(Long appId) {
        return DubboResult.successResult(appItemService.addTestCoupon(appId));
	}

	@Override
	public DubboResult<Integer> bathcStandUp(Long appId, String virtualExchangeUrl, List<Long> appItemIds) {
		return DubboResult.successResult(appItemService.bathcStandUp(appId, virtualExchangeUrl, appItemIds));
	}

	@Override
	public DubboResult<Boolean> standUpOrDown(Long appId, Long appItemId, String status) {
		return DubboResult.successResult(appItemService.updateStatus(appId, appItemId, status));
	}

	@Override
	public DubboResult<Integer> sortClassifyAppItem(Long classifyId, List<Long> appItemIds) {
		return DubboResult.successResult(appItemClassifyService.sortClassifyAppItem(classifyId, appItemIds));
	}

	@Override
	public DubboResult<Boolean> doUpdateOwnerObject(AppItemDto appItem, Integer preRemaining, Integer remaining, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas) {
		return DubboResult.successResult(appItemService.doUpdateOwnerObject(appItem, preRemaining, remaining, exchangeLimit, arealimitSwitch, arealimitType, arealimitAreas));
	}

}
