package cn.com.duiba.goods.center.biz.remoteservice.item;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ExchangeStockWarnDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.StockWarnEmailDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteDuibaItemGoodsBackendService;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;

@Service
public class RemoteDuibaItemGoodsBackendServiceImpl implements RemoteDuibaItemGoodsBackendService {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDuibaItemGoodsBackendServiceImpl.class);

	@Autowired
	private ItemService itemService;

	@Override
	public DubboResult<List<ItemDto>> findByInTypes(List<String> types) {
		for (String type : types) {
			if (!itemService.isRechargeGoods(type)) {
				throw new RuntimeGoodsException(ErrorCode.E0404004);
			}
		}
		List<ItemDto> dtos = itemService.findByInTypes(types);
		return DubboResult.successResult(dtos);
	}

	@Override
	public DubboResult<List<ItemDto>> findAllByName(String name) {
		List<ItemDto> ret = itemService.findAllByName(name);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<ItemDto>> findAllByExpressTemplateId(Long expressTemplateId) {
		List<ItemDto> ret = itemService.findAllByExpressTemplateId(expressTemplateId);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> updateAutoOffDateNull(Long id) {
		Integer ret = itemService.updateAutoOffDateNull(id);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> updateLimitCountNull(Long id) {
		Integer ret = itemService.updateLimitCountNull(id);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> updateValidEndDateById(Long id, Date validEndDate) {
		Integer ret = itemService.updateValidEndDateById(id, validEndDate);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> updateOperationsTypeById(Long id, Integer operationsType) {
		Integer ret = itemService.updateOperationsTypeById(id, operationsType);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<ItemDto> findBySourceRelationIdAndSourceType(Long sourceRelationId, Integer sourceType) {
		ItemEntity entity = itemService.findBySourceRelationIdAndSourceType(sourceRelationId, sourceType);
		ItemDto ret = BeanUtils.copy(entity, ItemDto.class);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<ItemDto>> findAllActivityItemAndEnable(Boolean enable) {
		List<ItemDto> ret = itemService.findAllActivityItemAndEnable(enable);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<ItemDto>> findAllForDuibaSecondsKill() {
		List<ItemDto> ret = itemService.findAllForDuibaSecondsKill();
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<ItemDto>> findAllTargetItemList(String type, Boolean deleted, Integer subType) {
		List<ItemDto> ret = itemService.findAllTargetItemList(type, deleted, subType);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Page<ItemDto>> findAdminItemPage(Map<String, Object> query) {
		Page<ItemDto> ret = itemService.findAdminItemPage(query);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Page<ItemDto>> findRecommandItems(String itemName) {
		Page<ItemDto> ret = itemService.findRecommandItems(itemName);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> updateAutoRecommendById(Long id, Boolean autoRecommend) {
		Integer ret = itemService.updateAutoRecommendById(id, autoRecommend);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> updatePayloadById(Long id, Integer payload) {
		Integer ret = itemService.updatePayloadById(id, payload);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<Long>> findAutoRecommendAndTagsItems(Long tagsId) {
		List<Long> ret = itemService.findAutoRecommendAndTagsItems(tagsId);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<ItemDto>> findAllByNameAndType4Lottery(String name, String type) {
		List<ItemDto> ret = itemService.findAllByNameAndType4Lottery(name, type);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<Long>> findIdAllByEnable(Boolean enable) {
		List<Long> ret = itemService.findIdAllByEnable(enable);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> updateItemClassifyIdNullById(Long id) {
		Integer ret = itemService.updateItemClassifyIdNullById(id);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<ItemDto>> findAllByClassify(List<Long> classifyIds) {
		List<ItemDto> ret = itemService.findAllByClassify(classifyIds);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<ItemDto>> findAllEnableCoupon() {
		List<ItemDto> ret = itemService.findAllEnableCoupon();
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Page<ExchangeStockWarnDto>> findExchangeStockWarnList(Map<String, Object> queryMap) {
		Page<ExchangeStockWarnDto> ret = itemService.findExchangeStockWarnList(queryMap);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<ExchangeStockWarnDto>> findItemStockWarns(Map<String, Object> queryMap) {
		itemService.findItemStockWarns(queryMap);
		return DubboResult.successResult(null);
	}

	@Override
	public DubboResult<Void> emptyExchangeStockWarn() {
		itemService.emptyExchangeStockWarn();
		return DubboResult.successResult(null);
	}

	@Override
	public DubboResult<Void> saveExchangeStockWarn(ExchangeStockWarnDto exchangeStockWarn) {
		itemService.saveExchangeStockWarn(exchangeStockWarn);
		return DubboResult.successResult(null);
	}

	@Override
	public DubboResult<List<StockWarnEmailDto>> findEmailStockList(Map<String, Object> queryMap) {
		List<StockWarnEmailDto> ret = itemService.findEmailStockList(queryMap);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Void> saveEmailStockWarn(String emailStr) {
		itemService.saveEmailStockWarn(emailStr);
		return DubboResult.successResult(null);
	}

	@Override
	public DubboResult<Void> emptyEmailStockWarn() {
		itemService.emptyEmailStockWarn();
		return DubboResult.successResult(null);
	}

	@Override
	public DubboResult<Long> findDuibaItemChooseCount(Map<String, Object> paramMap) {
		return DubboResult.successResult(itemService.findDuibaItemChooseCount(paramMap));
	}

	@Override
	public DubboResult<List<ItemDto>> findAllBlacklistItem() {
		return DubboResult.successResult(itemService.findAllBlacklistItem());
	}

	@Override
	public DubboResult<List<ItemDto>> findAutoOffItem() {
		return DubboResult.successResult(itemService.findAutoOffItem());
	}

	@Override
	public DubboResult<Boolean> changeStatus(Long itemId, Boolean enable) {
		try {
			Boolean ret = itemService.changeStatus(itemId, enable);
			return DubboResult.successResult(ret);
		} catch (RuntimeGoodsException e) {
			LOGGER.warn("changeStatus",e);
			return DubboResult.failResult(e.getMessage());
		}
	}

}
