package cn.com.duiba.goods.center.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.AppItemClassifyDto;
import cn.com.duiba.goods.center.biz.dao.AppItemClassifyDao;
import cn.com.duiba.goods.center.biz.service.AppItemClassifyRelationService;
import cn.com.duiba.goods.center.biz.service.AppItemClassifyService;

/**
 * Created by xiaoxuda on 2016/11/17.
 */
@Service("appItemClassifyService")
public class AppItemClassifyServiceImpl implements AppItemClassifyService {
	
    @Autowired
    private AppItemClassifyDao appItemClassifyDao;
    
    @Autowired
    private AppItemClassifyRelationService appItemClassifyRelationService;

    @Override
    public AppItemClassifyDto find(Long id) {
        return appItemClassifyDao.find(id);
    }

	@Override
	public void deleteRelationAppItem(Long appItemId) {
		appItemClassifyRelationService.deleteRelationAppItem(appItemId);
	}

	@Override
	public int sortClassifyAppItem(Long classifyId, List<Long> appItemIds) {
        int sortNum = 0;
        Integer maxPayload = appItemClassifyDao.findMaxPayload(classifyId);
        if (maxPayload == null || maxPayload <= appItemIds.size()) {
            maxPayload = appItemIds.size();
        }
        Integer tempPayload = maxPayload;
        for (Long appItemId : appItemIds) {
            int ret = appItemClassifyDao.updatePayload(appItemId, classifyId, tempPayload);
            tempPayload = tempPayload - 1;
            sortNum = sortNum + ret;
        }
        return sortNum;
	}
}
