package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.api.remoteservice.constant.DevCustomizedConstants;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.service.DevCustomizedService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.util.DataSource;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by xiaoxuda on 2017/3/27.
 */
@Service
public class DevCustomizedServiceImpl implements DevCustomizedService {
    @Autowired
    private AppItemService appItemService;

    @Override
    @Transactional(DataSource.CREDITS)
    public boolean indexItemSort(Long appId, List<Long> sortAppItemIds) throws GoodsException {
        if (sortAppItemIds == null || sortAppItemIds.isEmpty() || appId == null) {
            throw new GoodsException(ErrorCode.E0404004);
        }
        List<AppItemEntity> existAppItems = appItemService.findByIds(sortAppItemIds);
        if (existAppItems.size() != sortAppItemIds.size()) {//如果存在appItem,则存在虚传
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "数据不匹配");
        }
        for (AppItemEntity appItem : existAppItems) {
            if (appItem == null || !appItem.getAppId().equals(appId)) {
                throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "无权访问");
            }
            if (appItem.getPayload() >= DevCustomizedConstants.ITEM_TOP_START) {
                throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "排序项中存在置顶项");
            }
        }
        doPayloadReset(sortAppItemIds, 0, appId);
        return true;
    }

    @Override
    @Transactional(DataSource.CREDITS)
    public boolean setTop4IndexItem(Long appId, Long appItemId) throws GoodsException {
        AppItemEntity appItem = appItemService.find(appItemId);
        if (appItem == null || !appItem.getAppId().equals(appId)) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "无权访问");
        }
        //检测是否可以置顶
        if (!AppItemDto.StatusOn.equals(appItem.getStatus())) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "没有上架的兑换项无法置顶");
        }
        if (appItem.getPayload() >= DevCustomizedConstants.ITEM_TOP_START) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "此商品项已为置顶状态");
        }
        List<Long> topIds = appItemService.findTopAppItemIdsDescByPayload(appId);
        if (topIds.size() >= DevCustomizedConstants.ITEM_TOP_NUM) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "置顶项数已经达到上限");
        }
        List<Long> newTopIds = Lists.newArrayList();
        newTopIds.add(appItemId);
        newTopIds.addAll(topIds);
        doPayloadReset(newTopIds, DevCustomizedConstants.ITEM_TOP_START, appId);
        //回归检测
        int topNum = appItemService.findTopAppItemIdsDescByPayload(appId).size();
        if (topNum > DevCustomizedConstants.ITEM_TOP_NUM) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "置顶项数已经达到上限");
        }
        return true;
    }

    @Override
    @Transactional(DataSource.CREDITS)
    public boolean cancelTop4IndexItem(Long appId, Long appItemId) throws GoodsException {
        AppItemEntity appItem = appItemService.find(appItemId);
        if (appItem == null || !appItem.getAppId().equals(appId)) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "无权访问");
        }
        //检测是否可以置顶
        if (appItem.getPayload() < DevCustomizedConstants.ITEM_TOP_START) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "此商品项不是置顶兑换项");
        }
        if (!AppItemDto.StatusOn.equals(appItem.getStatus())) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "没有上架的兑换项不需要取消置顶");
        }
        //恢复到兑换项正常的顶部
        int payload = appItemService.findAppMaxPayload(appId);
        appItemService.updateAppItemPayload(appId, appItemId, payload + 1);
        return true;
    }

    /**
     * 重置商品权重，使目标权重按传入的list顺序倒叙
     *
     * @param appItemIds
     * @param start
     * @param appId
     */
    private void doPayloadReset(List<Long> appItemIds, int start, Long appId) {
        if (appItemIds == null || appItemIds.isEmpty() || appId == null) {
            return;
        }
        int size = appItemIds.size();
        for (int i = size; i > 0; i--) {
            int payload = size - i + start;
            Long id = appItemIds.get(i - 1);
            appItemService.updateAppItemPayload(appId, id, payload);
        }

        //修复商品上架状态，如果兑吧商品已经下架或者被禁用了，修复开发者库对应商品为下架状态
        appItemService.updateOfflineAppItem4Disable(appId);
    }
}
