package cn.com.duiba.goods.center.biz.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.TbGoodsOpenUrlDto;
import cn.com.duiba.goods.center.biz.dao.TbGoodsOpenurlDao;
import cn.com.duiba.goods.center.biz.service.TbGoodsOpenurlService;

/**
 * 马上使用按钮
 */
@Service
public class TbGoodsOpenurlServiceImpl implements TbGoodsOpenurlService {

	@Autowired
	private TbGoodsOpenurlDao tbGoodsOpenurlDao;
	
	@Override
	public TbGoodsOpenUrlDto findTbGoodsOpenurl(Long gid, Integer gtype) {
		return tbGoodsOpenurlDao.findTbGoodsOpenurl(gid,gtype);
	}

	@Override
	public void updateTbGoodsOpenurl(TbGoodsOpenUrlDto item) {
		if(item.getGid() == null || item.getGtype() == null ){
			return ;
		}
		TbGoodsOpenUrlDto items = tbGoodsOpenurlDao.findTbGoodsOpenurl(item.getGid(),item.getGtype());
		if(items == null){
			tbGoodsOpenurlDao.insertTbGoodsOpenurl(item);
		}else{
			item.setId(items.getId());
			tbGoodsOpenurlDao.updateTbGoodsOpenurl(item);
		}
	}

	@Override
	public void insertTbGoodsOpenurl(TbGoodsOpenUrlDto item) {
		tbGoodsOpenurlDao.insertTbGoodsOpenurl(item);
	}

}
