package cn.com.duiba.goods.center.biz.service.item;

import java.util.List;
import java.util.Map;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;

/**
 * Created by liuyao on 2016/11/16.
 * 查询首页展示的商品项
 */
public interface HomeAppItemService {

	/**
	 * 根据appId查询首页appItem
	 * @param appId
	 * @return
	 */
    List<AppItemDto> findhomeAppItemNeed(Long appId);

    /**
     * 根据appId查询指定数量的已上架商品用于首页展示
     * 条件：状态为开启且未删除、首页展示开关打开
     * 按权重由大到小倒叙排列
     * @param appId
     * @param limitCount
     * @return
     */
    List<AppItemDto> findHomeItemKeyByAppIdAndLimitCount(long appId, int limitCount);

    /**
     * 查询banner和Icon
     * @param appId
     * @param appItemIds
     * @return
     */
    List<AppItemDto> findBannerIconAppItemByCache(Long appId,List<Long> appItemIds);
    
    /**
     * 分页查询
     * @param params
     * @return
     */
    List<AppItemDto> findByLimitCache(Long appId, Map<String, Object> params);
}
