package cn.com.duiba.goods.center.biz.service.item;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ExchangeStockWarnDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.StockWarnEmailDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;

/**
 * itemservice Created by gyf . 16/10/25 .
 */
public interface ItemService {

	/**
	 * 获取一个remaining 表示正确库存值的item 对象
	 * 
	 * @param id
	 * @return
	 */
	ItemEntity findCorrectStockItem(Long id);

	/**
	 * 根据ID查询应用商品信息
	 * 
	 * @param id
	 * @return
	 */
	public ItemEntity find(Long id);
	
	/**
	 * 查询兑吧兑换项根据类型，只用户查询兑吧固定的几个自冲类商品
	 * 
	 * @param type
	 * @return
	 */
	public ItemEntity findByType(String type);
	
	/**
	 * 根据ID集合查询应用商品信息
	 * 
	 * @param ids
	 * @return
	 */
	public List<ItemEntity> findByIds(List<Long> ids);
	
	/**
	 * 根据ID集合查询应用商品信息
	 * @param ids
	 * @return  <itemId, ItemEntity> 
	 */
	public Map<Long, ItemEntity> findByIdsToMap(List<Long> ids);

	/**
	 * 创建商品
	 * 
	 * @param itemEntity
	 * @return
	 */
	public Long insert(ItemEntity itemEntity);

	/**
	 * 修改商品
	 * 
	 * @param itemEntity
	 * @return
	 */
	public Boolean update(ItemEntity itemEntity);

	/**
	 * 删除商品
	 * 
	 * @param itemId
	 * @return
	 */
	public Boolean delete(Long itemId);

	/**
	 * 修改启用禁用
	 * 
	 * @param itemId
	 * @param enable
	 * @return
	 */
	public Boolean updateEnable(Long itemId, Boolean enable);

	/**
	 * 查询定向库存
	 * 
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public Long findSpecifyRemaining(Long appId, Long itemId);

	/**
	 * 减一个库存
	 * 
	 * @param itemId
	 * @return
	 */
	public Boolean decrStock(Long itemId);

	/**
	 * 增加一个库存
	 * 
	 * @param itemId
	 * @return
	 */
	public Boolean incrStock(Long itemId);

	/**
	 * 编辑商品，增加库存
	 * 
	 * @param itemId
	 * @param number
	 * @return
	 */
	public Boolean appendStock(Long itemId, Long number);

	/**
	 * 编辑商品，减少库存
	 * 
	 * @param itemId
	 * @param number
	 * @return
	 */
	public Boolean deductStock(Long itemId, Long number);
	
	/**
	 * 修改库存和过期时间
	 * @param appItemId
	 * @param totalStock
	 * @param validEndDate
	 * @return
	 */
	public int updateRemainingAndvalidEndDate(Long itemId, Long totalStock, Date validEndDate);

	/**
	 * 查询兑吧自动推荐商品
	 * 
	 * @param appId
	 * @return
	 */
	public List<ItemEntity> findAutoRecommend(Long appId);
	
	/**
	 * 查询兑吧自动推荐商品
	 * @param appId
	 * @param query
	 * @return
	 */
	public List<ItemEntity> findAutoRecommendMap(Long appId, Map<String, Object> query);

	/**
	 * 是否是直冲类商品
	 * 
	 * @param entity
	 * @return
	 */
	public Boolean isRechargeGoods(String type);
    
	/**
	 * 查询首页ItemDto
	 * @param itemIds
	 * @return
	 */
    public List<ItemDto> findHomeItems(List<Long> itemIds);
    
    /**
     * 移除缓存
     * @param itemId
     */
    public void removeCache(Long itemId);
    
    /**
     * 查询JSONVALUE
     * @param key
     * @param value
     * @return
     */
    public String getJsonValue(Long id, String key);
    /**
     * 设置JSONVALUE
     * @param id
     * @param key
     * @return
     */
    public Integer setJsonValue(Long id, String key, String value);
    
    /**
     * 修改优惠券商品类型
     * @param id
     * @param subType
     * @return
     */
    public Integer updateSubTypeById(Long id, Integer subType);

    /**
     * findBySourceRelationIdAndSourceType
     * @param sourceRelationId
     * @param sourceType
     * @return
     */
	public ItemEntity findBySourceRelationIdAndSourceType(Long sourceRelationId, Integer sourceType);
	
	/**
	 * 根据type查询（仅限于自冲类）
	 */
	public List<ItemDto> findByInTypes(List<String> types);

	/**
	 * 根据名称搜索
	 * 
	 * @param name
	 * @return
	 */
	public List<ItemDto> findAllByName(String name);

	/**
	 * 根据模版ID查询引用的商品
	 * 
	 * @param expressTemplateId
	 * @return
	 */
	public List<ItemDto> findAllByExpressTemplateId(Long expressTemplateId);

	/**
	 * 自动关闭时间置为null
	 * 
	 * @param id
	 * @return
	 */
	public Integer updateAutoOffDateNull(Long id);

	/**
	 * 把限制次数置为空
	 * 
	 * @param id
	 * @return
	 */
	public Integer updateLimitCountNull(Long id);

	/**
	 * 根据ID
	 * 
	 * @param id
	 * @param validEndDate
	 * @return
	 */
	public Integer updateValidEndDateById(Long id, Date validEndDate);

	/**
	 * 修改位运算
	 * 
	 * @param id
	 * @param operationsType
	 */
	public Integer updateOperationsTypeById(Long id, Integer operationsType);

	/**
	 * 获取所有能添加到专题活动中的兑吧兑换项
	 * 
	 * @param enable
	 * @return
	 */
	public List<ItemDto> findAllActivityItemAndEnable(Boolean enable);

	/**
	 * 获取可以展示在秒杀专题中的兑换项
	 */
	public List<ItemDto> findAllForDuibaSecondsKill();

	/**
	 * 获取库存迁移目标Item列表
	 * 
	 * @param type
	 * @param deleted
	 * @param subType
	 * @return
	 */
	public List<ItemDto> findAllTargetItemList(String type, Boolean deleted, Integer subType);

	/**
	 * 管理员后台分页查询item列表
	 * 
	 * @param query
	 * @return
	 */
	public Page<ItemDto> findAdminItemPage(Map<String, Object> query);

	/**
	 * 查询推荐中的兑换项，管理员后台使用
	 * 
	 * @param itemName
	 * @return
	 */
	public Page<ItemDto> findRecommandItems(String itemName);

	/**
	 * 修改是否自动推荐
	 * 
	 * @param id
	 * @param autoRecommend
	 * @return
	 */
	public Integer updateAutoRecommendById(Long id, Boolean autoRecommend);

	/**
	 * 更新payload
	 * 
	 * @param id
	 * @param payload
	 * @return
	 */
	public Integer updatePayloadById(Long id, Integer payload);

	/**
	 * 系统推荐的兑换项 + 关联的兑换项（可能包含不是自动推荐的兑换项） 二者互斥关系
	 * 
	 * @param tagsId
	 * @return
	 */
	public List<Long> findAutoRecommendAndTagsItems(Long tagsId);

	/**
	 * 获取给活动用的items
	 * 
	 * @param name
	 * @param type
	 * @return
	 */
	public List<ItemDto> findAllByNameAndType4Lottery(String name, String type);

	/**
	 * 查询所有启用状态的兑换项的id
	 * 
	 * @param enable
	 * @return
	 */
	public List<Long> findIdAllByEnable(Boolean enable);

	/**
	 * 把分类ID置为空
	 * 
	 * @param id
	 * @return
	 */
	public Integer updateItemClassifyIdNullById(Long id);

	/**
	 * 根据分类ids进行in查询
	 * 
	 * @param classifyIds
	 * @return
	 */
	public List<ItemDto> findAllByClassify(List<Long> classifyIds);

	/**
	 * 查询所有管理员后台所有启用状态的优惠券，按id倒序
	 */
	public List<ItemDto> findAllEnableCoupon();

	/**
	 * 兑换项库存列表查询
	 * 
	 * @param queryMap
	 * @return
	 */
	public Page<ExchangeStockWarnDto> findExchangeStockWarnList(Map<String, Object> queryMap);

	/**
	 * 查询兑换项库存预警列表
	 * 
	 * @param queryMap
	 * @return
	 */
	public List<ExchangeStockWarnDto> findItemStockWarns(Map<String, Object> queryMap);

	/**
	 * 清空兑换项库存表
	 */
	public void emptyExchangeStockWarn();

	/**
	 * 插入兑换项库存表
	 * 
	 * @param exchangeStockWarn
	 */
	public void saveExchangeStockWarn(ExchangeStockWarnDto exchangeStockWarn);

	/**
	 * 库存邮箱预警列表
	 * @param queryMap
	 * @return
	 */
	public List<StockWarnEmailDto> findEmailStockList(Map<String, Object> queryMap);

	/**
	 * 库存邮箱预警保存
	 * @param emailStr
	 */
	public void saveEmailStockWarn(String emailStr);
	
    /**
     * 库存邮箱预警清空
     */
    public void emptyEmailStockWarn();
    
    /**
     * 开发者后台兑吧待选库的查询总数
     */
    public Long findDuibaItemChooseCount(Map<String, Object> paramMap);
    
    /**
     * 获取所有的黑名单兑换项
     */
    public List<ItemDto> findAllBlacklistItem();
    
    /**
     * 查询当天的autooff优惠券实物商品
     * @return
     */
    public List<ItemDto> findAutoOffItem();
    
    /**
     * 变更启用禁用
     * @param id
     * @param enable
     * @return
     */
    public Boolean changeStatus(Long id, boolean enable);
    
}
