package cn.com.duiba.goods.center.biz.service.item.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ItemLinkActivityCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.biz.dao.item.ItemDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemExtraDao;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.entity.ItemExtraEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.item.ActivityItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;

/**
 * 
 * ActivityItemServiceImpl
 *
 */
@Service("activityItemService")
public class ActivityItemServiceImpl implements ActivityItemService {

    @Autowired
    private ItemDao itemDao;

    @Autowired
    private ItemExtraDao itemExtraDao;

    @Autowired
    private ItemService itemService;

    @Autowired
    private GoodsBatchService goodsBatchService;

    @Override
    public List<ItemLinkActivityCouponDto> getLinkActivityCouponItems(String text) {
        Long id = null;
        if (StringUtils.isNotBlank(text) && StringUtils.isNumeric(text)) {
            id = Long.valueOf(text);
        }
        List<ItemLinkActivityCouponDto> result = new ArrayList<>();
        ItemEntity item = getLinkActivityCouponItemById(id);
        ItemLinkActivityCouponDto dto4id = null;
        if (item != null) {
            dto4id = new ItemLinkActivityCouponDto(item.getId(), item.getName4Admin(), item.getRemaining(), item.getEnable());
            result.add(dto4id);
        }
        List<ItemEntity> items = getLinkActivityCouponItemsByName4admin(text);
        if (CollectionUtils.isEmpty(items)) {
            return result;
        }
        for (ItemEntity it : items) {
            ItemLinkActivityCouponDto dto = new ItemLinkActivityCouponDto(it.getId(), it.getName4Admin(), it.getRemaining(), it.getEnable());
            if (dto.equals(dto4id)) {
                continue;
            }
            result.add(dto);
        }
        return result;
    }

    /**
     * 根据名称模糊查询
     * @param name4admin
     * @return
     */
    private List<ItemEntity> getLinkActivityCouponItemsByName4admin(String name4admin) {
        List<ItemExtraEntity> extras = itemExtraDao.findByName4Admin(name4admin);
        if (CollectionUtils.isEmpty(extras)) {
            return Collections.emptyList();
        }
        List<Long> itemIds = new ArrayList<>();
        Map<Long, ItemExtraEntity> extraMap = new HashMap<>();
        for (ItemExtraEntity it : extras) {
            if (it == null || it.getItemId() == null) {
                continue;   // 异常情况
            }
            itemIds.add(it.getItemId());
            extraMap.put(it.getItemId(), it);
        }
        if (CollectionUtils.isEmpty(itemIds)) {
            return Collections.emptyList();
        }
        List<ItemEntity> items = itemDao.findLinkActivityCouponItemsByIds(itemIds);
        if (items == null) {
            return Collections.emptyList();
        }
        for (ItemEntity it : items) {
            if (it.isOpTypeItem(ItemDto.OpTypeGoodsCoupon)) {
                Long stock = goodsBatchService.getSumBatchStockBatch(GoodsTypeEnum.DUIBA, it.getId());
                it.setRemaining(Integer.valueOf(stock.toString()));
            }
            ItemExtraEntity extra = extraMap.get(it.getId());
            if (extra == null) {
                continue;
            }
            it.setName4Admin(extra.getName4Admin());
        }
        return items;
    }

    /**
     * 根据 id 获取链接券
     * @param id
     * @return
     */
    private ItemEntity getLinkActivityCouponItemById(Long id) {
        if (id == null) {
            return null;
        }
        ItemEntity item = itemService.findCorrectStockItem(id);
        if (item == null || item.getDeleted()) {
            return null;
        }
        if (!item.isOpTypeItem(ItemDto.OpTypeActivity)) {
            return null;
        }
        if (!ItemDto.TypeCoupon.equals(item.getType())) {
            return null;
        }
        if (ItemDto.SubTypeLink != item.getSubType()) {
            return null;
        }
        ItemExtraEntity itemExtra = itemExtraDao.findByItemId(item.getId());
        item.setName4Admin(itemExtra != null ? itemExtra.getName4Admin() : "");
        return item;
    }
}
