package cn.com.duiba.goods.center.biz.service.stock.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import cn.com.duiba.wolf.redis.RedisAtomicClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.biz.service.stock.MemStockService;

/**
 * 
 * 预分配每日限量库存
 */
@Service
public class MemStockServiceImpl implements MemStockService {

	private static final Logger LOGGER = LoggerFactory.getLogger(MemStockServiceImpl.class);
	
	@Resource(name="stringRedisTemplate03")
	private RedisAtomicClient redisAtomicClient;

	@Override
	public boolean consumeEverydayStock(String key, Integer limitStock) {
		try {
			String stocKey = "everydayStock" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + key;
			Long value = redisAtomicClient.getLong(stocKey);
			if (value != null) {
				if (value >= limitStock) {
					return false;
				}
			}
			redisAtomicClient.incrBy(stocKey, 1, 86400, TimeUnit.SECONDS);
			return true;
		} catch (Exception e) {
			LOGGER.error("consumeEverydayStock", e);
		}
		return false;
	}


}
