/**
 * Project Name:goods-center-biz
 * File Name:PcgDirectionalSalesVolumeServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.service.stock.impl
 * Date:2016年8月3日下午6:04:58
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.stock.impl;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.service.stock.PcgDirectionalSalesVolumeService;
import cn.com.duiba.stock.service.api.constant.SaleLimitTypes;
import cn.com.duiba.stock.service.api.remoteservice.RemoteSaleLimitService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:PcgDirectionalSalesVolumeServiceImpl <br/>
 * Date:     2016年8月3日 下午6:04:58 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("pcgDirectionalSalesVolumeService")
public class PcgDirectionalSalesVolumeServiceImpl implements PcgDirectionalSalesVolumeService{
    private static final Logger LOG=LoggerFactory.getLogger(PcgDirectionalSalesVolumeServiceImpl.class);
    @Autowired
    private RemoteSaleLimitService remoteSaleLimitService;
    @Override
    public Long findSaleCountToday(long pcgId, long directionId) {
        DubboResult<Long> todaySales=remoteSaleLimitService.findSaleCountToday(SaleLimitTypes.PcgDirectionalDayLimit, pcgId+"-"+directionId);
        if(!todaySales.isSuccess()){
            LOG.error("remoteSaleLimitService.findSaleCountToday success=false ,relationId="+(pcgId+"-"+directionId)+",msg="+todaySales.getMsg());
            return Long.MAX_VALUE;
        }
        return todaySales.getResult();
    }
    
    @Override
    public Map<String, Long> findSaleCountTodayBatch(List<GoodsDirectionalConfigEntity> list) {
        if(CollectionUtils.isEmpty(list)){
            return Maps.newHashMap();
        }
        List<String> relationIds = Lists.newArrayList();
        for(GoodsDirectionalConfigEntity entity : list){
            relationIds.add(entity.getGoodsId()+"-"+entity.getId());
        }
        DubboResult<Map<String, Long>> todaySales=remoteSaleLimitService.findSaleCountTodayBatch(SaleLimitTypes.PcgDirectionalDayLimit, relationIds);
        if(!todaySales.isSuccess()){
            LOG.error("remoteSaleLimitService.findSaleCountToday success=false ,relationIds="+relationIds+",msg="+todaySales.getMsg());
            return Maps.newHashMap();
        }
        return todaySales.getResult();
    }

    @Override
    public boolean addSaleToday(long pcgId, long directionId, String orderNum, int dayLimit) {
        DubboResult<Boolean> ret=remoteSaleLimitService.addSaleToday(SaleLimitTypes.PcgDirectionalDayLimit, pcgId+"-"+directionId, orderNum, dayLimit);
        if(!ret.isSuccess()){
            LOG.error("remoteSaleLimitService.addSaleToday success=false ,orderNum="+orderNum+", msg="+ret.getMsg());
            return false;
        }
        if(!ret.getResult()){
            LOG.error("remoteSaleLimitService.addSaleToday result=false ,orderNum="+orderNum);
            return false;
        }
        return true;
    }

    @Override
    public boolean rollbackSale(long pcgId, long directionId, String orderNum) {
        DubboResult<Boolean> ret=remoteSaleLimitService.rollbackSaleToday(SaleLimitTypes.PcgDirectionalDayLimit, pcgId+"-"+directionId, orderNum);
        if(!ret.isSuccess()){
            LOG.error("remoteSaleLimitService.rollbackSaleToday success=false,key="+(pcgId+"-"+directionId)+",orderNum="+orderNum+",msg="+ret.getMsg());
            return false;
        }
        if(!ret.getResult()){
            LOG.error("remoteSaleLimitService.rollbackSaleToday result=false,orderNum="+orderNum);
            return false;
        }
        return true;
    }

}

