/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.service.stock.StockService;
import cn.com.duiba.goods.center.biz.util.ConsumeStockTypeUtil;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="goodsCouponBO")
public class GoodsCouponBOImpl
implements GoodsCouponBO {
    private static Logger log = LoggerFactory.getLogger(GoodsCouponBOImpl.class);
    @Autowired
    @Qualifier(value="goodsCouponService4Speed")
    private GoodsCouponService goodsCouponService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private StockService stockService;

    @Override
    public void completeCoupon(Long couponId, long orderId) {
        this.goodsCouponService.completeCoupon(couponId, orderId);
    }

    @Override
    public Boolean rollbackCoupon(Long couponId, String bizNum) {
        Boolean succ;
        GoodsCouponEntity coupon = this.goodsCouponService.find(couponId);
        long goodsBatchId = coupon.getGoodsBatchId();
        GoodsBatchEntity batch = this.goodsBatchService.find(goodsBatchId);
        if (batch.getBatchType() == 0 && !(succ = this.goodsCouponService.rollbackNormalCoupon(couponId)).booleanValue()) {
            return succ;
        }
        DubboResult stockRet = this.remoteStockService.rollbackStock(ConsumeStockTypeUtil.getConsumeStockTypes(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype())).getType(), bizNum);
        if (!stockRet.isSuccess()) {
            log.error("remoteStockService.rollbackStock fail,couponId=" + couponId + ",bizNum=" + bizNum);
            return false;
        }
        return (Boolean)stockRet.getResult();
    }

    @Override
    public GoodsCouponEntity findCoupon(Long goodsCouponId) {
        return this.goodsCouponService.find(goodsCouponId);
    }

    @Override
    public Long findGoodsStock(GoodsTypeEnum gtype, long gid) {
        return this.goodsBatchService.getSumBatchStockBatch(gtype, gid);
    }

    @Override
    public List<GoodsStockDto> findGoodsStockByBatch(List<GoodsStockDto> goodsDtos) {
        ArrayList<GoodsStockDto> stocks = new ArrayList<GoodsStockDto>();
        if (goodsDtos == null) {
            return stocks;
        }
        EnumMap<GoodsTypeEnum, ArrayList<Long>> map = new EnumMap<GoodsTypeEnum, ArrayList<Long>>(GoodsTypeEnum.class);
        for (GoodsStockDto goodsStockDto : goodsDtos) {
            ArrayList<Long> gids = (ArrayList<Long>)map.get(goodsStockDto.getGtype());
            if (gids == null) {
                gids = new ArrayList<Long>();
            }
            gids.add(goodsStockDto.getGid());
            map.put(goodsStockDto.getGtype(), gids);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            List<ACGStockDto> dtos = this.goodsBatchService.findStockByGids((GoodsTypeEnum)entry.getKey(), (List)entry.getValue());
            for (ACGStockDto acg : dtos) {
                GoodsStockDto dto = new GoodsStockDto();
                dto.setGtype((GoodsTypeEnum)entry.getKey());
                dto.setGid(acg.getAcgId());
                dto.setStock(acg.getStock());
                dto.setTotalStock(acg.getTotalStock());
                stocks.add(dto);
            }
        }
        return stocks;
    }

    @Override
    public GoodsBatchEntity findBatch(Long goodsBatchId) {
        return this.goodsBatchService.find(goodsBatchId);
    }

    @Override
    public GoodsBatchEntity findUsingBatch(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> batchs = this.goodsBatchService.findNormalBatchs(gtype, gid);
        for (GoodsBatchEntity entity : batchs) {
            if (entity.getStatus() != 2) continue;
            return entity;
        }
        return null;
    }

    @Override
    public GoodsCouponDto takeCoupon(GoodsTypeEnum gtype, long gid, Long consumerId, Long appId, String bizNum) {
        GoodsBatchEntity using = this.getUsingBatch(gtype, gid);
        if (using == null) {
            return null;
        }
        return this.takeCouponInCycle(using, consumerId, appId, bizNum, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GoodsBatchEntity getUsingBatch(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)"getUsingBatch");
            GoodsBatchEntity using = this.findUsingBatch(gtype, gid);
            if (using != null) {
                GoodsBatchEntity goodsBatchEntity = using;
                return goodsBatchEntity;
            }
            GoodsBatchEntity nextUsing = this.goodsBatchService.refreshGoodsBatchs(gtype, gid);
            if (nextUsing != null) {
                GoodsBatchEntity goodsBatchEntity = nextUsing;
                return goodsBatchEntity;
            }
            GoodsBatchEntity goodsBatchEntity = null;
            return goodsBatchEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private GoodsCouponDto takeCouponInCycle(GoodsBatchEntity using, Long consumerId, Long appId, String bizNum, int count) {
        if (count > 5) {
            throw new RuntimeGoodsException(ErrorCode.E0404002);
        }
        GoodsTypeEnum gtype = GoodsTypeEnum.getGoodsTypeEnum((int)using.getGtype());
        int innerCount = count + 1;
        long gid = using.getGid();
        try {
            GoodsCouponEntity coupon = this.takeGoodsCoupon(using, consumerId, appId, bizNum);
            GoodsCouponDto dto = (GoodsCouponDto)BeanUtils.copy((Object)coupon, GoodsCouponDto.class);
            dto.setStartDay(using.getStartDay());
            dto.setOverDue(using.getEndDay());
            return dto;
        }
        catch (RuntimeGoodsException e) {
            if (e.getErrorCode() == ErrorCode.E0202005) {
                GoodsBatchEntity nextBatch = this.goodsBatchService.refreshGoodsBatchs(gtype, gid);
                if (nextBatch == null) {
                    return null;
                }
                return this.takeCouponInCycle(nextBatch, consumerId, appId, bizNum, innerCount);
            }
            throw e;
        }
    }

    private GoodsCouponEntity takeGoodsCoupon(GoodsBatchEntity using, Long consumerId, Long appId, String bizNum) {
        GoodsCouponEntity coupon;
        GoodsTypeEnum gtype = GoodsTypeEnum.getGoodsTypeEnum((int)using.getGtype());
        if (using.getBatchType() == 1) {
            coupon = this.goodsCouponService.takeLinkCoupon(gtype, using, consumerId, appId, bizNum);
        } else if (using.getBatchType() == 2) {
            coupon = this.goodsCouponService.takeRepeatCoupon(gtype, using, consumerId, appId, bizNum);
        } else if (using.getBatchType() == 0) {
            coupon = this.goodsCouponService.takeNormalCoupon(gtype, using, consumerId, appId, bizNum);
        } else {
            throw new RuntimeGoodsException(ErrorCode.E0202008);
        }
        return coupon;
    }
}

