/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteAddrLimitService;
import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.bo.AddrLimitBO;
import cn.com.duiba.goods.center.biz.service.item.AddrLimitService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteAddrLimitService")
public class RemoteAddrLimitServiceImpl
implements RemoteAddrLimitService {
    @Autowired
    private AddrLimitBO addrLimitBO;
    @Autowired
    private AddrLimitService addrLimitService;

    public DubboResult<List<ItemKeyDto>> getItemCanPassAddrLimit(List<ItemKeyDto> items, String ip) {
        return DubboResult.successResult(this.addrLimitBO.getItemCanPassAddrLimit(items, ip));
    }

    public DubboResult<Boolean> ipValidation(ItemKeyDto itemKeyDto, String ip) {
        Boolean ret = this.addrLimitBO.ipValidation(itemKeyDto, ip);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<List<AddrLimitDto>> findAddrLimitByGid(GoodsTypeEnum gtype, Long gid) {
        List<AddrLimitDto> ret;
        if (GoodsTypeEnum.APP.getGtype() == gtype.getGtype()) {
            ret = this.addrLimitService.findAddrLimitByAppItemId(gid);
        } else if (GoodsTypeEnum.DUIBA.getGtype() == gtype.getGtype()) {
            ret = this.addrLimitService.findAddrLimitByItemId(gid);
        } else {
            return DubboResult.failResult((String)ErrorCode.E0202008.getDesc());
        }
        return DubboResult.successResult(ret);
    }

    public DubboResult<Integer> findTypeByGid(GoodsTypeEnum gtype, Long gid) {
        Integer type;
        if (GoodsTypeEnum.APP.getGtype() == gtype.getGtype()) {
            type = this.addrLimitService.findTypeByAppItemId(gid);
        } else if (GoodsTypeEnum.DUIBA.getGtype() == gtype.getGtype()) {
            type = this.addrLimitService.findTypeByItemId(gid);
        } else {
            return DubboResult.failResult((String)ErrorCode.E0202008.getDesc());
        }
        return DubboResult.successResult((Object)type);
    }

    public DubboResult<Integer> batchInsertAddrLimit(List<AddrLimitDto> addrLimitList) {
        Integer ret = this.addrLimitService.batchInsertAddrLimit(addrLimitList);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Integer> deleteAddrLimit(Long itemId, Long appItemId) {
        Integer ret = this.addrLimitService.deleteAddrLimit(itemId, appItemId);
        return DubboResult.successResult((Object)ret);
    }
}

