/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.ElasticGiftsItemShowDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteItemGoodsService;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.ItemGoodsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteItemGoodsService")
public class RemoteItemGoodsServiceImpl
implements RemoteItemGoodsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteItemGoodsServiceImpl.class);
    @Autowired
    private ItemGoodsService itemGoodsService;

    public DubboResult<Boolean> checkElasticTakeOrder(Long itemId, Long appId, Long consumerId) {
        try {
            this.itemGoodsService.checkElasticTakeOrder(itemId, appId, consumerId);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("checkElasticTakeOrder ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ElasticGiftsItemShowDto>> getItemsByElItemIds4Mobile(List<Long> itemIds, Long appId, Long consumerId) {
        try {
            List<ElasticGiftsItemShowDto> result = this.itemGoodsService.getItemsByElItemIds4Mobile(itemIds, appId, consumerId);
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            LOGGER.error("getItemsByElItemIds ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ItemDto> find(Long itemId) {
        try {
            ItemEntity entity = this.itemGoodsService.find(itemId);
            ItemDto dto = new ItemDto();
            ObjectUtil.convert((Object)entity, (Object)dto);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            LOGGER.error("find:itemId= " + itemId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateEnable(Long itemId, boolean enable) {
        try {
            Boolean ret = this.itemGoodsService.updateEnable(itemId, enable);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("updateEnable:itemId= " + itemId + " enable=" + enable, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

