/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.AppItemClassifyDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.dao.AppItemClassifyDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.service.AppItemClassifyService;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="appItemClassifyService")
public class AppItemClassifyServiceImpl
implements AppItemClassifyService {
    @Autowired
    private AppItemClassifyDao appItemClassifyDao;
    @Autowired
    private GoodsBatchService goodsBatchService;

    @Override
    public AppItemClassifyDto find(Long id) {
        return this.appItemClassifyDao.find(id);
    }

    @Override
    public List<AppItemDto> findClassifyAppItems(Long classifyId, Long appId) {
        List<AppItemEntity> list = this.appItemClassifyDao.findClassifyAppItems(classifyId, appId);
        ArrayList appItemIds = Lists.newArrayList();
        for (AppItemEntity appItem : list) {
            if (!appItem.isOpTypeAppItem(16)) continue;
            appItemIds.add(appItem.getId());
        }
        HashMap<Long, Integer> appItemStock = new HashMap<Long, Integer>();
        if (CollectionUtils.isNotEmpty((Collection)appItemIds)) {
            List<ACGStockDto> stocks = this.goodsBatchService.findStockByGids(GoodsTypeEnum.APP, appItemIds);
            for (ACGStockDto dto : stocks) {
                appItemStock.put(dto.getAcgId(), Integer.valueOf(dto.getStock().toString()));
            }
            for (AppItemEntity appItem : list) {
                if (!appItem.isOpTypeAppItem(16)) continue;
                Integer stock = (Integer)appItemStock.get(appItem.getId());
                appItem.setRemaining(stock);
            }
        }
        return BeanUtils.copyList(list, AppItemDto.class);
    }
}

