/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.api.remoteservice.constant.DevCustomizedConstants;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.service.DevCustomizedService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DevCustomizedServiceImpl
implements DevCustomizedService {
    @Autowired
    private AppItemService appItemService;

    @Override
    @Transactional(value="credits")
    public boolean indexItemSort(Long appId, List<Long> sortAppItemIds) throws GoodsException {
        if (sortAppItemIds == null || sortAppItemIds.isEmpty() || appId == null) {
            throw new GoodsException(ErrorCode.E0404004);
        }
        List<AppItemEntity> existAppItems = this.appItemService.findByIds(sortAppItemIds);
        if (existAppItems.size() != sortAppItemIds.size()) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u6570\u636e\u4e0d\u5339\u914d");
        }
        for (AppItemEntity appItem : existAppItems) {
            if (appItem == null || !appItem.getAppId().equals(appId)) {
                throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u65e0\u6743\u8bbf\u95ee");
            }
            if (appItem.getPayload() < DevCustomizedConstants.ITEM_TOP_START) continue;
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u6392\u5e8f\u9879\u4e2d\u5b58\u5728\u7f6e\u9876\u9879");
        }
        this.doPayloadReset(sortAppItemIds, 0, appId);
        return true;
    }

    @Override
    @Transactional(value="credits")
    public boolean setTop4IndexItem(Long appId, Long appItemId) throws GoodsException {
        AppItemEntity appItem = this.appItemService.find(appItemId);
        if (appItem == null || !appItem.getAppId().equals(appId)) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u65e0\u6743\u8bbf\u95ee");
        }
        if (!"on".equals(appItem.getStatus())) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u6ca1\u6709\u4e0a\u67b6\u7684\u5151\u6362\u9879\u65e0\u6cd5\u7f6e\u9876");
        }
        if (appItem.getPayload() >= DevCustomizedConstants.ITEM_TOP_START) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u6b64\u5546\u54c1\u9879\u5df2\u4e3a\u7f6e\u9876\u72b6\u6001");
        }
        List<Long> topIds = this.appItemService.findTopAppItemIdsDescByPayload(appId);
        if (topIds.size() >= DevCustomizedConstants.ITEM_TOP_NUM) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u7f6e\u9876\u9879\u6570\u5df2\u7ecf\u8fbe\u5230\u4e0a\u9650");
        }
        ArrayList newTopIds = Lists.newArrayList();
        newTopIds.add(appItemId);
        newTopIds.addAll(topIds);
        this.doPayloadReset(newTopIds, DevCustomizedConstants.ITEM_TOP_START, appId);
        int topNum = this.appItemService.findTopAppItemIdsDescByPayload(appId).size();
        if (topNum > DevCustomizedConstants.ITEM_TOP_NUM) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u7f6e\u9876\u9879\u6570\u5df2\u7ecf\u8fbe\u5230\u4e0a\u9650");
        }
        return true;
    }

    @Override
    @Transactional(value="credits")
    public boolean cancelTop4IndexItem(Long appId, Long appItemId) throws GoodsException {
        AppItemEntity appItem = this.appItemService.find(appItemId);
        if (appItem == null || !appItem.getAppId().equals(appId)) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u65e0\u6743\u8bbf\u95ee");
        }
        if (appItem.getPayload() < DevCustomizedConstants.ITEM_TOP_START) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u6b64\u5546\u54c1\u9879\u4e0d\u662f\u7f6e\u9876\u5151\u6362\u9879");
        }
        if (!"on".equals(appItem.getStatus())) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u6ca1\u6709\u4e0a\u67b6\u7684\u5151\u6362\u9879\u4e0d\u9700\u8981\u53d6\u6d88\u7f6e\u9876");
        }
        int payload = this.appItemService.findAppMaxPayload(appId);
        this.appItemService.updateAppItemPayload(appId, appItemId, payload + 1);
        return true;
    }

    private void doPayloadReset(List<Long> appItemIds, int start, Long appId) {
        int size;
        if (appItemIds == null || appItemIds.isEmpty() || appId == null) {
            return;
        }
        for (int i = size = appItemIds.size(); i > 0; --i) {
            int payload = size - i + start;
            Long id = appItemIds.get(i - 1);
            this.appItemService.updateAppItemPayload(appId, id, payload);
        }
        this.appItemService.updateOfflineAppItem4Disable(appId);
    }
}

