/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.dao.GoodsTagsDao;
import cn.com.duiba.goods.center.biz.entity.GoodsTagsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsTagsService;
import cn.com.duiba.intersection.serivce.api.remoteservice.RemoteAppTagService;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.AppTagDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsTagsService")
public class GoodsTagsServiceImpl
implements GoodsTagsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoodsTagsServiceImpl.class);
    @Autowired
    private GoodsTagsDao goodsTagsDao;
    @Autowired
    private RemoteAppTagService remoteAppTagService;

    @Override
    public boolean savePCGTags(Long pcgId, String tags) {
        GoodsTagsEntity goodsTags = this.goodsTagsDao.selectByGidAndGtype(GoodsTypeEnum.PLATFORM.getGtype(), pcgId);
        if (goodsTags == null) {
            GoodsTagsEntity e4i = new GoodsTagsEntity();
            e4i.setGtype(GoodsTypeEnum.PLATFORM.getGtype());
            e4i.setGid(pcgId);
            e4i.setTags(tags);
            return this.goodsTagsDao.insert(e4i) > 0;
        }
        return this.goodsTagsDao.updateTagsById(goodsTags.getId(), tags) > 0;
    }

    @Override
    public GoodsTagsEntity selectByGidAndGtype(Integer gtype, Long gid) {
        return this.goodsTagsDao.selectByGidAndGtype(gtype, gid);
    }

    @Override
    public List<GoodsTagsEntity> findByPCGIds(List<Long> pcgIds) {
        if (pcgIds == null || pcgIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.goodsTagsDao.selectByGtypeAndGids(GoodsTypeEnum.PLATFORM.getGtype(), pcgIds);
    }

    @Override
    public List<Long> getPCGIdsByEntities(List<PlatformCouponGoodsEntity> pcgs) {
        if (pcgs == null) {
            return Collections.emptyList();
        }
        ArrayList<Long> pcgIds = new ArrayList<Long>();
        for (PlatformCouponGoodsEntity it : pcgs) {
            pcgIds.add(it.getPcgId());
        }
        return pcgIds;
    }

    @Override
    public Map<Long, String> getPCGTagsMapByIds(List<Long> pcgIds) {
        if (pcgIds == null || pcgIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<GoodsTagsEntity> goodsTags = this.findByPCGIds(pcgIds);
        HashMap<Long, String> pcgTagsMap = new HashMap<Long, String>();
        for (GoodsTagsEntity it : goodsTags) {
            pcgTagsMap.put(it.getGid(), it.getTags());
        }
        return pcgTagsMap;
    }

    @Override
    public Map<Long, String> getPCGTagsMapByEntities(List<PlatformCouponGoodsEntity> pcgs) {
        List<Long> pcgIds = this.getPCGIdsByEntities(pcgs);
        return this.getPCGTagsMapByIds(pcgIds);
    }

    @Override
    public HashMultimap<Long, String> getPCGTagsMap(List<Long> pcgIds) {
        HashMultimap maps = HashMultimap.create();
        if (pcgIds.isEmpty()) {
            return maps;
        }
        Splitter spl = Splitter.on((String)",").trimResults().trimResults();
        List<GoodsTagsEntity> goodsTags = this.findByPCGIds(pcgIds);
        for (GoodsTagsEntity tag : goodsTags) {
            if (StringUtils.isBlank((String)tag.getTags())) continue;
            maps.putAll((Object)tag.getGid(), spl.split((CharSequence)tag.getTags()));
        }
        return maps;
    }

    @Override
    public boolean containsAppTag(Long pcgId, Long appId) {
        GoodsTagsEntity goodsTagsEntity = this.goodsTagsDao.selectByGidAndGtype(GoodsTypeEnum.PLATFORM.getGtype(), pcgId);
        if (goodsTagsEntity == null || StringUtils.isBlank((String)goodsTagsEntity.getTags())) {
            return false;
        }
        List<String> appTags = this.getAppTags(appId);
        if (appTags == null || appTags.isEmpty()) {
            return false;
        }
        String[] pcgTags = goodsTagsEntity.getTags().split(",");
        ArrayList<String> pcgTagList = new ArrayList<String>(Arrays.asList(pcgTags));
        pcgTagList.retainAll(appTags);
        return !pcgTagList.isEmpty();
    }

    @Override
    public List<String> getAppTags(Long appId) {
        DubboResult result = this.remoteAppTagService.getAppTagById(appId);
        if (!result.isSuccess()) {
            LOGGER.error("\u8c03\u7528 tuia \u83b7\u53d6 app \u6807\u7b7e\u5f02\u5e38");
            return Collections.emptyList();
        }
        AppTagDto appTag = (AppTagDto)result.getResult();
        if (appTag == null) {
            return Collections.emptyList();
        }
        if (appTag.getAppId() == null || StringUtils.isBlank((String)appTag.getAppTags())) {
            return Collections.emptyList();
        }
        String[] tags = appTag.getAppTags().split(",");
        return new ArrayList<String>(Arrays.asList(tags));
    }
}

