/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryGoodsDto;
import cn.com.duiba.goods.center.biz.dao.PCGCategoryDao;
import cn.com.duiba.goods.center.biz.dao.PCGCategoryGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.impl.RedisFilterCache;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pCGCategoryGoodsService")
public class PCGCategoryGoodsServiceImpl
implements PCGCategoryGoodsService {
    @Autowired
    private PCGCategoryGoodsDao pcgCategoryGoodsDao;
    @Autowired
    private PCGCategoryDao pcgCategoryDao;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public Boolean addGoods2Category(long pcgId, long categoryId, Integer payload) {
        int ret;
        if (payload == null || payload == 0) {
            payload = this.pcgCategoryGoodsDao.selectMaxPayloadByCategory(categoryId);
            payload = payload + 1;
        }
        return (ret = this.pcgCategoryGoodsDao.insertGoods2Category(pcgId, categoryId, payload)) == 1;
    }

    @Override
    public Boolean removeGoodsFromCategory(long pcgId, long categoryId) {
        int ret = this.pcgCategoryGoodsDao.deleteGoods2Category(pcgId, categoryId);
        RedisFilterCache redisFilterCache = new RedisFilterCache(this.stringRedisTemplate);
        redisFilterCache.clearFilterCache(redisFilterCache.getCategoryGoodsRedisKey(String.valueOf(categoryId)));
        return ret == 1;
    }

    @Override
    @Transactional(value="pcg")
    public Boolean removeCategory(long categoryId) {
        RedisFilterCache redisFilterCache = new RedisFilterCache(this.stringRedisTemplate);
        redisFilterCache.clearFilterCache(redisFilterCache.getCategoryGoodsRedisKey(String.valueOf(categoryId)));
        redisFilterCache.clearFilterCache(redisFilterCache.getCategoryRedisKey());
        this.pcgCategoryDao.delete(categoryId);
        this.pcgCategoryGoodsDao.deleteCategoryRelation(categoryId);
        return true;
    }

    @Override
    public Boolean deleteAllByPcgId(long pcgId) {
        RedisFilterCache redisFilterCache = new RedisFilterCache(this.stringRedisTemplate);
        List<PCGCategoryGoodsEntity> pcgs = this.pcgCategoryGoodsDao.selectByGoods(pcgId);
        for (PCGCategoryGoodsEntity p : pcgs) {
            redisFilterCache.clearFilterCache(redisFilterCache.getCategoryGoodsRedisKey(String.valueOf(p.getCategoryId())));
        }
        this.pcgCategoryGoodsDao.deleteGoodsRelation(pcgId);
        return true;
    }

    @Override
    public Long addCategory(String name, Integer payload) {
        if (payload == null || payload == 0) {
            payload = this.pcgCategoryDao.selectMaxPayloadByCategory();
            payload = payload + 1;
        }
        return this.pcgCategoryDao.insert(name, payload);
    }

    @Override
    public void updateNameAndPayload(Long id, String name, Integer payload) {
        this.pcgCategoryDao.updateNameAndPayload(id, name, payload);
    }

    @Override
    public void updateCategoryPayload(Long id, int payload) {
        this.pcgCategoryDao.updatePayload(id, payload);
    }

    @Override
    public List<PCGCategoryEntity> findAll() {
        RedisFilterCache redisFilterCache = new RedisFilterCache(this.stringRedisTemplate);
        List<PCGCategoryEntity> categorys = (List<PCGCategoryEntity>)redisFilterCache.getFilterListCache(redisFilterCache.getCategoryRedisKey(), PCGCategoryEntity.class);
        if (categorys == null || categorys.isEmpty()) {
            categorys = this.pcgCategoryDao.selectAll();
        }
        return categorys;
    }

    @Override
    public PCGCategoryEntity findCategory(Long id) {
        return this.pcgCategoryDao.select(id);
    }

    @Override
    public void sortCategories(List<PCGCategoryDto> categories) {
        for (PCGCategoryDto dto : categories) {
            this.pcgCategoryDao.updatePayload(dto.getId(), dto.getPayload());
        }
    }

    @Override
    public void sortCategoryGoods(List<PCGCategoryGoodsDto> list) {
        for (PCGCategoryGoodsDto dto : list) {
            this.pcgCategoryGoodsDao.updatePayload(dto.getCategoryId(), dto.getPcgId(), dto.getPayload());
        }
    }

    @Override
    public List<PCGCategoryGoodsEntity> findAllGoodsByCategory(long categoryId) {
        return this.pcgCategoryGoodsDao.selectByCategory(categoryId);
    }

    @Override
    public List<PCGCategoryGoodsEntity> findAllGoodsByCateIds(List<Long> catIds) {
        if (catIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.pcgCategoryGoodsDao.selectAllGoodsByCateIds(catIds);
    }
}

