/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ItemLinkActivityCouponDto;
import cn.com.duiba.goods.center.biz.dao.item.ItemDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemExtraDao;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.entity.ItemExtraEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.item.ActivityItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activityItemService")
public class ActivityItemServiceImpl
implements ActivityItemService {
    @Autowired
    private ItemDao itemDao;
    @Autowired
    private ItemExtraDao itemExtraDao;
    @Autowired
    private ItemService itemService;
    @Autowired
    private GoodsBatchService goodsBatchService;

    @Override
    public List<ItemLinkActivityCouponDto> getLinkActivityCouponItems(String text) {
        List<ItemEntity> items;
        Long id = null;
        if (StringUtils.isNotBlank((String)text) && StringUtils.isNumeric((String)text)) {
            id = Long.valueOf(text);
        }
        ArrayList<ItemLinkActivityCouponDto> result = new ArrayList<ItemLinkActivityCouponDto>();
        ItemEntity item = this.getLinkActivityCouponItemById(id);
        ItemLinkActivityCouponDto dto4id = null;
        if (item != null) {
            dto4id = new ItemLinkActivityCouponDto(item.getId(), item.getName4Admin(), item.getRemaining(), item.getEnable());
            result.add(dto4id);
        }
        if (CollectionUtils.isEmpty(items = this.getLinkActivityCouponItemsByName4admin(text))) {
            return result;
        }
        for (ItemEntity it : items) {
            ItemLinkActivityCouponDto dto = new ItemLinkActivityCouponDto(it.getId(), it.getName4Admin(), it.getRemaining(), it.getEnable());
            if (dto.equals((Object)dto4id)) continue;
            result.add(dto);
        }
        return result;
    }

    private List<ItemEntity> getLinkActivityCouponItemsByName4admin(String name4admin) {
        List<ItemExtraEntity> extras = this.itemExtraDao.findByName4Admin(name4admin);
        if (CollectionUtils.isEmpty(extras)) {
            return Collections.emptyList();
        }
        ArrayList<Long> itemIds = new ArrayList<Long>();
        HashMap<Long, ItemExtraEntity> extraMap = new HashMap<Long, ItemExtraEntity>();
        for (ItemExtraEntity it : extras) {
            if (it == null || it.getItemId() == null) continue;
            itemIds.add(it.getItemId());
            extraMap.put(it.getItemId(), it);
        }
        if (CollectionUtils.isEmpty(itemIds)) {
            return Collections.emptyList();
        }
        List<ItemEntity> items = this.itemDao.findLinkActivityCouponItemsByIds(itemIds);
        if (items == null) {
            return Collections.emptyList();
        }
        for (ItemEntity it : items) {
            ItemExtraEntity extra;
            if (it.isOpTypeItem(16)) {
                Long stock = this.goodsBatchService.getSumBatchStockBatch(GoodsTypeEnum.DUIBA, it.getId());
                it.setRemaining(Integer.valueOf(stock.toString()));
            }
            if ((extra = (ItemExtraEntity)extraMap.get(it.getId())) == null) continue;
            it.setName4Admin(extra.getName4Admin());
        }
        return items;
    }

    private ItemEntity getLinkActivityCouponItemById(Long id) {
        if (id == null) {
            return null;
        }
        ItemEntity item = this.itemService.findCorrectStockItem(id);
        if (item == null || item.getDeleted().booleanValue()) {
            return null;
        }
        if (!item.isOpTypeItem(2)) {
            return null;
        }
        if (!"coupon".equals(item.getType())) {
            return null;
        }
        if (1 != item.getSubType()) {
            return null;
        }
        ItemExtraEntity itemExtra = this.itemExtraDao.findByItemId(item.getId());
        item.setName4Admin(itemExtra != null ? itemExtra.getName4Admin() : "");
        return item;
    }
}

