/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.cache.EventHomeCache;
import cn.com.duiba.goods.center.biz.dao.item.AppItemDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.RedisCacheService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="appItemService")
public class AppItemServiceImpl
implements AppItemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppItemServiceImpl.class);
    @Autowired
    private AppItemDao appItemDao;
    @Autowired
    private ItemService itemService;
    @Autowired
    private GoodsCouponBO goodsCouponBO;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Resource
    private EventHomeCache eventHomeCache;
    @Resource(name="stringRedisTemplate03")
    private AdvancedCacheClient advancedCacheClient;
    @Autowired
    private RedisCacheService redisCacheService;

    @Override
    public AppItemEntity find(Long id) {
        Long stock;
        AppItemEntity entity = this.appItemDao.find(id);
        if (entity == null) {
            return null;
        }
        if (entity.isOpTypeAppItem(16) && (stock = this.goodsBatchService.getSumBatchStockBatch(GoodsTypeEnum.APP, entity.getId())) != null) {
            entity.setRemaining(Integer.valueOf(stock.toString()));
        }
        return entity;
    }

    @Override
    public List<AppItemEntity> findByIds(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        List<AppItemEntity> entitys = this.appItemDao.findByIds(ids);
        ArrayList<GoodsStockDto> stocks = new ArrayList<GoodsStockDto>();
        for (AppItemEntity entity : entitys) {
            if (!entity.isOpTypeAppItem(16)) continue;
            GoodsStockDto stock = new GoodsStockDto();
            stock.setGid(entity.getId());
            stock.setGtype(GoodsTypeEnum.APP);
            stocks.add(stock);
        }
        if (!stocks.isEmpty()) {
            List<GoodsStockDto> gst = this.goodsCouponBO.findGoodsStockByBatch(stocks);
            HashMap<Long, Integer> map = new HashMap<Long, Integer>();
            for (GoodsStockDto dto : gst) {
                map.put(dto.getGid(), Integer.valueOf(dto.getStock().toString()));
            }
            for (AppItemEntity entity : entitys) {
                if (!entity.isOpTypeAppItem(16)) continue;
                Integer stock = (Integer)map.get(entity.getId());
                entity.setRemaining(stock);
            }
        }
        return entitys;
    }

    @Override
    public Long insert(AppItemEntity appItemEntity) {
        this.appItemDao.insert(appItemEntity);
        this.eventHomeCache.invalidApp(appItemEntity.getAppId());
        return appItemEntity.getId();
    }

    @Override
    public Boolean update(AppItemEntity appItemEntity) {
        int ret = this.appItemDao.update(appItemEntity);
        if (ret > 0) {
            this.eventHomeCache.invalidApp(appItemEntity.getAppId());
            this.cacheClear(this.getKeyById(appItemEntity.getId()));
            return true;
        }
        return false;
    }

    @Override
    public Boolean delete(Long appId, Long appItemId) {
        int ret = this.appItemDao.delete(appId, appItemId);
        if (ret > 0) {
            this.eventHomeCache.invalidApp(appId);
            this.cacheClear(this.getKeyById(appItemId));
            return true;
        }
        return false;
    }

    @Override
    public Integer deleteByIds(Long appId, List<Long> appItemIds) {
        int ret = this.appItemDao.deleteByIds(appId, appItemIds);
        this.eventHomeCache.invalidAppItem(appItemIds);
        for (Long id : appItemIds) {
            this.asyncClearCache(id);
        }
        return ret;
    }

    @Override
    public Boolean updateStatus(Long appId, Long appItemId, String status) {
        int ret = this.appItemDao.updateStatus(appId, appItemId, status);
        if (ret > 0) {
            this.eventHomeCache.invalidAppItem(appItemId);
            this.cacheClear(this.getKeyById(appItemId));
            return true;
        }
        return false;
    }

    @Override
    public Integer updateStatusByIds(Long appId, List<Long> appItemIds, String status) {
        int ret = this.appItemDao.updateStatusByIds(appId, appItemIds, status);
        this.eventHomeCache.invalidAppItem(appItemIds);
        for (Long id : appItemIds) {
            this.asyncClearCache(id);
        }
        return ret;
    }

    @Override
    public Boolean decrStock(Long appId, Long appItemId) {
        int ret = this.appItemDao.decrStock(appItemId);
        if (ret > 0) {
            return true;
        }
        return false;
    }

    @Override
    public void removeCache(Long appItemId) {
        try {
            this.eventHomeCache.invalidAppItemRemaining(appItemId);
            this.cacheClear(this.getKeyById(appItemId));
        }
        catch (Exception e) {
            LOGGER.error("removeCache:appItemId=" + appItemId, (Throwable)e);
        }
    }

    @Override
    public Boolean incrStock(Long appItemId) {
        int ret = this.appItemDao.incrStock(appItemId);
        if (ret > 0) {
            this.eventHomeCache.invalidAppItemRemaining(appItemId);
            this.cacheClear(this.getKeyById(appItemId));
            return true;
        }
        return false;
    }

    @Override
    public Boolean appendStock(Long appId, Long appItemId, Long number) {
        int ret = this.appItemDao.appendStock(appItemId, number);
        if (ret > 0) {
            this.eventHomeCache.invalidAppItemRemaining(appItemId);
            this.cacheClear(this.getKeyById(appItemId));
            return true;
        }
        return false;
    }

    @Override
    public Boolean deductStock(Long appId, Long appItemId, Long number) {
        int ret = this.appItemDao.deductStock(appItemId, number);
        if (ret > 0) {
            return true;
        }
        return false;
    }

    @Override
    public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId) {
        return this.appItemDao.findByAppIdAndItemId(appId, itemId);
    }

    @Override
    public List<AppItemEntity> findByAppIdAndItemIds(Long appId, List<Long> itemIds) {
        return this.appItemDao.findByAppIdAndItemIds(appId, itemIds);
    }

    @Override
    public int updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate) {
        int ret = this.appItemDao.updateRemainingAndvalidEndDate(appItemId, totalStock, validEndDate);
        this.eventHomeCache.invalidAppItem(appItemId);
        this.cacheClear(this.getKeyById(appItemId));
        return ret;
    }

    @Override
    public int updateExpiedAppItem(Long itemId) {
        int ret = this.appItemDao.updateExpiedAppItem(itemId);
        List<Long> ids = this.appItemDao.findIdByItemId(itemId);
        for (Long id : ids) {
            this.asyncClearCache(id);
        }
        return ret;
    }

    @Override
    public int updateExpiedAppItemById(Long appItemId) {
        int ret = this.appItemDao.updateExpiedAppItemById(appItemId);
        this.eventHomeCache.invalidAppItem(appItemId);
        this.cacheClear(this.getKeyById(appItemId));
        return ret;
    }

    @Override
    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type) {
        return this.appItemDao.findAppIdsByInActivityId(activityId, type);
    }

    @Override
    public List<Long> findAppIdsByActivityId(Long relationId) {
        return this.appItemDao.findAppIdsByActivityId(relationId);
    }

    @Override
    public List<Long> findAppIdByItemIds(List<Long> itemIds) {
        return this.appItemDao.findAppIdByItemIds(itemIds);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        return this.appItemDao.findAppIdsByIds(ids);
    }

    @Override
    public List<Long> findIDBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId) {
        return this.appItemDao.findIDBySourceIdsAndSourceTypes(sourceIds, sourceTypes, appId);
    }

    @Override
    public List<AppItemEntity> findBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId) {
        return this.appItemDao.findBySourceIdsAndSourceTypes(sourceIds, sourceTypes, appId);
    }

    @Override
    public List<Long> findTopAppItemIdsDescByPayload(Long appId) {
        return this.appItemDao.findTopAppItemIdsDescByPayload(appId);
    }

    @Override
    public int updateAppItemPayload(Long appId, Long appItemId, Integer payload) {
        return this.appItemDao.updateAppItemPayload(appId, appItemId, payload);
    }

    @Override
    public int updateOfflineAppItem4Disable(Long appId) {
        List<Long> ids = this.appItemDao.findOfflineAppItemIds4Disable(appId);
        int ret = this.appItemDao.updateOfflineAppItem4Disable(appId);
        this.eventHomeCache.invalidApp(appId);
        for (Long id : ids) {
            this.asyncClearCache(id);
        }
        return ret;
    }

    @Override
    public int updateStatusByActivityIds(String status, Boolean delete, List<Long> oids) {
        int ret = this.appItemDao.updateStatusByActivityIds(status, delete, oids);
        List<Long> appItemIds = this.appItemDao.findIdsByActivityIds(oids);
        this.eventHomeCache.invalidAppItem(appItemIds);
        for (Long id : appItemIds) {
            this.asyncClearCache(id);
        }
        return ret;
    }

    @Override
    public Integer updateStatusByActivityId(String status, Boolean delete, Long activityId, Integer type) {
        int ret = this.appItemDao.updateStatusByActivityId(status, delete, activityId, type);
        this.eventHomeCache.invalidRelationActivity(activityId, type);
        List<Long> ids = this.appItemDao.findIdsByInActivityId(activityId, type);
        for (Long id : ids) {
            this.asyncClearCache(id);
        }
        return ret;
    }

    @Override
    public int findAppMaxPayload(Long appId) {
        return this.appItemDao.findAppMaxPayload(appId);
    }

    private String getKeyById(Long id) {
        return "item.appItemId_" + id;
    }

    private void cacheClear(String key) {
        try {
            this.advancedCacheClient.remove(key);
        }
        catch (Exception e) {
            LOGGER.error("cacheClear:", (Throwable)e);
        }
    }

    private void asyncClearCache(Long id) {
        this.eventHomeCache.clearAppItemCache(this.getKeyById(id));
    }
}

