/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.stock.impl;

import cn.com.duiba.goods.center.biz.service.stock.MemStockService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MemStockServiceImpl
implements MemStockService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemStockServiceImpl.class);
    private static final String STOCK_LOCK_KEY = "redislockstock-";
    @Resource
    private CacheClient memcachedClient;

    @Override
    public boolean getLock(String key) {
        try {
            for (int i = 0; i < 10; ++i) {
                boolean ret = this.memcachedClient.add(STOCK_LOCK_KEY + key, 10, (Object)"locked");
                if (ret) {
                    return true;
                }
                TimeUnit.MILLISECONDS.sleep(15L);
            }
        }
        catch (Exception e) {
            LOGGER.error("getLock", (Throwable)e);
        }
        return false;
    }

    @Override
    public void unlock(String key) {
        try {
            this.memcachedClient.remove(STOCK_LOCK_KEY + key);
        }
        catch (Exception e) {
            LOGGER.error("unlock", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean consumeEverydayStock(String key, Integer limitStock) {
        boolean tryLock = false;
        try {
            tryLock = this.getLock(key);
            if (tryLock) {
                String stocKey = "everydayStock" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + key;
                Object value = this.memcachedClient.get(stocKey);
                if (value != null && Integer.valueOf(value.toString()) >= limitStock) {
                    boolean bl = false;
                    return bl;
                }
                this.memcachedClient.incr(stocKey, 1L, 1L, 86400L, TimeUnit.SECONDS);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.error("consumeEverydayStock", (Throwable)e);
        }
        finally {
            if (tryLock) {
                this.unlock(key);
            }
        }
        return false;
    }
}

