/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.stock.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.stock.StockService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="stockService")
public class StockServiceImpl
implements StockService {
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private RemoteStockService remoteStockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getNeedCountDownOtherStockIds(int gtype, long gid, long appId) {
        if (gtype == GoodsTypeEnum.PLATFORM.getGtype()) {
            try {
                DBTimeProfile.enter((String)"getNeedCountDownOtherStockIds");
                ArrayList<Long> stockIds = new ArrayList<Long>();
                GoodsDirectionalConfigEntity config = this.goodsDirectionalConfigService.findByGoodsAndApp(GoodsTypeEnum.getGoodsTypeEnum((int)gtype), gid, appId);
                if (config == null) {
                    config = this.goodsDirectionalConfigService.findSharedByGoods(GoodsTypeEnum.getGoodsTypeEnum((int)gtype), gid);
                    if (config != null) {
                        stockIds.add(config.getStockId());
                    }
                } else {
                    stockIds.add(config.getStockId());
                }
                ArrayList<Long> arrayList = stockIds;
                return arrayList;
            }
            finally {
                DBTimeProfile.release();
            }
        }
        return new ArrayList<Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, StockDto> findStockByStockIds(List<Long> stockIds) {
        try {
            DBTimeProfile.enter((String)("findStockByStockIds stockIds size=" + (stockIds.isEmpty() ? 0 : stockIds.size())));
            HashMap<Long, StockDto> stockMap = new HashMap<Long, StockDto>();
            if (stockIds.isEmpty()) {
                HashMap<Long, StockDto> hashMap = stockMap;
                return hashMap;
            }
            DubboResult ret = this.remoteStockService.findBatchByIds(stockIds);
            if (!ret.isSuccess()) {
                throw new RuntimeGoodsException(ErrorCode.E0203003);
            }
            List stocks = (List)ret.getResult();
            for (StockDto dto : stocks) {
                stockMap.put(dto.getStockID(), dto);
            }
            HashMap<Long, StockDto> hashMap = stockMap;
            return hashMap;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public StockDto findStock(Long stockId) {
        DubboResult ret = this.remoteStockService.findDto(stockId.longValue());
        if (!ret.isSuccess()) {
            throw new RuntimeGoodsException(ErrorCode.E0203003);
        }
        return (StockDto)ret.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, StockDto> findGoodsBatchStocks(List<GoodsBatchEntity> batchs) {
        try {
            DBTimeProfile.enter((String)"findGoodsBatchStocks");
            HashMap<Long, StockDto> stockMap = new HashMap<Long, StockDto>();
            if (batchs == null || batchs.isEmpty()) {
                HashMap<Long, StockDto> hashMap = stockMap;
                return hashMap;
            }
            ArrayList<Long> stockIds = new ArrayList<Long>();
            for (GoodsBatchEntity e : batchs) {
                stockIds.add(e.getStockId());
            }
            DubboResult ret = this.remoteStockService.findBatchByIds(stockIds);
            if (!ret.isSuccess()) {
                throw new RuntimeGoodsException(ErrorCode.E0203003);
            }
            List stocks = (List)ret.getResult();
            for (StockDto dto : stocks) {
                stockMap.put(dto.getStockID(), dto);
            }
            HashMap<Long, StockDto> hashMap = stockMap;
            return hashMap;
        }
        finally {
            DBTimeProfile.release();
        }
    }
}

