/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.bo.AddrLimitBO;
import cn.com.duiba.goods.center.biz.cache.IPCache;
import cn.com.duiba.goods.center.biz.service.item.AddrLimitService;
import cn.com.duiba.goods.center.biz.util.IpUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="addrLimitBO")
public class AddrLimitBOImpl
implements AddrLimitBO {
    @Autowired
    private AddrLimitService addrLimitService;

    @Override
    public List<ItemKeyDto> getItemCanPassAddrLimit(List<ItemKeyDto> items, String ip) {
        if (null == items || items.isEmpty()) {
            return items;
        }
        String code = this.getAddrLimitCode(ip);
        Set<String> appItemAddrLimitKeys = this.forbidByAddrLimit(this.getAddrLimits(items, GoodsTypeEnum.APP), code);
        Set<String> itemAddrLimitsKeys = this.forbidByAddrLimit(this.getAddrLimits(items, GoodsTypeEnum.DUIBA), code);
        if (appItemAddrLimitKeys.isEmpty() && itemAddrLimitsKeys.isEmpty()) {
            return items;
        }
        itemAddrLimitsKeys.addAll(appItemAddrLimitKeys);
        ListIterator<ItemKeyDto> iter = items.listIterator();
        while (iter.hasNext()) {
            ItemKeyDto key = iter.next();
            if (!itemAddrLimitsKeys.contains(this.generateForbidKey(key))) continue;
            iter.remove();
        }
        return items;
    }

    @Override
    public Boolean ipValidation(ItemKeyDto key, String ip) {
        ArrayList<AddrLimitDto> addrLimitDOs = new ArrayList();
        if (key.isSelfAppItemMode()) {
            if (key.getAppItem().isOpTypeAppItem(9)) {
                addrLimitDOs = this.addrLimitService.findAddrLimitByAppItemId(key.getAppItem().getId());
            }
        } else if ((key.isDuibaAppItemMode() || key.isItemMode()) && key.getItem().isOpTypeItem(9)) {
            addrLimitDOs = this.addrLimitService.findAddrLimitByItemId(key.getItem().getId());
        }
        if (!addrLimitDOs.isEmpty()) {
            String code = this.getAddrLimitCode(ip);
            if (StringUtils.isBlank((String)code)) {
                return false;
            }
            return this.isValid(addrLimitDOs, code);
        }
        return true;
    }

    public List<AddrLimitDto> getAddrLimits(List<ItemKeyDto> items, GoodsTypeEnum itemEnum) {
        ArrayList<Long> itemIds = new ArrayList<Long>();
        if (itemEnum.getGtype() == GoodsTypeEnum.APP.getGtype()) {
            for (ItemKeyDto item : items) {
                if (!item.isSelfAppItemMode() || !item.getAppItem().isOpTypeAppItem(9)) continue;
                itemIds.add(item.getAppItem().getId());
            }
            return this.addrLimitService.findAddrLimitByAppItemIds(itemIds);
        }
        if (itemEnum.getGtype() == GoodsTypeEnum.DUIBA.getGtype()) {
            for (ItemKeyDto item : items) {
                if (item.getItem() == null || !item.getItem().isOpTypeItem(9)) continue;
                itemIds.add(item.getItem().getId());
            }
            return this.addrLimitService.findAddrLimitByItemIds(itemIds);
        }
        return new ArrayList<AddrLimitDto>();
    }

    private String getAddrLimitCode(String ip) {
        if (StringUtils.isBlank((String)ip)) {
            return null;
        }
        Long ipLong = IpUtil.convertIpLong(ip);
        if (null == ipLong) {
            return null;
        }
        IPCache library = this.addrLimitService.findCodeByIpLong(ipLong);
        if (null == library) {
            return null;
        }
        Long endIpNum = library.getEndIpNum();
        if (null != endIpNum && ipLong <= endIpNum && StringUtils.isNotBlank((String)(library.getCode() + ""))) {
            return library.getCode() + "";
        }
        return null;
    }

    private String generateForbidKey(Long appItemId, Long itemId) {
        String key = "";
        if (appItemId != null) {
            key = key + appItemId;
        }
        key = key + "_";
        if (itemId != null) {
            key = key + itemId;
        }
        return key;
    }

    private String generateForbidKey(ItemKeyDto dto) {
        if (dto.isSelfAppItemMode()) {
            return this.generateForbidKey(dto.getAppItem().getId(), null);
        }
        if (dto.isItemMode() || dto.isDuibaAppItemMode()) {
            return this.generateForbidKey(null, dto.getItem().getId());
        }
        return this.generateForbidKey(null, null);
    }

    private Set<String> forbidByAddrLimit(List<AddrLimitDto> addrLimits, String code) {
        HashMap<String, ArrayList<AddrLimitDto>> map = new HashMap<String, ArrayList<AddrLimitDto>>();
        for (AddrLimitDto limit : addrLimits) {
            String key = this.generateForbidKey(limit.getAppItemId(), limit.getItemId());
            ArrayList<AddrLimitDto> addrs = (ArrayList<AddrLimitDto>)map.get(key);
            if (addrs == null) {
                addrs = new ArrayList<AddrLimitDto>();
            }
            addrs.add(limit);
            map.put(key, addrs);
        }
        HashSet<String> forbidIdSet = new HashSet<String>();
        for (Map.Entry entry : map.entrySet()) {
            if (this.isValid((List)entry.getValue(), code)) continue;
            forbidIdSet.add((String)entry.getKey());
        }
        return forbidIdSet;
    }

    public boolean isValid(List<AddrLimitDto> addrLimitDtos, String code) {
        if (StringUtils.isBlank((String)code)) {
            return false;
        }
        String provinceCode = code.substring(0, 2);
        String cityCode = code.substring(2, 4);
        String zxCode = code.substring(4, 6);
        if (!"00".equals(zxCode)) {
            cityCode = zxCode;
        }
        boolean valid = false;
        for (AddrLimitDto limit : addrLimitDtos) {
            String limitProviceCode = limit.getProCode().substring(0, 2);
            String limitCityCode = limit.getProCode().substring(2, 4);
            if (!"all".equals(limit.getCityCode())) {
                limitCityCode = limit.getCityCode().substring(2, 4);
                String zxLimieCode = limit.getCityCode().substring(4, 6);
                if (!"00".equals(zxLimieCode)) {
                    limitCityCode = zxLimieCode;
                }
            }
            if (limit.getType().equals(AddrLimitDto.TYPE_WHITE_LIST)) {
                if (!provinceCode.equals(limitProviceCode)) continue;
                if (limitCityCode.equals("00")) {
                    valid = true;
                    break;
                }
                if (!cityCode.equals(limitCityCode)) continue;
                valid = true;
                break;
            }
            if (!limit.getType().equals(AddrLimitDto.TYPE_BLACK_LIST)) continue;
            if (!provinceCode.equals(limitProviceCode)) {
                valid = true;
                continue;
            }
            if (limitCityCode.equals("00")) {
                valid = false;
                break;
            }
            if (cityCode.equals("00")) {
                valid = false;
                break;
            }
            if (provinceCode.equals(limitProviceCode) && cityCode.equals(limitCityCode)) {
                valid = false;
                break;
            }
            valid = true;
        }
        return valid;
    }
}

