/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFloorDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.bo.PCGFilterConfigBO;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.stock.PcgDirectionalSalesVolumeService;
import cn.com.duiba.goods.center.biz.service.stock.StockService;
import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PCGFilterConfigBOImpl
implements PCGFilterConfigBO {
    @Autowired
    private PCGFilterConfigService pCGFilterConfigService;
    @Autowired
    private PCGCategoryGoodsService pCGCategoryGoodsService;
    @Autowired
    private PCGSellerGoodsService pCGSellerGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    protected GoodsBatchService goodsBatchService;
    @Autowired
    protected RemoteStockBackendService remoteStockBackendService;
    @Autowired
    protected GoodsLimitRecordService goodsLimitRecordService;
    @Autowired
    protected GoodsBatchCouponBackendBO goodsBatchCouponBackendBO;
    @Autowired
    protected StockService stockService;
    @Autowired
    private PcgDirectionalSalesVolumeService pcgDirectionalSalesVolumeService;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
    private SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMMdd");
    private static final Integer CATEGORYLISTMAX = 2;
    private Ordering<PCGCategoryEntity> categoryOrder = Ordering.natural().nullsFirst().onResultOf((Function)new Function<PCGCategoryEntity, Integer>(){

        public Integer apply(PCGCategoryEntity foo) {
            return foo.getPayload();
        }
    });
    private Ordering<PCGFloorDto> dtoOrdering = Ordering.natural().nullsFirst().onResultOf((Function)new Function<PCGFloorDto, Comparable>(){

        public Comparable apply(PCGFloorDto pcgFloorDto) {
            return pcgFloorDto.getPayload();
        }
    });

    public List<Long> filterGoods(List<Long> pcgIds, Long appId) {
        List<Long> filterGoodsIds = this.pCGFilterConfigService.selectPCGFilterTargetIds(appId, 1);
        if (!filterGoodsIds.isEmpty()) {
            Iterator<Long> ps = pcgIds.iterator();
            while (ps.hasNext()) {
                Long pcgId = ps.next();
                for (Long filterGoodsId : filterGoodsIds) {
                    if (pcgId - filterGoodsId != 0L) continue;
                    ps.remove();
                }
            }
        }
        return pcgIds;
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findCategoryGoods(long appId, long categoryId, Long consumerId, Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        List<PCGCategoryGoodsEntity> pCGCategoryGoodsEntity = this.pCGCategoryGoodsService.findAllGoodsByCategory(categoryId);
        ArrayList<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        for (PCGCategoryGoodsEntity cateGoods : pCGCategoryGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        this.pCGFilterConfigService.goodsTagsIdFilter(pcgIds, appId);
        pcgIds = this.checkBlack(pcgIds, appId);
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize.intValue(), pageIndex.intValue());
        if (pcgIds != null && !pcgIds.isEmpty()) {
            page = this.findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    public static Integer setPayLoad(List<PCGIdAndPayLoad> ppl, Long pcgId) {
        for (PCGIdAndPayLoad p : ppl) {
            if (p.getPagId().longValue() != pcgId.longValue()) continue;
            return p.getPayLoad();
        }
        return 0;
    }

    public Page<PCGCategorySellerGoodsDto> findGoods(Long appId, List<Long> pcgIds, Long consumerId, Long consumerCredits, List<PCGIdAndPayLoad> pCGIdAndPayLoads, Integer pageIndex, Integer pageSize) {
        ArrayList<PCGCategorySellerGoodsDto> goodsList = new ArrayList<PCGCategorySellerGoodsDto>();
        Map<String, GoodsDirectionalConfigEntity> directionals = this.goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, pcgIds);
        ArrayList directionalList = Lists.newArrayList(directionals.values());
        Map<String, Long> saleMap = this.pcgDirectionalSalesVolumeService.findSaleCountTodayBatch(directionalList);
        Map<Long, PlatformCouponGoodsEntity> pcgs = this.platformCouponGoodsService.findByIds(pcgIds);
        ArrayList<Long> gids = new ArrayList<Long>();
        for (Map.Entry<Long, PlatformCouponGoodsEntity> entry : pcgs.entrySet()) {
            PlatformCouponGoodsEntity pce = entry.getValue();
            gids.add(pce.getPcgId());
        }
        HashMap<Long, Long> gstockMap = new HashMap<Long, Long>();
        if (!gids.isEmpty()) {
            List<ACGStockDto> gstocks = this.goodsBatchService.findStockByGids(GoodsTypeEnum.PLATFORM, gids);
            for (ACGStockDto stock : gstocks) {
                gstockMap.put(stock.getAcgId(), stock.getStock());
            }
        }
        ArrayList<Long> stockIds = new ArrayList<Long>();
        for (Long pcgIdKey : pcgs.keySet()) {
            GoodsDirectionalConfigEntity gdce1 = null;
            GoodsDirectionalConfigEntity gdce2 = null;
            PlatformCouponGoodsEntity pce = pcgs.get(pcgIdKey);
            if (1 != pce.getPcgStatus() || pce.getDeleted().booleanValue()) continue;
            if (PCGFilterConfigBOImpl.isOpen(1, pce.getSwitches().intValue()) && !directionals.isEmpty()) {
                gdce1 = directionals.get(appId + "-" + pcgIdKey);
                gdce2 = directionals.get("0-" + pcgIdKey);
                if (gdce1 == null && gdce2 == null) continue;
            }
            PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
            ObjectUtil.convert((Object)pce, (Object)psgd);
            GoodsDirectionalConfigDto gc = new GoodsDirectionalConfigDto();
            if (gdce2 != null) {
                ObjectUtil.convert(gdce2, (Object)gc);
                if (gdce2.getStockId() != null) {
                    stockIds.add(gdce2.getStockId());
                }
            }
            if (gdce1 == null) continue;
            gc = new GoodsDirectionalConfigDto();
            ObjectUtil.convert((Object)gdce1, (Object)gc);
            if (gdce1.getStockId() == null) continue;
            stockIds.add(gdce1.getStockId());
        }
        Map<Long, StockDto> stockMap = this.stockService.findStockByStockIds(stockIds);
        for (Long pcgIdKey : pcgs.keySet()) {
            StockDto stock;
            GoodsDirectionalConfigEntity gdce1 = null;
            GoodsDirectionalConfigEntity gdce2 = null;
            PlatformCouponGoodsEntity pce = pcgs.get(pcgIdKey);
            if (1 != pce.getPcgStatus() || pce.getDeleted().booleanValue()) continue;
            if (PCGFilterConfigBOImpl.isOpen(1, pce.getSwitches().intValue()) && !directionals.isEmpty()) {
                gdce1 = directionals.get(appId + "-" + pcgIdKey);
                gdce2 = directionals.get("0-" + pcgIdKey);
                if (gdce1 == null && gdce2 == null) continue;
            }
            PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
            ObjectUtil.convert((Object)pce, (Object)psgd);
            GoodsDirectionalConfigDto gc = new GoodsDirectionalConfigDto();
            if (gdce2 != null) {
                ObjectUtil.convert(gdce2, (Object)gc);
                if (gdce2.getStockId() == null) {
                    gc.setStock(Long.valueOf(0L));
                } else {
                    stock = stockMap.get(gdce2.getStockId());
                    if (stock != null) {
                        gc.setStock(Long.valueOf(stock.getStock()));
                    }
                }
            }
            if (gdce1 != null) {
                gc = new GoodsDirectionalConfigDto();
                ObjectUtil.convert((Object)gdce1, (Object)gc);
                if (gdce1.getStockId() == null) {
                    gc.setStock(Long.valueOf(0L));
                } else {
                    stock = stockMap.get(gdce1.getStockId());
                    if (stock != null) {
                        gc.setStock(Long.valueOf(stock.getStock()));
                    }
                }
            }
            gc.setSales(saleMap.get(gc.getGoodsId() + "-" + gc.getId()));
            psgd.setGoodsDirectionalConfigDto(gc);
            psgd.setPayLoad(PCGFilterConfigBOImpl.setPayLoad(pCGIdAndPayLoads, psgd.getPcgId()));
            long pcgStock = (Long)gstockMap.get(pce.getPcgId());
            psgd.setStock(Long.valueOf(pcgStock));
            goodsList.add(psgd);
        }
        return this.page(pageIndex, pageSize, goodsList);
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findSellerGoods(long appId, long sellerId, Long consumerId, Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        ArrayList<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        List<PCGSellerGoodsEntity> pCGSellerGoodsEntity = this.pCGSellerGoodsService.findAllGoodsBySeller(sellerId);
        for (PCGSellerGoodsEntity cateGoods : pCGSellerGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        this.pCGFilterConfigService.goodsTagsIdFilter(pcgIds, appId);
        pcgIds = this.checkBlack(pcgIds, appId);
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize.intValue(), pageIndex.intValue());
        if (!pcgIds.isEmpty()) {
            page = this.findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    @Override
    public List<Long> checkBlack(List<Long> pcgIds, Long appId) {
        List<PCGCategoryEntity> cates = this.pCGFilterConfigService.findCategoryFilterList(appId);
        HashSet<Long> catSet = new HashSet<Long>();
        for (PCGCategoryEntity c : cates) {
            catSet.add(c.getId());
        }
        List<PCGSellerEntity> sellers = this.pCGFilterConfigService.findSellerFilterList(appId);
        HashSet<Long> sellerSet = new HashSet<Long>();
        for (PCGSellerEntity e : sellers) {
            sellerSet.add(e.getId());
        }
        Map<Long, List<PCGFilterConfigDto>> belongs = this.pCGFilterConfigService.findFilterCounponBelongs(catSet, sellerSet);
        List<PlatformCouponGoodsEntity> goodss = this.pCGFilterConfigService.findGoodsFilterList(appId);
        boolean flag = true;
        Iterator<Long> ps = pcgIds.iterator();
        block2: while (ps.hasNext()) {
            flag = true;
            long pcgId = ps.next();
            for (PlatformCouponGoodsEntity goods : goodss) {
                if (pcgId - goods.getPcgId() != 0L) continue;
                ps.remove();
                flag = false;
                break;
            }
            if (belongs == null || belongs.isEmpty()) continue;
            List<PCGFilterConfigDto> pcs = belongs.get(pcgId);
            if (!flag || pcs == null || pcs.isEmpty()) continue;
            for (PCGFilterConfigDto f : belongs.get(pcgId)) {
                if (f.getType() == 2) {
                    if (!catSet.contains(f.getTargetId())) continue;
                    ps.remove();
                    continue block2;
                }
                if (f.getType() != 3 || !sellerSet.contains(f.getTargetId())) continue;
                ps.remove();
                continue block2;
            }
        }
        return pcgIds;
    }

    public static boolean isOpen(int bit, int switches) {
        int v = 1 << bit;
        int ret = switches & v;
        return ret != 0;
    }

    public <T extends Comparable<? super T>> Page<T> page(Integer pageIndex, Integer pageSize, List<T> t) {
        int totalPages;
        Page page = new Page(pageSize.intValue(), pageIndex.intValue());
        ArrayList<T> newList = new ArrayList<T>();
        page.setList(newList);
        if (t.isEmpty()) {
            return page;
        }
        Collections.sort(t);
        int total = t.size();
        int index = 0;
        if (pageIndex > 1) {
            index = (pageIndex - 1) * pageSize;
        }
        int n = totalPages = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        if (pageIndex <= totalPages) {
            if (pageIndex == 1) {
                pageIndex = 0;
            }
            for (int i = index; i < total && pageSize * (pageIndex + 1) != i; ++i) {
                newList.add(t.get(i));
            }
        }
        page.setList(newList);
        page.setTotalPages(totalPages);
        page.setPageSize(pageSize.intValue());
        page.setCurrent(pageIndex.intValue());
        return page;
    }

    @Override
    public List<PCGFloorDto> findFloorPcgByAppId(Long appId, Integer size) {
        List<PCGCategorySellerGoodsDto> categoryGoodsList = this.pCGFilterConfigService.selectPCGCategoryGoodsList(appId);
        List<PCGCategorySellerGoodsDto> sellerGoodsList = this.pCGFilterConfigService.selectPCGSellerGoodsList(appId);
        sellerGoodsList.removeAll(categoryGoodsList);
        sellerGoodsList.addAll(categoryGoodsList);
        Collections.sort(sellerGoodsList);
        ArrayList<Long> pcgIds = new ArrayList<Long>();
        for (PCGCategorySellerGoodsDto it : sellerGoodsList) {
            if (pcgIds.size() >= size) break;
            pcgIds.add(it.getPcgId());
        }
        sellerGoodsList = sellerGoodsList.subList(0, pcgIds.size());
        Map<String, GoodsDirectionalConfigEntity> directionals = this.goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, pcgIds);
        Map<Long, PlatformCouponGoodsEntity> pcgs = this.platformCouponGoodsService.findByIds(pcgIds);
        ArrayList<PCGFloorDto> goodsList = new ArrayList<PCGFloorDto>();
        for (PCGCategorySellerGoodsDto it : sellerGoodsList) {
            PlatformCouponGoodsEntity pce = pcgs.get(it.getPcgId());
            if (!this.canShow(directionals, pce, appId)) continue;
            PCGFloorDto psgd = new PCGFloorDto();
            ObjectUtil.convert((Object)pce, (Object)psgd);
            psgd.setMinPrice(this.getMinPrice(directionals, pce, appId));
            this.setGoodsBatch(psgd, it.getPcgId());
            goodsList.add(psgd);
        }
        return goodsList;
    }

    @Override
    public List<PCGFloorDto> findAllPcg4Floor(Long appId, String appTags) {
        List<PCGCategoryEntity> allCategoryList = this.pCGCategoryGoodsService.findAll();
        List<Long> categoryIds = this.pCGFilterConfigService.selectPCGFilterTargetIds(appId, 2);
        HashSet categoryFilterIds = Sets.newHashSet(categoryIds);
        List<PCGCategoryEntity> categoryList = Lists.newArrayList();
        ArrayList cids = Lists.newArrayList();
        for (PCGCategoryEntity it : allCategoryList) {
            if (categoryFilterIds.contains(it.getId())) continue;
            cids.add(it.getId());
            categoryList.add(it);
        }
        if (categoryList.isEmpty()) {
            return Collections.emptyList();
        }
        categoryList = this.categoryOrder.sortedCopy((Iterable)categoryList);
        List<PCGCategoryGoodsEntity> pCGCategoryGoodsList = this.pCGCategoryGoodsService.findAllGoodsByCateIds(cids);
        if (pCGCategoryGoodsList.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap pcgTable = Maps.newHashMap();
        ArrayList<Long> pcgIds = new ArrayList<Long>();
        for (PCGCategoryGoodsEntity cateGoods : pCGCategoryGoodsList) {
            pcgIds.add(cateGoods.getPcgId());
            pcgTable.put(cateGoods.getPcgId(), cateGoods);
        }
        List<PlatformCouponGoodsEntity> allList = this.platformCouponGoodsService.findListByIds(pcgIds);
        allList = this.pCGFilterConfigService.goodsTagsFilter(allList, appTags);
        allList = this.goodsStateFilter(appId, allList);
        ArrayListMultimap allMap = ArrayListMultimap.create();
        for (PlatformCouponGoodsEntity it : allList) {
            PCGCategoryGoodsEntity res = (PCGCategoryGoodsEntity)pcgTable.get(it.getPcgId());
            PCGFloorDto dto = new PCGFloorDto();
            dto.setPcgId(it.getPcgId());
            dto.setPayload(res.getPayload());
            dto.setCategoryId(res.getCategoryId());
            dto.setBackgroundColor(it.getBackgroundColor());
            dto.setInterestDesc(it.getInterestDesc());
            dto.setInterestPrice(it.getInterestPrice());
            dto.setIconImage(it.getIconImage());
            dto.setTitle(it.getTitle());
            dto.setSubtitle(it.getSubtitle());
            dto.setMinPrice(it.getMinPrice());
            dto.setThumbnailImage(it.getThumbnailImage());
            allMap.put((Object)res.getCategoryId(), (Object)dto);
        }
        ArrayList newList = Lists.newArrayList();
        for (PCGCategoryEntity category : categoryList) {
            if (!allMap.containsKey((Object)category.getId())) continue;
            List list = allMap.get((Object)category.getId());
            if ((list = this.dtoOrdering.sortedCopy((Iterable)list)).size() > CATEGORYLISTMAX) {
                list = Lists.newArrayList((Object[])new PCGFloorDto[]{(PCGFloorDto)list.get(0), (PCGFloorDto)list.get(1)});
            }
            newList.addAll(list);
        }
        this.setGoodsBatchs(newList);
        return newList;
    }

    private List<PlatformCouponGoodsEntity> goodsStateFilter(Long appId, List<PlatformCouponGoodsEntity> allList) {
        ArrayList newList = Lists.newArrayList();
        List<Long> filterIds = this.pCGFilterConfigService.findGoodsFilterIdList(appId);
        HashSet filterSet = Sets.newHashSet(filterIds);
        ArrayList needDirectionalIds = Lists.newArrayList();
        for (PlatformCouponGoodsEntity it : allList) {
            if (1 != it.getPcgStatus() || it.getDeleted().booleanValue() || filterSet.contains(it.getPcgId())) continue;
            if (PCGFilterConfigBOImpl.isOpen(1, it.getSwitches().intValue())) {
                needDirectionalIds.add(it.getPcgId());
            }
            newList.add(it);
        }
        Map<String, GoodsDirectionalConfigEntity> directionals = this.goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, needDirectionalIds);
        ArrayList returnList = Lists.newArrayList();
        for (PlatformCouponGoodsEntity it : newList) {
            if (PCGFilterConfigBOImpl.isOpen(1, it.getSwitches().intValue())) {
                GoodsDirectionalConfigEntity gdce1 = directionals.get(appId + "-" + it.getPcgId());
                GoodsDirectionalConfigEntity gdce2 = directionals.get("0-" + it.getPcgId());
                if (gdce1 == null && gdce2 == null) continue;
            }
            returnList.add(it);
        }
        return returnList;
    }

    private void setGoodsBatch(PCGFloorDto psgd, Long pcgId) {
        List<GoodsBatchDto> goodsBatchs = this.goodsBatchCouponBackendBO.findBatchs(GoodsTypeEnum.PLATFORM, pcgId);
        String currentTime = this.sdf2.format(new Date());
        for (GoodsBatchDto goodsBatch : goodsBatchs) {
            if (goodsBatch.getStatus() == null || goodsBatch.getStatus() == 3 || goodsBatch.getStatus() == 4 || goodsBatch.getStock() <= 0L || Integer.parseInt(this.sdf2.format(goodsBatch.getEndDay())) < Integer.parseInt(currentTime)) continue;
            psgd.setStartDate(this.sdf.format(goodsBatch.getStartDay()));
            psgd.setEndDate(this.sdf.format(goodsBatch.getEndDay()));
            break;
        }
        if (!goodsBatchs.isEmpty() && StringUtils.isBlank((String)psgd.getEndDate())) {
            psgd.setStartDate(this.sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getStartDay()));
            psgd.setEndDate(this.sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getEndDay()));
        }
    }

    private List<PCGFloorDto> setGoodsBatchs(List<PCGFloorDto> dtos) {
        ArrayList<Long> gids = new ArrayList<Long>();
        for (PCGFloorDto dto : dtos) {
            gids.add(dto.getPcgId());
        }
        if (gids.isEmpty()) {
            return dtos;
        }
        List<GoodsBatchDto> goodsBatchs = this.goodsBatchService.findBatchsNoCode(GoodsTypeEnum.PLATFORM, gids);
        for (PCGFloorDto psgd : dtos) {
            String currentTime = this.sdf2.format(new Date());
            for (GoodsBatchDto goodsBatch : goodsBatchs) {
                if (goodsBatch.getStatus() == null || goodsBatch.getStatus() == 3 || goodsBatch.getStatus() == 4 || goodsBatch.getStock() <= 0L || Integer.parseInt(this.sdf2.format(goodsBatch.getEndDay())) < Integer.parseInt(currentTime)) continue;
                psgd.setStartDate(this.sdf.format(goodsBatch.getStartDay()));
                psgd.setEndDate(this.sdf.format(goodsBatch.getEndDay()));
                break;
            }
            if (goodsBatchs.isEmpty() || !StringUtils.isBlank((String)psgd.getEndDate())) continue;
            psgd.setStartDate(this.sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getStartDay()));
            psgd.setEndDate(this.sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getEndDay()));
        }
        return dtos;
    }

    private boolean canShow(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        if (1 != entity.getPcgStatus() || entity.getDeleted().booleanValue()) {
            return false;
        }
        if (!PCGFilterConfigBOImpl.isOpen(1, entity.getSwitches().intValue())) {
            return true;
        }
        GoodsDirectionalConfigEntity directionalConfig = this.getGoodsDirectionalConfig(directionals, entity, appId);
        return directionalConfig != null;
    }

    private GoodsDirectionalConfigEntity getGoodsDirectionalConfig(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        if (!PCGFilterConfigBOImpl.isOpen(1, entity.getSwitches().intValue())) {
            return null;
        }
        if (directionals.isEmpty()) {
            return null;
        }
        GoodsDirectionalConfigEntity gdce1 = null;
        GoodsDirectionalConfigEntity gdce2 = null;
        gdce1 = directionals.get(appId + "-" + entity.getPcgId());
        gdce2 = directionals.get("0-" + entity.getPcgId());
        if (gdce1 == null && gdce2 == null) {
            return null;
        }
        if (gdce1 != null) {
            return gdce1;
        }
        return gdce2;
    }

    private Long getCredits(Integer duibaPrice, Long creditsRate) {
        if (duibaPrice == null || creditsRate == null) {
            return null;
        }
        long credits = (long)Math.ceil((double)((long)duibaPrice.intValue() * creditsRate) / 100.0);
        if (credits < 1L) {
            credits = 1L;
        }
        return credits;
    }

    private Integer getMinPrice(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        if (!PCGFilterConfigBOImpl.isOpen(1, entity.getSwitches().intValue())) {
            return entity.getMinPrice();
        }
        GoodsDirectionalConfigEntity directionalConfig = this.getGoodsDirectionalConfig(directionals, entity, appId);
        if (directionalConfig == null) {
            return entity.getMinPrice();
        }
        return directionalConfig.getMinPrice() != null ? directionalConfig.getMinPrice() : entity.getMinPrice();
    }

    private Long getStock(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        long pcgStock = this.goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, entity.getPcgId());
        if (pcgStock == 0L) {
            return 0L;
        }
        if (!PCGFilterConfigBOImpl.isOpen(1, entity.getSwitches().intValue())) {
            return pcgStock;
        }
        long preStock = 0L;
        GoodsDirectionalConfigEntity directionalConfig = this.getGoodsDirectionalConfig(directionals, entity, appId);
        if (directionalConfig == null) {
            return 0L;
        }
        DubboResult result = this.remoteStockBackendService.find(directionalConfig.getStockId().longValue());
        if (result != null && result.isSuccess() && result.getResult() != null) {
            preStock = (Long)result.getResult();
        }
        return Math.min(pcgStock, preStock);
    }

    public static class PCGIdAndPayLoad {
        private Long pagId;
        private Integer payLoad;

        public PCGIdAndPayLoad() {
        }

        public PCGIdAndPayLoad(Long pcgId, Integer payLoad) {
            this.pagId = pcgId;
            this.payLoad = payLoad;
        }

        public Long getPagId() {
            return this.pagId;
        }

        public Integer getPayLoad() {
            return this.payLoad;
        }
    }
}

