/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.dao.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.constant.DevCustomizedConstants;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.AppItemDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository(value="appItemDao")
public class AppItemDaoImpl
extends BaseCreditsDao
implements AppItemDao {
    private String appIdKey = "appId";
    private String statusKey = "status";

    @Override
    public AppItemEntity find(Long id) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("id", id);
        return (AppItemEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("find"), queryMap);
    }

    @Override
    public List<AppItemEntity> findByIds(List<Long> ids) {
        HashMap<String, List<Long>> queryMap = new HashMap<String, List<Long>>();
        queryMap.put("ids", ids);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findByIds"), queryMap);
    }

    @Override
    public void insert(AppItemEntity appItemEntity) {
        this.getSqlSession().insert(this.getStamentNameSpace("insert"), (Object)appItemEntity);
    }

    @Override
    public Integer update(AppItemEntity appItemEntity) {
        return this.getSqlSession().update(this.getStamentNameSpace("update"), (Object)appItemEntity);
    }

    @Override
    public Integer delete(Long appId, Long id) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put(this.appIdKey, appId);
        queryMap.put("id", id);
        return this.getSqlSession().update(this.getStamentNameSpace("delete"), queryMap);
    }

    @Override
    public Integer deleteByIds(Long appId, List<Long> ids) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(this.appIdKey, appId);
        queryMap.put("ids", ids);
        return this.getSqlSession().update(this.getStamentNameSpace("deleteByIds"), queryMap);
    }

    @Override
    public Integer updateStatus(Long appId, Long id, String status) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(this.appIdKey, appId);
        queryMap.put("id", id);
        queryMap.put(this.statusKey, status);
        return this.getSqlSession().update(this.getStamentNameSpace("updateStatus"), queryMap);
    }

    @Override
    public Integer updateStatusByIds(Long appId, List<Long> ids, String status) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(this.appIdKey, appId);
        queryMap.put("ids", ids);
        queryMap.put(this.statusKey, status);
        return this.getSqlSession().update(this.getStamentNameSpace("updateStatusByIds"), queryMap);
    }

    @Override
    public Integer decrStock(Long id) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("id", id);
        return this.getSqlSession().update(this.getStamentNameSpace("decrStock"), queryMap);
    }

    @Override
    public Integer incrStock(Long id) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("id", id);
        return this.getSqlSession().update(this.getStamentNameSpace("incrStock"), queryMap);
    }

    @Override
    public Integer appendStock(Long id, Long number) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("id", id);
        queryMap.put("number", number);
        return this.getSqlSession().update(this.getStamentNameSpace("appendStock"), queryMap);
    }

    @Override
    public Integer deductStock(Long id, Long number) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("id", id);
        queryMap.put("number", number);
        return this.getSqlSession().update(this.getStamentNameSpace("deductStock"), queryMap);
    }

    @Override
    public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put(this.appIdKey, appId);
        queryMap.put("itemId", itemId);
        return (AppItemEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findByAppIdAndItemId"), queryMap);
    }

    @Override
    public Integer findCountByItemId(Long itemId) {
        Map<String, Object> queryMap = this.getBlankParams();
        queryMap.put("itemId", itemId);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("findCountByItemId"), queryMap);
    }

    @Override
    public List<AppItemEntity> findByAppIdAndItemIds(Long appId, List<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return new ArrayList<AppItemEntity>();
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(this.appIdKey, appId);
        queryMap.put("itemIds", itemIds);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findByAppIdAndItemIds"), queryMap);
    }

    @Override
    public Integer updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate) {
        HashMap<String, Comparable<Long>> queryMap = new HashMap<String, Comparable<Long>>();
        queryMap.put("id", appItemId);
        queryMap.put("totalStock", totalStock);
        queryMap.put("validEndDate", validEndDate);
        return this.getSqlSession().update(this.getStamentNameSpace("updateRemainingAndvalidEndDate"), queryMap);
    }

    @Override
    public Integer updateExpiedAppItem(Long itemId) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("itemId", itemId);
        return this.getSqlSession().update(this.getStamentNameSpace("updateExpiedAppItem"), queryMap);
    }

    @Override
    public Integer updateExpiedAppItemById(Long appItemId) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("appItemId", appItemId);
        return this.getSqlSession().update(this.getStamentNameSpace("updateExpiedAppItemById"), queryMap);
    }

    @Override
    public List<AppItemDto> findhomeAppItemNeed(Long appId) {
        return this.getSqlSession().selectList(this.getStamentNameSpace("findhomeAppItemNeed"), (Object)appId);
    }

    @Override
    public List<AppItemEntity> findHomeItemKeyByAppIdAndLimitCount(long appId, int limitCount) {
        HashMap<String, Number> queryMap = new HashMap<String, Number>();
        queryMap.put("appId", appId);
        queryMap.put("limitCount", limitCount);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findHomeItemKeyByAppIdAndLimitCount"), queryMap);
    }

    @Override
    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("activityId", activityId);
        paramMap.put("type", type);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByInActivityId"), paramMap);
    }

    @Override
    public List<Long> findAppIdsByActivityId(Long relationId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("relationId", relationId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByActivityId"), paramMap);
    }

    @Override
    public List<Long> findIdsByActivityIds(List<Long> relationIds) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("relationIds", relationIds);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findIdsByActivityIds"), paramMap);
    }

    @Override
    public List<Long> findAppIdByItemIds(List<Long> itemIds) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("itemIds", itemIds);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAppIdByItemIds"), paramMap);
    }

    @Override
    public List<AppItemDto> findAppItemsByAppIdAndIds(Long appId, String status, List<Long> ids) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put(this.statusKey, status);
        paramMap.put("ids", ids);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAppItemsByAppIdAndIds"), paramMap);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("ids", ids);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByIds"), paramMap);
    }

    @Override
    public List<Long> findIdByItemId(Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("itemId", itemId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findIdByItemId"), paramMap);
    }

    @Override
    public List<Long> findIDBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId) {
        if (sourceIds.isEmpty() || sourceTypes.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("sourceIds", sourceIds);
        paramMap.put("sourceTypes", sourceTypes);
        paramMap.put("appId", appId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findIDBySourceIdsAndSourceTypes"), paramMap);
    }

    @Override
    public List<AppItemEntity> findBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId) {
        if (sourceIds.isEmpty() || sourceTypes.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("sourceIds", sourceIds);
        paramMap.put("sourceTypes", sourceTypes);
        paramMap.put("appId", appId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findBySourceIdsAndSourceTypes"), paramMap);
    }

    @Override
    public int updateStatusByActivityIds(String status, Boolean delete, List<Long> oids) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("status", status);
        queryMap.put("delete", delete);
        queryMap.put("oids", oids);
        return this.getSqlSession().update(this.getStamentNameSpace("updateStatusByActivityIds"), queryMap);
    }

    @Override
    public List<AppItemDto> findByLimit(Map<String, Object> params) {
        return this.getSqlSession().selectList(this.getStamentNameSpace("findByLimit"), params);
    }

    @Override
    public Integer findByLimitCount(Map<String, Object> params) {
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("findByLimitCount"), params);
    }

    @Override
    public int findAppMaxPayload(Long appId) {
        Map<String, Object> param = this.getBlankParams();
        param.put("appId", appId);
        param.put("topStart", 1000000);
        int payload = (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("findAppMaxPayload"), param);
        if (payload + 1 >= 1000000) {
            throw new RuntimeGoodsException(ErrorCode.E9999999);
        }
        return payload;
    }

    @Override
    public Integer updateStatusByActivityId(String status, Boolean delete, Long activityId, Integer type) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("status", status);
        paramMap.put("delete", delete);
        paramMap.put("activityId", activityId);
        paramMap.put("type", type);
        return this.getSqlSession().update(this.getStamentNameSpace("updateStatusByActivityId"), paramMap);
    }

    @Override
    public List<Long> findIdsByInActivityId(Long activityId, Integer type) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("activityId", activityId);
        paramMap.put("type", type);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findIdsByInActivityId"), paramMap);
    }

    @Override
    public List<Long> findTopAppItemIdsDescByPayload(Long appId) {
        HashMap<String, Number> param = new HashMap<String, Number>();
        param.put("appId", appId);
        param.put("topStart", DevCustomizedConstants.ITEM_TOP_START);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findTopAppItemIdsDescByPayload"), param);
    }

    @Override
    public int updateAppItemPayload(Long appId, Long appItemId, Integer payload) {
        AppItemEntity entity = new AppItemEntity();
        entity.setId(appItemId);
        entity.setAppId(appId);
        entity.setPayload(payload);
        return this.getSqlSession().update(this.getStamentNameSpace("updateAppItemPayload"), (Object)entity);
    }

    @Override
    public int updateOfflineAppItem4Disable(Long appId) {
        HashMap param = Maps.newHashMap();
        param.put("appId", appId);
        return this.getSqlSession().update(this.getStamentNameSpace("updateOfflineAppItem4Disable"), (Object)param);
    }

    @Override
    public List<Long> findOfflineAppItemIds4Disable(Long appId) {
        HashMap param = Maps.newHashMap();
        param.put("appId", appId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findOfflineAppItemIds4Disable"), (Object)param);
    }

    @Override
    public List<AppItemDto> findOnShelfByItemId(Long itemId) {
        HashMap param = Maps.newHashMap();
        param.put("itemId", itemId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findOnShelfByItemId"), (Object)param);
    }

    @Override
    public int standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("id", id);
        paramMap.put("status", status);
        paramMap.put("deleted", deleted);
        paramMap.put("payload", payload);
        paramMap.put("homeDisplay", homeDisplay);
        return this.getSqlSession().update(this.getStamentNameSpace("standUpOrDownAppItem"), paramMap);
    }

    @Override
    public int updateHdtoolAppItem(Long id, String title, String smallImage, String whiteImage, Long credits, String customPrice, String logo, Integer operationsType) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("id", id);
        paramMap.put("title", title);
        paramMap.put("smallImage", smallImage);
        paramMap.put("whiteImage", whiteImage);
        paramMap.put("credits", credits);
        paramMap.put("customPrice", customPrice);
        paramMap.put("logo", logo);
        paramMap.put("operationsType", operationsType);
        return this.getSqlSession().update(this.getStamentNameSpace("updateHdtoolAppItem"), paramMap);
    }

    @Override
    public int updateMainPushAppItem(Long id, String title, String logo, String smallImage, String whiteImage, String bannerImage, Long credits, String subtitle) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("id", id);
        paramMap.put("title", title);
        paramMap.put("logo", logo);
        paramMap.put("smallImage", smallImage);
        paramMap.put("whiteImage", whiteImage);
        paramMap.put("bannerImage", bannerImage);
        paramMap.put("credits", credits);
        paramMap.put("subtitle", subtitle);
        return this.getSqlSession().update(this.getStamentNameSpace("updateMainPushAppItem"), paramMap);
    }

    @Override
    public List<AppItemDto> findAllBySourceTypeAndRelationIdAndDeleted(Integer sourceType, Long sourceRelationId, Boolean deleted) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("sourceType", sourceType);
        paramMap.put("sourceRelationId", sourceRelationId);
        paramMap.put("deleted", deleted);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAllBySourceTypeAndRelationIdAndDeleted"), paramMap);
    }

    @Override
    public List<AppItemDto> findPublishItemLimit(Map<String, Object> queryPublish) {
        return this.getSqlSession().selectList(this.getStamentNameSpace("findPublishItemLimit"), queryPublish);
    }

    @Override
    public Integer countPublishItemRow(Map<String, Object> queryPublish) {
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("countPublishItemRow"), queryPublish);
    }

    @Override
    public Integer updateSubTypeById(Long id, Integer subType) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("id", id);
        paramMap.put("subType", subType);
        return this.getSqlSession().update(this.getStamentNameSpace("updateSubTypeById"), paramMap);
    }

    @Override
    public int updateValidEndDateById(Long appItemId, Date validEndDate) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("id", appItemId);
        paramMap.put("validEndDate", validEndDate);
        return this.getSqlSession().update(this.getStamentNameSpace("updateValidEndDateById"), paramMap);
    }

    @Override
    public List<AppItemDto> findAllByAppIdAndInType(Long appId, String[] type) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("type", type);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAllByAppIdAndInType"), paramMap);
    }

    @Override
    public Integer findOnlineCount(Long appId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("findOnlineCount"), paramMap);
    }

    @Override
    public List<AppItemDto> findOnlineAppItems(Long appId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findOnlineAppItems"), paramMap);
    }

    @Override
    public List<AppItemDto> findAllUpVirtaulAppItems(Long appId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAllUpVirtaulAppItems"), paramMap);
    }

    @Override
    public void updateOperationsTypeById(Long id, Integer operationsType) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", id);
        paramMap.put("operationsType", operationsType);
        this.getSqlSession().update(this.getStamentNameSpace("updateOperationsTypeById"), paramMap);
    }

    @Override
    public void setLimitNull(Long appItemId, Integer limitCount, String limitTimeBetween, Integer limitEverydayQuantity) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appItemId", appItemId);
        paramMap.put("limitCount", limitCount);
        paramMap.put("limitTimeBetween", limitTimeBetween);
        paramMap.put("limitEverydayQuantity", limitEverydayQuantity);
        this.getSqlSession().update(this.getStamentNameSpace("setLimitNull"), paramMap);
    }

    @Override
    public Integer deleteOrRecoverAppItem(Long appId, Long id, Boolean deleted, String status) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("id", id);
        paramMap.put("appId", appId);
        paramMap.put("deleted", deleted);
        paramMap.put("status", status);
        return this.getSqlSession().update(this.getStamentNameSpace("deleteOrRecoverAppItem"), paramMap);
    }

    @Override
    public List<Long> findSelfAppItemIdsByAppId(Long appId, List<String> types, Integer warnLine) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("appId", appId);
        paramMap.put("types", types);
        paramMap.put("warnLine", warnLine);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findSelfAppItemIdsByAppId"), paramMap);
    }

    @Override
    public AppItemDto selectItemStore(Long appId, Long itemId) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("appId", appId);
        paramMap.put("itemId", itemId);
        return (AppItemDto)this.getSqlSession().selectOne(this.getStamentNameSpace("selectItemStore"), paramMap);
    }

    @Override
    public void setImageNull(Long appItemId) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("appItemId", appItemId);
        this.getSqlSession().update(this.getStamentNameSpace("setImageNull"), paramMap);
    }

    @Override
    public void setMyRepoMultiNull(Long appItemId) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("appItemId", appItemId);
        this.getSqlSession().update(this.getStamentNameSpace("setMyRepoMultiNull"), paramMap);
    }

    @Override
    public List<AppItemDto> findAllByExpressTemplateId(Long expressTemplateId) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("expressTemplateId", expressTemplateId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAllByExpressTemplateId"), paramMap);
    }

    @Override
    public List<AppItemDto> findAllByAppIdAndType(Long appId, String type) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("appId", appId);
        paramMap.put("type", type);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAllByAppIdAndType"), paramMap);
    }

    @Override
    public List<AppItemDto> findAllVirtualValid(Long appId) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("appId", appId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAllVirtualValid"), paramMap);
    }

    @Override
    public List<AppItemDto> findAppItemLimit(Map<String, Object> param, int start, int pageSize) {
        param.put("start", start);
        param.put("pageSize", pageSize);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAppItemLimit"), param);
    }

    @Override
    public Long findAppItemCount(Map<String, Object> param) {
        return (Long)this.getSqlSession().selectOne(this.getStamentNameSpace("findAppItemCount"), param);
    }

    @Override
    public List<AppItemDO> findListBetweenPayload(Long appId, Integer startPayload, Integer endPayload) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("appId", appId);
        if (startPayload < endPayload) {
            paramMap.put("start", startPayload);
            paramMap.put("end", endPayload);
        } else {
            paramMap.put("start", endPayload);
            paramMap.put("end", startPayload);
        }
        return this.getSqlSession().selectList(this.getStamentNameSpace("findListBetweenPayload"), paramMap);
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("id", id);
        return this.getSqlSession().update(this.getStamentNameSpace("updateAutoOffDateNull"), paramMap);
    }

    @Override
    public List<AppItemDto> findAllByAppAndIsOwner(Long appId, Boolean isOwner) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("appId", appId);
        paramMap.put("isOwner", isOwner);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAllByAppAndIsOwner"), paramMap);
    }

    @Override
    public List<Long> selectHasUpItems(List<Long> ids, Long appId) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("appId", appId);
        paramMap.put("ids", ids);
        return this.getSqlSession().selectList(this.getStamentNameSpace("selectHasUpItems"), paramMap);
    }

    @Override
    public List<AppItemDto> findAllByItemIdsAndAppId(List<Long> itemIds, Long appId) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("itemIds", itemIds);
        paramMap.put("appId", appId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAllByItemIdsAndAppId"), paramMap);
    }

    @Override
    public AppItemDto findByAppAndItemOnline(Long appId, Long itemId) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("appId", appId);
        paramMap.put("itemId", itemId);
        return (AppItemDto)this.getSqlSession().selectOne(this.getStamentNameSpace("findByAppAndItemOnline"), paramMap);
    }

    @Override
    public List<AppItemDto> findAllByAppIdAndTypeIn(Long appId) {
        Map<String, Object> paramMap = this.getBlankParams();
        paramMap.put("appId", appId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAllByAppIdAndTypeIn"), paramMap);
    }
}

