/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.RemoteBrandCouponGoodsBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.zhanyi.ZYCouponDataDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.zhanyi.ZYCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.zhanyi.ZYCouponRecordDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.zhanyi.ZYItemDto;
import cn.com.duiba.goods.center.biz.entity.zhanyi.ZYCoupon;
import cn.com.duiba.goods.center.biz.entity.zhanyi.ZYGetCouponDate;
import cn.com.duiba.goods.center.biz.entity.zhanyi.ZYItem;
import cn.com.duiba.goods.center.biz.service.BrandCouponGoodsService;
import cn.com.duiba.goods.center.biz.util.AESUtils;
import cn.com.duiba.goods.center.biz.util.ZYConstant;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteBrandCouponGoodsBackendService")
public class RemoteBrandCouponGoodsBackendServiceImpl
implements RemoteBrandCouponGoodsBackendService {
    private static Logger log = LoggerFactory.getLogger(RemoteBrandCouponGoodsBackendServiceImpl.class);
    @Autowired
    private BrandCouponGoodsService brandCouponGoodsService;
    @Autowired
    private ZYConstant zYConstant;

    public DubboResult<List<ZYItemDto>> getZYCouponList(String itemName) {
        List<Object> retList = new ArrayList();
        try {
            List<ZYItem> list = this.brandCouponGoodsService.getZYCouponList();
            if (StringUtils.isBlank((String)itemName)) {
                retList = BeanUtils.copyList(list, ZYItemDto.class);
            } else {
                for (ZYItem zYItem : list) {
                    if (!zYItem.getItemName().contains(itemName)) continue;
                    retList.add(BeanUtils.copy((Object)zYItem, ZYItemDto.class));
                }
            }
        }
        catch (GoodsException e) {
            log.error("\u5c55\u7ffc\u4f18\u60e0\u5238\u5217\u8868\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            return DubboResult.failResult((String)e.getResultMessage());
        }
        return DubboResult.successResult(retList);
    }

    public DubboResult<ZYCouponDataDto> getZYCoupon(String itemName, String itemPrice, String itemId, Integer count) {
        ZYCouponDataDto data = new ZYCouponDataDto();
        ArrayList<ZYCouponDto> retList = new ArrayList<ZYCouponDto>();
        try {
            ZYGetCouponDate zYGetCouponDate = this.brandCouponGoodsService.getZYCoupon(itemName, itemPrice, itemId, count);
            List<ZYCoupon> list = zYGetCouponDate.getCouponList();
            for (ZYCoupon zYCoupon : list) {
                ZYCouponDto zYCouponDto = new ZYCouponDto();
                zYCouponDto.setCouponId(AESUtils.decrypt(zYCoupon.getCouponId(), this.zYConstant.getAesKey()));
                zYCouponDto.setCode(zYCoupon.getCode());
                zYCouponDto.setQrUrl(zYCoupon.getQrUrl() == null ? null : "http://" + zYCoupon.getQrUrl());
                retList.add(zYCouponDto);
            }
            data.setCouponList(retList);
            data.setRecordId(zYGetCouponDate.getRecordId());
        }
        catch (GoodsException e) {
            log.error("\u8d2d\u4e70\u5c55\u7ffc\u4f18\u60e0\u5238\u5931\u8d25", (Throwable)e);
            return DubboResult.failResult((String)e.getResultMessage());
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5c55\u7ffc\u4f18\u60e0\u5238\u5238\u7801\u5931\u8d25", (Throwable)e);
            return DubboResult.failResult((String)"\u89e3\u5bc6\u5c55\u7ffc\u4f18\u60e0\u5238\u5238\u7801\u5931\u8d25");
        }
        return DubboResult.successResult((Object)data);
    }

    public DubboResult<List<ZYCouponRecordDto>> findCouponPage(String itemName, Integer start, Integer pageSize) {
        try {
            List<ZYCouponRecordDto> list = this.brandCouponGoodsService.findCouponPage(itemName, start, pageSize);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            log.error("findCouponPage itemName=" + itemName + ",start=" + start + ",pageSize=" + pageSize, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> findCouponPageCount(String itemName) {
        Integer count = this.brandCouponGoodsService.findCouponPageCount(itemName);
        return DubboResult.successResult((Object)count);
    }

    public DubboResult<Integer> updateFilePath(Long id, String filePath) {
        int ret = this.brandCouponGoodsService.updateFilePath(id, filePath);
        return DubboResult.successResult((Object)ret);
    }
}

