/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteGoodsCouponBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchImportLogDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteGoodsCouponBackendService")
public class RemoteGoodsCouponBackendServiceImpl
implements RemoteGoodsCouponBackendService {
    private static Logger log = LoggerFactory.getLogger(RemoteGoodsCouponBackendServiceImpl.class);
    @Autowired
    private GoodsBatchCouponBackendBO goodsBatchCouponBackendBO;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private GoodsCouponService goodsCouponService;

    public DubboResult<Long> createNormalBatch(GoodsTypeEnum gtype, long gid, Date start, Date end) {
        try {
            if (start == null || end == null) {
                throw new GoodsException(ErrorCode.E0404006);
            }
            Long batchId = this.goodsBatchCouponBackendBO.createNormalBatch(gtype, gid, start, end);
            return DubboResult.successResult((Object)batchId);
        }
        catch (GoodsException e) {
            log.warn("createNormalBatch gtype=" + gtype + ", gid= " + gid + ", start= " + start + ", end=" + end + " message:" + e.getMessage());
            return DubboResult.failResult((String)e.getMessage());
        }
        catch (Exception e) {
            log.error("createNormalBatch gtype=" + gtype + " , gid=  " + gid + ", start= " + start + ", end=" + end, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> createLinkBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, String link, long stock) {
        try {
            if (start == null || end == null) {
                throw new GoodsException(ErrorCode.E0404006);
            }
            if (StringUtils.isEmpty((String)link)) {
                throw new GoodsException(ErrorCode.E0404007);
            }
            if (stock < 1L) {
                throw new GoodsException(ErrorCode.E0404009);
            }
            Long batchId = this.goodsBatchCouponBackendBO.createLinkBatch(gtype, gid, start, end, link, stock);
            return DubboResult.successResult((Object)batchId);
        }
        catch (GoodsException e) {
            log.warn("createLinkBatch gtype=" + gtype + ", gid = " + gid + ", start=" + start + ", end= " + end + ",link= " + link + ",stock=" + stock + " message: " + e.getMessage());
            return DubboResult.failResult((String)e.getMessage());
        }
        catch (Exception e) {
            log.warn("createLinkBatch gtype=" + gtype + ", gid =" + gid + ", start=" + start + ", end =" + end + ",link=" + link + ",stock=" + stock + " error:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> createRepeatBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, String code, String password, long stock) {
        try {
            if (start == null || end == null) {
                throw new GoodsException(ErrorCode.E0404006);
            }
            if (StringUtils.isEmpty((String)code)) {
                throw new GoodsException(ErrorCode.E0404008);
            }
            if (stock < 1L) {
                throw new GoodsException(ErrorCode.E0404009);
            }
            Long batchId = this.goodsBatchCouponBackendBO.createRepeatBatch(gtype, gid, start, end, code, password, stock);
            return DubboResult.successResult((Object)batchId);
        }
        catch (GoodsException e) {
            log.warn("createRepeatBatch gtype=" + gtype + ", gid=" + gid + ",start=" + start + ",end=" + end + ", code=" + code + ",password = " + password + ",stock =" + stock + " message:" + e.getMessage());
            return DubboResult.failResult((String)e.getMessage());
        }
        catch (Exception e) {
            log.error("createRepeatBatch gtype=" + gtype + ", gid=" + gid + ",start=" + start + ",end=" + end + ", code=" + code + ",password=" + password + ",stock= " + stock, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateLinkBatch(GoodsTypeEnum gtype, long gid, Long batchId, String link, long changeStock) {
        try {
            if (StringUtils.isEmpty((String)link)) {
                throw new GoodsException(ErrorCode.E0404007);
            }
            if (changeStock < 0L) {
                throw new GoodsException(ErrorCode.E0404009);
            }
            boolean success = this.goodsBatchCouponBackendBO.updateLinkBatch(gtype, gid, batchId, link, changeStock);
            return DubboResult.successResult((Object)success);
        }
        catch (Exception e) {
            log.error("updateLinkBatch gtype=" + gtype + ",gid =" + gid + ", batchId=" + batchId + ",link=" + link + ",changeStock=" + changeStock, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateRepeatBatch(GoodsTypeEnum gtype, long gid, Long batchId, String code, String password, long changeStock) {
        try {
            if (StringUtils.isEmpty((String)code)) {
                throw new GoodsException(ErrorCode.E0404008);
            }
            if (changeStock < 0L) {
                throw new GoodsException(ErrorCode.E0404009);
            }
            boolean success = this.goodsBatchCouponBackendBO.updateRepeatBatch(gtype, gid, batchId, code, password, changeStock);
            return DubboResult.successResult((Object)success);
        }
        catch (Exception e) {
            log.error("updateRepeatBatch gtype=" + gtype + ",gid= " + gid + ",batchId =" + batchId + ",code=" + code + ",password=" + password + ",changeStock=" + changeStock, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<GoodsBatchDto>> findBatchs(GoodsTypeEnum gtype, long gid) {
        try {
            List<GoodsBatchDto> ret = this.goodsBatchCouponBackendBO.findBatchs(gtype, gid);
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("findBatchs gtype=" + gtype + ", gid= " + gid, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> importNormalCoupons(GoodsTypeEnum gtype, long gid, Long batchId, String downloadUrl) {
        try {
            if (gtype == null || batchId == null || StringUtils.isEmpty((String)downloadUrl)) {
                throw new RuntimeGoodsException(ErrorCode.E0404004);
            }
            Long importLogId = this.goodsBatchCouponBackendBO.importNormalCoupons(gtype, gid, batchId, downloadUrl);
            return DubboResult.successResult((Object)importLogId);
        }
        catch (RuntimeGoodsException e) {
            log.warn("importNormalCoupons gtype=" + gtype + " ,gid=" + gid + ",batchId=  " + batchId + ",downloadUrl=" + downloadUrl + "message:" + e.getMessage());
            return DubboResult.failResult((String)e.getMessage());
        }
        catch (Exception e) {
            log.error("importNormalCoupons gtype=" + gtype + " ,gid=" + gid + ",batchId= " + batchId + ",downloadUrl=" + downloadUrl, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GoodsBatchImportLogDto> findBatchImportLog(Long goodsBatchImportLogId) {
        try {
            GoodsBatchImportLogDto dto = this.goodsBatchCouponBackendBO.findBatchImportLog(goodsBatchImportLogId);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("findBatchImportLog goodsBatchImportLogId=" + goodsBatchImportLogId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        try {
            boolean success = this.goodsBatchCouponBackendBO.deleteBatch(gtype, gid, batchId);
            return DubboResult.successResult((Object)success);
        }
        catch (Exception e) {
            log.error("deleteBatch gtype=" + gtype + " , gid=" + gid + ", batchId=" + batchId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GoodsBatchDto> findBatchStock(GoodsTypeEnum gtype, long gid, long batchId) {
        try {
            GoodsBatchDto stock = this.goodsBatchCouponBackendBO.findBatchStock(gtype, gid, batchId);
            return DubboResult.successResult((Object)stock);
        }
        catch (Exception e) {
            log.error("findBatchStock gtype=" + gtype + ",gid = " + gid + " , batchId=" + batchId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Page<GoodsCouponDto>> findPage(GoodsTypeEnum gtype, long gid, long batchId, int pageSize, int pageIndex) {
        try {
            Page<GoodsCouponDto> ret = this.goodsBatchCouponBackendBO.findPage(gtype, gid, batchId, pageSize, pageIndex);
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("findPage gtype=" + gtype.getGtype() + ", gid =" + gid + ",batchId =" + batchId + ",pageSize=" + pageSize + ",pageIndex=" + pageIndex, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<GoodsCouponDto>> findCouponByCode(GoodsTypeEnum gtype, long gid, long batchId, String code) {
        try {
            List<GoodsCouponDto> list = this.goodsBatchCouponBackendBO.findCouponByCode(gtype, gid, batchId, code);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            log.error("findCouponByCode gtype=" + gtype.getGtype() + ",gid = " + gid + ",batchId= " + batchId + ",code=" + code, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteBatchUnusedCoupons(GoodsTypeEnum gtype, long gid, Long batchId) {
        try {
            Boolean success = this.goodsBatchCouponBackendBO.deleteBatchUnusedCoupons(gtype, gid, batchId);
            return DubboResult.successResult((Object)success);
        }
        catch (Exception e) {
            log.error("deleteBatchUnusedCoupons gtype=" + gtype.getGtype() + " ,gid= " + gid + ",batchId=" + batchId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteUnusedCoupon(GoodsTypeEnum gtype, long gid, Long couponId) {
        try {
            GoodsCouponDto dto = this.goodsBatchCouponBackendBO.findCoupon(gtype, gid, couponId);
            Boolean success = this.goodsBatchCouponBackendBO.deleteUnusedCoupon(gtype, gid, couponId, dto.getGoodsBatchId());
            if (success.booleanValue()) {
                return DubboResult.successResult((Object)true);
            }
            return DubboResult.failResult((String)"\u5904\u7406\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("deleteUnusedCoupon gtype=" + gtype.getGtype() + " , gid=" + gid + ",couponId=" + couponId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GoodsCouponDto> findCoupon(GoodsTypeEnum gtype, long gid, long couponId) {
        try {
            GoodsCouponDto dto = this.goodsBatchCouponBackendBO.findCoupon(gtype, gid, couponId);
            if (dto == null) {
                return DubboResult.failResult((String)"\u4e0d\u5b58\u5728");
            }
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("findCoupon gtype=" + gtype.getGtype() + ",gid =" + gid + ",couponId=" + couponId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<GoodsCouponDto>> findUnusedCoupons(GoodsTypeEnum gtype, long gid, Long batchId, int limit) {
        try {
            List<GoodsCouponDto> dtos = this.goodsBatchCouponBackendBO.findUnusedCoupons(gtype, gid, batchId, limit);
            return DubboResult.successResult(dtos);
        }
        catch (Exception e) {
            log.error("findUnusedCoupons gtype=" + gtype.getGtype() + ",gid=" + gid, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteBatchUnusedCoupons(GoodsTypeEnum gtype, long gid, Long batchId, List<Long> couponIds) {
        try {
            boolean ret = this.goodsBatchCouponBackendBO.deleteBatchUnusedCoupons(gtype, gid, batchId, couponIds);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("deleteBatchUnusedCoupons gtype=" + gtype.getGtype() + ",gid=" + gid + ",batchId=" + batchId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<List<ACGStockDto>> batchFindGoodsStock(GoodsTypeEnum gtype, List<Long> acgIds) {
        try {
            DBTimeProfile.enter((String)"batchFindGoodsStock");
            List<Object> result = new ArrayList();
            if (CollectionUtils.isEmpty(acgIds)) {
                DubboResult dubboResult = DubboResult.successResult(result);
                return dubboResult;
            }
            result = this.goodsBatchService.findStockByGids(gtype, acgIds);
            DubboResult dubboResult = DubboResult.successResult(result);
            return dubboResult;
        }
        catch (Exception e) {
            log.error("batchFindACGStock failed, the req=[{}]", acgIds, (Object)e);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    public DubboResult<ACGStockDto> findGoodsStock(GoodsTypeEnum gtype, Long acgId) {
        try {
            ACGStockDto aCGStockDto = this.goodsBatchService.findStockByGid(gtype, acgId);
            return DubboResult.successResult((Object)aCGStockDto);
        }
        catch (Exception e) {
            log.error("batchFindACGStock failed, the req=[{}]", (Object)acgId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateValidDate(GoodsTypeEnum gtype, long acgId, long batchId, Date startDay, Date endDay) {
        try {
            if (startDay == null || endDay == null) {
                throw new GoodsException(ErrorCode.E0404006);
            }
            boolean success = this.goodsBatchService.updateValidDate(gtype, acgId, batchId, startDay, endDay);
            return DubboResult.successResult((Object)success);
        }
        catch (Exception e) {
            log.error("updateValidDate failed, the gtype=[{}], the acgId=[{}], the batchId=[{}], the startDay=[{}], the endDay=[{}]", new Object[]{gtype, acgId, batchId, startDay, endDay, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteGoodsCoupon(GoodsTypeEnum gtype, long acgId, long batchId) {
        try {
            boolean success = this.goodsCouponService.deleteGoodsCoupon(gtype, acgId, batchId);
            return DubboResult.successResult((Object)success);
        }
        catch (Exception e) {
            log.error("deleteGoodsCoupon failed, the gtype=[{}], the acgId=[{}], the batchId=[{}]", new Object[]{gtype, acgId, batchId, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> physicalDeleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        try {
            boolean success = this.goodsBatchService.physicalDeleteBatch(gtype, gid, batchId);
            return DubboResult.successResult((Object)success);
        }
        catch (Exception e) {
            log.error("physicalDeleteBatch failed, the gtype=[{}], the gid=[{}], the batchId=[{}]", new Object[]{gtype, gid, batchId, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

