/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteAppItemGoodsBackendService;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.service.AppItemClassifyService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteAppItemGoodsBackendServiceImpl
implements RemoteAppItemGoodsBackendService {
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private AppItemClassifyService appItemClassifyService;

    public DubboResult<Integer> updateStatusByActivityId(String status, Boolean deleted, Long activityId, int type) {
        Integer ret = this.appItemService.updateStatusByActivityId(status, deleted, activityId, type);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Integer> findCountByItemId(Long itemId) {
        Integer ret = this.appItemService.findCountByItemId(itemId);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<List<AppItemDto>> findOnShelfByItemId(Long itemId) {
        List<AppItemDto> ret = this.appItemService.findOnShelfByItemId(itemId);
        return DubboResult.successResult(ret);
    }

    public DubboResult<Integer> standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay) {
        Integer ret = this.appItemService.standUpOrDownAppItem(id, status, deleted, payload, homeDisplay);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Integer> updateHdtoolAppItem(Long id, String title, String smallImage, String whiteImage, Long credits, String customPrice, String logo, Integer operationsType) {
        Integer ret = this.appItemService.updateHdtoolAppItem(id, title, smallImage, whiteImage, credits, customPrice, logo, operationsType);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Integer> updateMainPushAppItem(Long id, String title, String logo, String smallImage, String whiteImage, String bannerImage, Long credits, String subtitle) {
        Integer ret = this.appItemService.updateMainPushAppItem(id, title, logo, smallImage, whiteImage, bannerImage, credits, subtitle);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<List<AppItemDto>> findAllBySourceTypeAndRelationIdAndDeleted(int sourceType, long sourceRelationId, Boolean deleted) {
        List<AppItemDto> ret = this.appItemService.findAllBySourceTypeAndRelationIdAndDeleted(sourceType, sourceRelationId, deleted);
        return DubboResult.successResult(ret);
    }

    public DubboResult<Page<AppItemDto>> findPublishItemLimit(Map<String, Object> queryPublish) {
        Page<AppItemDto> ret = this.appItemService.findPublishItemLimit(queryPublish);
        return DubboResult.successResult(ret);
    }

    public DubboResult<Page<AppItemDto>> findByLimit(Map<String, Object> params) {
        Page<AppItemDto> ret = this.appItemService.findByLimit(params);
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<Long>> findSelfAppItemIdsByAppId(Long appId, List<String> types, Integer warnLine) {
        List<Long> ret = this.appItemService.findSelfAppItemIdsByAppId(appId, types, warnLine);
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<AppItemDto>> findAllByAppIdAndInType(Long appId, String[] types) {
        if (appId == null || types == null || types.length < 1) {
            return DubboResult.failResult((String)ErrorCode.E0404004.getDesc());
        }
        for (String type : types) {
            if (this.itemService.isRechargeGoods(type).booleanValue()) continue;
            return DubboResult.failResult((String)ErrorCode.E0404004.getDesc());
        }
        return DubboResult.successResult(this.appItemService.findAllByAppIdAndInType(appId, types));
    }

    public DubboResult<Integer> findOnlineCount(Long appId) {
        if (appId == null) {
            return DubboResult.failResult((String)ErrorCode.E0404004.getDesc());
        }
        return DubboResult.successResult((Object)this.appItemService.findOnlineCount(appId));
    }

    public DubboResult<Integer> getRemaining0Count(Long appId) {
        if (appId == null) {
            return DubboResult.failResult((String)ErrorCode.E0404004.getDesc());
        }
        return DubboResult.successResult((Object)this.appItemService.getRemaining0Count(appId));
    }

    public DubboResult<Long> getOrAddAppItemId(String type, Long appId, Long appCreditsRate) {
        if (StringUtils.isEmpty((String)type) || appId == null || appCreditsRate == null) {
            return DubboResult.failResult((String)ErrorCode.E0404004.getDesc());
        }
        Long id = this.appItemService.getOrAddAppItemId(type, appId, appCreditsRate);
        return DubboResult.successResult((Object)id);
    }

    public DubboResult<List<AppItemDto>> findAllUpVirtaulAppItems(Long appId) {
        if (appId == null) {
            return DubboResult.failResult((String)ErrorCode.E0404004.getDesc());
        }
        return DubboResult.successResult(this.appItemService.findAllUpVirtaulAppItems(appId));
    }

    public DubboResult<Boolean> doBatchDel(Long appId, Long developerId, List<Long> appItemIds) {
        return DubboResult.successResult((Object)this.appItemService.doBatchDel(appId, appItemIds));
    }

    public DubboResult<Long> addTestAppItem(Long appId) {
        return DubboResult.successResult((Object)this.appItemService.addTestCoupon(appId));
    }

    public DubboResult<Integer> bathcStandUp(Long appId, String virtualExchangeUrl, List<Long> appItemIds) {
        return DubboResult.successResult((Object)this.appItemService.bathcStandUp(appId, virtualExchangeUrl, appItemIds));
    }

    public DubboResult<Boolean> standUpOrDown(Long appId, Long appItemId, String status) {
        return DubboResult.successResult((Object)this.appItemService.updateStatus(appId, appItemId, status));
    }

    public DubboResult<Integer> sortClassifyAppItem(Long classifyId, List<Long> appItemIds) {
        return DubboResult.successResult((Object)this.appItemClassifyService.sortClassifyAppItem(classifyId, appItemIds));
    }

    public DubboResult<Boolean> doUpdateOwnerObject(AppItemDto appItem, Integer preRemaining, Integer remaining, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas) {
        return DubboResult.successResult((Object)this.appItemService.doUpdateOwnerObject(appItem, preRemaining, remaining, exchangeLimit, arealimitSwitch, arealimitType, arealimitAreas));
    }

    public DubboResult<AppItemDto> selectItemStore(Long appId, Long itemId) {
        return DubboResult.successResult((Object)this.appItemService.selectItemStore(appId, itemId));
    }

    public DubboResult<AppItemDto> addItem2Myrepo(Long appId, Long itemId, Long developerId, Long creditsRate) {
        AppItemEntity entity = this.appItemService.addItem2Myrepo(appId, itemId, developerId, creditsRate);
        return DubboResult.successResult((Object)BeanUtils.copy((Object)entity, AppItemDto.class));
    }

    public DubboResult<AppItemDto> doUpdateVirtual(AppItemDto appItem, Integer preRemaining, Integer remaining, boolean isOnSale) {
        AppItemEntity entity = this.appItemService.doUpdateVirtual(appItem, preRemaining, remaining, isOnSale);
        return DubboResult.successResult((Object)BeanUtils.copy((Object)entity, AppItemDto.class));
    }

    public DubboResult<Boolean> deleteAppItem(Long appId, Long appItemId) {
        return DubboResult.successResult((Object)this.appItemService.delete(appId, appItemId));
    }

    public DubboResult<List<AppItemDto>> findAllByExpressTemplateId(Long expressTemplateId) {
        return DubboResult.successResult(this.appItemService.findAllByExpressTemplateId(expressTemplateId));
    }

    public DubboResult<List<AppItemDto>> findAllByAppIdAndType(Long appId, String type) {
        return DubboResult.successResult(this.appItemService.findAllByAppIdAndType(appId, type));
    }

    public DubboResult<List<AppItemDto>> findAllVirtualValid(Long appId) {
        return DubboResult.successResult(this.appItemService.findAllVirtualValid(appId));
    }

    public DubboResult<AppItemDto> findByAppIdAndItemId(Long appId, Long itemId) {
        AppItemEntity entity = this.appItemService.findByAppIdAndItemId(appId, itemId);
        AppItemDto dto = (AppItemDto)BeanUtils.copy((Object)entity, AppItemDto.class);
        return DubboResult.successResult((Object)dto);
    }

    public DubboResult<List<AppItemDto>> findAppItemLimit(Map<String, Object> param, int start, int pageSize) {
        return DubboResult.successResult(this.appItemService.findAppItemLimit(param, start, pageSize));
    }

    public DubboResult<Long> findAppItemCount(Map<String, Object> param) {
        return DubboResult.successResult((Object)this.appItemService.findAppItemCount(param));
    }

    public DubboResult<Void> sortByAppItemIdAndRange(Long appId, Long appItemId, Integer startPayload, Integer endPayload) {
        this.appItemService.sortByAppItemIdAndRange(appId, appItemId, startPayload, endPayload);
        return DubboResult.successResult(null);
    }

    public DubboResult<Void> setLimitNull(Long appItemId, Integer limitCount, String limitTimeBetween, Integer limitEverydayQuantity) {
        this.appItemService.setLimitNull(appItemId, limitCount, limitTimeBetween, limitEverydayQuantity);
        return DubboResult.successResult(null);
    }

    public DubboResult<Integer> updateAutoOffDateNull(Long id) {
        return DubboResult.successResult((Object)this.appItemService.updateAutoOffDateNull(id));
    }

    public DubboResult<List<AppItemDto>> findAllByAppAndIsOwner(Long appId, Boolean isOwner) {
        return DubboResult.successResult(this.appItemService.findAllByAppAndIsOwner(appId, isOwner));
    }

    public DubboResult<List<Long>> selectHasUpItems(List<Long> ids, Long appId) {
        return DubboResult.successResult(this.appItemService.selectHasUpItems(ids, appId));
    }

    public DubboResult<Boolean> doUpdateCoupon(AppItemDto appItem, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas, String usePrompt, String btnText) {
        AppItemEntity appItemEntity = (AppItemEntity)BeanUtils.copy((Object)appItem, AppItemEntity.class);
        return DubboResult.successResult((Object)this.appItemService.doUpdateCoupon(appItemEntity, exchangeLimit, arealimitSwitch, arealimitType, arealimitAreas, usePrompt, btnText));
    }

    public DubboResult<List<AppItemDto>> findAllByItemIdsAndAppId(List<Long> itemIds, Long appId) {
        return DubboResult.successResult(this.appItemService.findAllByItemIdsAndAppId(itemIds, appId));
    }

    public DubboResult<AppItemDto> findByAppAndItemOnline(Long appId, Long itemId) {
        return DubboResult.successResult((Object)this.appItemService.findByAppAndItemOnline(appId, itemId));
    }
}

