/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ExchangeStockWarnDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.StockWarnEmailDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteDuibaItemGoodsBackendService;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteDuibaItemGoodsBackendServiceImpl
implements RemoteDuibaItemGoodsBackendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDuibaItemGoodsBackendServiceImpl.class);
    @Autowired
    private ItemService itemService;

    public DubboResult<List<ItemDto>> findByInTypes(List<String> types) {
        for (String type : types) {
            if (this.itemService.isRechargeGoods(type).booleanValue()) continue;
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        List<ItemDto> dtos = this.itemService.findByInTypes(types);
        return DubboResult.successResult(dtos);
    }

    public DubboResult<List<ItemDto>> findAllByName(String name) {
        List<ItemDto> ret = this.itemService.findAllByName(name);
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<ItemDto>> findAllByExpressTemplateId(Long expressTemplateId) {
        List<ItemDto> ret = this.itemService.findAllByExpressTemplateId(expressTemplateId);
        return DubboResult.successResult(ret);
    }

    public DubboResult<Integer> updateAutoOffDateNull(Long id) {
        Integer ret = this.itemService.updateAutoOffDateNull(id);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Integer> updateLimitCountNull(Long id) {
        Integer ret = this.itemService.updateLimitCountNull(id);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Integer> updateValidEndDateById(Long id, Date validEndDate) {
        Integer ret = this.itemService.updateValidEndDateById(id, validEndDate);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Integer> updateOperationsTypeById(Long id, Integer operationsType) {
        Integer ret = this.itemService.updateOperationsTypeById(id, operationsType);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<ItemDto> findBySourceRelationIdAndSourceType(Long sourceRelationId, Integer sourceType) {
        ItemEntity entity = this.itemService.findBySourceRelationIdAndSourceType(sourceRelationId, sourceType);
        ItemDto ret = (ItemDto)BeanUtils.copy((Object)entity, ItemDto.class);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<List<ItemDto>> findAllActivityItemAndEnable(Boolean enable) {
        List<ItemDto> ret = this.itemService.findAllActivityItemAndEnable(enable);
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<ItemDto>> findAllForDuibaSecondsKill() {
        List<ItemDto> ret = this.itemService.findAllForDuibaSecondsKill();
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<ItemDto>> findAllTargetItemList(String type, Boolean deleted, Integer subType) {
        List<ItemDto> ret = this.itemService.findAllTargetItemList(type, deleted, subType);
        return DubboResult.successResult(ret);
    }

    public DubboResult<Page<ItemDto>> findAdminItemPage(Map<String, Object> query) {
        Page<ItemDto> ret = this.itemService.findAdminItemPage(query);
        return DubboResult.successResult(ret);
    }

    public DubboResult<Page<ItemDto>> findRecommandItems(String itemName) {
        Page<ItemDto> ret = this.itemService.findRecommandItems(itemName);
        return DubboResult.successResult(ret);
    }

    public DubboResult<Integer> updateAutoRecommendById(Long id, Boolean autoRecommend) {
        Integer ret = this.itemService.updateAutoRecommendById(id, autoRecommend);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Integer> updatePayloadById(Long id, Integer payload) {
        Integer ret = this.itemService.updatePayloadById(id, payload);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<List<Long>> findAutoRecommendAndTagsItems(Long tagsId) {
        List<Long> ret = this.itemService.findAutoRecommendAndTagsItems(tagsId);
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<ItemDto>> findAllByNameAndType4Lottery(String name, String type) {
        List<ItemDto> ret = this.itemService.findAllByNameAndType4Lottery(name, type);
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<Long>> findIdAllByEnable(Boolean enable) {
        List<Long> ret = this.itemService.findIdAllByEnable(enable);
        return DubboResult.successResult(ret);
    }

    public DubboResult<Integer> updateItemClassifyIdNullById(Long id) {
        Integer ret = this.itemService.updateItemClassifyIdNullById(id);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<List<ItemDto>> findAllByClassify(List<Long> classifyIds) {
        List<ItemDto> ret = this.itemService.findAllByClassify(classifyIds);
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<ItemDto>> findAllEnableCoupon() {
        List<ItemDto> ret = this.itemService.findAllEnableCoupon();
        return DubboResult.successResult(ret);
    }

    public DubboResult<Page<ExchangeStockWarnDto>> findExchangeStockWarnList(Map<String, Object> queryMap) {
        Page<ExchangeStockWarnDto> ret = this.itemService.findExchangeStockWarnList(queryMap);
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<ExchangeStockWarnDto>> findItemStockWarns(Map<String, Object> queryMap) {
        this.itemService.findItemStockWarns(queryMap);
        return DubboResult.successResult(null);
    }

    public DubboResult<Void> emptyExchangeStockWarn() {
        this.itemService.emptyExchangeStockWarn();
        return DubboResult.successResult(null);
    }

    public DubboResult<Void> saveExchangeStockWarn(ExchangeStockWarnDto exchangeStockWarn) {
        this.itemService.saveExchangeStockWarn(exchangeStockWarn);
        return DubboResult.successResult(null);
    }

    public DubboResult<List<StockWarnEmailDto>> findEmailStockList(Map<String, Object> queryMap) {
        List<StockWarnEmailDto> ret = this.itemService.findEmailStockList(queryMap);
        return DubboResult.successResult(ret);
    }

    public DubboResult<Void> saveEmailStockWarn(String emailStr) {
        this.itemService.saveEmailStockWarn(emailStr);
        return DubboResult.successResult(null);
    }

    public DubboResult<Void> emptyEmailStockWarn() {
        this.itemService.emptyEmailStockWarn();
        return DubboResult.successResult(null);
    }

    public DubboResult<Long> findDuibaItemChooseCount(Map<String, Object> paramMap) {
        return DubboResult.successResult((Object)this.itemService.findDuibaItemChooseCount(paramMap));
    }

    public DubboResult<List<ItemDto>> findAllBlacklistItem() {
        return DubboResult.successResult(this.itemService.findAllBlacklistItem());
    }

    public DubboResult<List<ItemDto>> findAutoOffItem() {
        return DubboResult.successResult(this.itemService.findAutoOffItem());
    }

    public DubboResult<Boolean> changeStatus(Long itemId, Boolean enable) {
        try {
            Boolean ret = this.itemService.changeStatus(itemId, enable);
            return DubboResult.successResult((Object)ret);
        }
        catch (RuntimeGoodsException e) {
            LOGGER.warn("changeStatus", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<Long>> findAllPreStockItems(Long appId, int opType) {
        return DubboResult.successResult(this.itemService.findAllPreStockItems(appId, opType));
    }

    public DubboResult<List<ItemDto>> findAllByIdsOrderByIdStr(List<Long> ids, String idsStr) {
        return DubboResult.successResult(this.itemService.findAllByIdsOrderByIdStr(ids, idsStr));
    }
}

