/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponQueryParamDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteItemCouponGoodsBackendService;
import cn.com.duiba.goods.center.biz.service.item.ItemCouponGoodsService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteItemCouponGoodsBackendServiceImpl
implements RemoteItemCouponGoodsBackendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteItemCouponGoodsBackendServiceImpl.class);
    @Autowired
    private ItemCouponGoodsService itemCouponGoodsService;

    public DubboResult<List<GoodsCouponDto>> findPageByBatchIdAndStatus(GoodsCouponQueryParamDto param) {
        try {
            if (param.getPageNum() == null || param.getPageSize() == null) {
                throw new GoodsException(ErrorCode.E0404004);
            }
            return DubboResult.successResult(this.itemCouponGoodsService.pageSearchByBatchIdAndStatus(param));
        }
        catch (GoodsException e) {
            LOGGER.warn("findPageByBatchIdAndStatus failed,", (Object)JSON.toJSONString((Object)param), (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("findPageByBatchIdAndStatus failed,", (Object)JSON.toJSONString((Object)param), (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> importCouponNormal(ItemKeyDto itemKeyDto, Long batchId, Date startDay, Date endDay, String fileUrl) {
        try {
            if (StringUtils.isEmpty((String)fileUrl) || !fileUrl.startsWith("http")) {
                throw new GoodsException(ErrorCode.E0404004);
            }
            Long importId = this.itemCouponGoodsService.importCouponNormal(itemKeyDto, batchId, startDay, endDay, fileUrl);
            return DubboResult.successResult((Object)importId);
        }
        catch (GoodsException e) {
            LOGGER.warn("importCouponNormal: batchId=" + batchId + ",startDay:" + startDay + ",endDay:" + endDay + ",fileUrl:" + fileUrl + ":", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> importCouponLink(ItemKeyDto itemKeyDto, Long batchId, Date startDay, Date endDay, String link, Long stock) {
        try {
            if (StringUtils.isEmpty((String)link) || stock == null) {
                throw new GoodsException(ErrorCode.E0404004);
            }
            Boolean imp = this.itemCouponGoodsService.importCouponLink(itemKeyDto, batchId, startDay, endDay, link, stock);
            return DubboResult.successResult((Object)imp);
        }
        catch (GoodsException e) {
            LOGGER.warn("importCouponLink: batchId=" + batchId + ", startDay:" + startDay + ", endDay:" + endDay + ",link:" + link + ",stock:" + stock + ":", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> importCouponRepeat(ItemKeyDto itemKeyDto, Long batchId, Date startDay, Date endDay, String code, String password, Long stock) {
        try {
            if (StringUtils.isEmpty((String)code) || StringUtils.isEmpty((String)password) || stock == null) {
                throw new GoodsException(ErrorCode.E0404004);
            }
            Boolean imp = this.itemCouponGoodsService.importCouponRepeat(itemKeyDto, batchId, startDay, endDay, code, password, stock);
            return DubboResult.successResult((Object)imp);
        }
        catch (GoodsException e) {
            LOGGER.warn("importCouponRepeat: batchId=" + batchId + ", startDay:" + startDay + ", endDay:" + endDay + ",code:" + code + ",password:" + password + ",stock:" + stock + ":", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

