/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.zhanyi.ZYCouponRecordDto;
import cn.com.duiba.goods.center.biz.dao.ZYCouponRecordDao;
import cn.com.duiba.goods.center.biz.entity.zhanyi.ZYGetCouponDate;
import cn.com.duiba.goods.center.biz.entity.zhanyi.ZYGetCouponResult;
import cn.com.duiba.goods.center.biz.entity.zhanyi.ZYGoodsListResult;
import cn.com.duiba.goods.center.biz.entity.zhanyi.ZYItem;
import cn.com.duiba.goods.center.biz.service.BrandCouponGoodsService;
import cn.com.duiba.goods.center.biz.util.DateUtil;
import cn.com.duiba.goods.center.biz.util.HttpClientUtil;
import cn.com.duiba.goods.center.biz.util.RSA;
import cn.com.duiba.goods.center.biz.util.ZYConstant;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.wolf.utils.SecurityUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="brandCouponGoodsService")
public class BrandCouponGoodsServiceImpl
implements BrandCouponGoodsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrandCouponGoodsServiceImpl.class);
    private String GOODS_LIST_URL = "http://101.200.235.115/DuiBa/GetGoodsList.php";
    private String GET_COUPON_URL = "http://101.200.235.115/DuiBa/GetCoupon.php";
    @Autowired
    private ZYConstant zYConstant;
    @Autowired
    private ZYCouponRecordDao zYCouponRecordDao;

    @Override
    public List<ZYItem> getZYCouponList() throws GoodsException {
        Long timestamp = System.currentTimeMillis();
        String time = String.valueOf(timestamp / 1000L);
        String mds = SecurityUtils.encode2StringByMd5((String)(time + this.zYConstant.getAppKey()));
        String sign = RSA.sign(mds, this.zYConstant.getPrivateKey(), "utf-8");
        JSONObject payParam = new JSONObject();
        payParam.put("timestamp", (Object)time);
        payParam.put("sign", (Object)sign);
        String resp = HttpClientUtil.sendPostWithJSON(this.GOODS_LIST_URL, payParam);
        ZYGoodsListResult result = (ZYGoodsListResult)JSON.parseObject((String)resp, ZYGoodsListResult.class);
        if (result.getStatusCode() != 200) {
            throw new GoodsException(ErrorCode.E0404002.getErrorCode(), "\u8bf7\u6c42\u5c55\u7ffc\u7cfb\u7edf\u5931\u8d25");
        }
        if (result.getData().getResult() != 1000) {
            throw new GoodsException(ErrorCode.E0404002.getErrorCode(), result.getData().getFailReason());
        }
        return result.getData().getItemList();
    }

    @Override
    public ZYGetCouponDate getZYCoupon(String itemName, String itemPrice, String itemId, Integer count) throws GoodsException {
        Long timestamp = System.currentTimeMillis();
        String time = String.valueOf(timestamp / 1000L);
        String statement = "DB" + DateUtil.getYYDayMinuteString(new Date()) + "00";
        JSONObject payParam = new JSONObject();
        payParam.put("statement", (Object)statement);
        payParam.put("item_id", (Object)itemId);
        payParam.put("count", (Object)count);
        payParam.put("timestamp", (Object)time);
        String mds = SecurityUtils.encode2StringByMd5((String)(statement + itemId + count + time + this.zYConstant.getAppKey()));
        String sign = RSA.sign(mds, this.zYConstant.getPrivateKey(), "utf-8");
        payParam.put("sign", (Object)sign);
        String resp = HttpClientUtil.sendPostWithJSON(this.GET_COUPON_URL, payParam);
        ZYGetCouponResult result = (ZYGetCouponResult)JSON.parseObject((String)resp, ZYGetCouponResult.class);
        if (result.getStatusCode() != 200) {
            throw new GoodsException(ErrorCode.E0404002.getErrorCode(), "\u8bf7\u6c42\u5c55\u7ffc\u7cfb\u7edf\u5931\u8d25");
        }
        ZYGetCouponDate data = result.getData();
        if (data.getResult() != 1000) {
            throw new GoodsException(ErrorCode.E0404002.getErrorCode(), result.getData().getFailReason());
        }
        ZYCouponRecordDto entity = new ZYCouponRecordDto();
        try {
            entity.setStatement(data.getStatement());
            entity.setItemId(data.getItemId());
            entity.setItemName(itemName);
            entity.setItemPrice(itemPrice);
            entity.setTimestamp(new Date(data.getTimestamp() * 1000L));
            entity.setExpiredDate(DateUtil.getDayDate(data.getExpiredDate()));
            entity.setCouponCount(data.getCouponCount());
            this.insert(entity);
        }
        catch (Exception e) {
            LOGGER.error("\u5c55\u7ffc\u4f18\u60e0\u5238\u8d2d\u4e70\u8bb0\u5f55\u63d2\u5165\u51fa\u9519", (Throwable)e);
        }
        data.setRecordId(entity.getId());
        return data;
    }

    @Override
    public List<ZYCouponRecordDto> findCouponPage(String itemName, Integer start, Integer pageSize) {
        return this.zYCouponRecordDao.findCouponPage(itemName, start, pageSize);
    }

    @Override
    public int insert(ZYCouponRecordDto entity) {
        return this.zYCouponRecordDao.insert(entity);
    }

    @Override
    public Integer findCouponPageCount(String itemName) {
        return this.zYCouponRecordDao.findCouponPageCount(itemName);
    }

    @Override
    public int updateFilePath(Long id, String filePath) {
        return this.zYCouponRecordDao.updateFilePath(id, filePath);
    }
}

