/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.enums.CouponType;
import cn.com.duiba.goods.center.api.remoteservice.enums.GoodsCouponStatusEnum;
import cn.com.duiba.goods.center.biz.dao.GoodsBatchDao;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponRetrieveLogEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponRetrieveLogService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.service.RedisCacheService;
import cn.com.duiba.goods.center.biz.service.stock.StockService;
import cn.com.duiba.goods.center.biz.util.AppendUploadUtil;
import cn.com.duiba.goods.center.biz.util.RedisKeyFactory;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class GoodsBatchServiceImpl
implements GoodsBatchService {
    private static Logger log = LoggerFactory.getLogger(GoodsBatchServiceImpl.class);
    @Autowired
    private GoodsBatchDao goodsBatchDao;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    private GoodsCouponRetrieveLogService goodsCouponRetrieveLogService;
    @Autowired
    private StockService stockService;
    @Autowired
    private AppendUploadUtil appendUploadUtil;
    @Autowired
    private GoodsCouponService goodsCouponService;
    @Autowired
    protected RedisCacheService redisCacheService;
    @Resource
    private ExecutorService executorService;
    private Long position = 0L;
    private static final long PERRETRIEVEGOODSCOUPON = 999L;
    private static final String FILEURLPREFIX = "http://yun.duiba.com.cn/";
    private String timeStart = " 00:00:00";
    private String timeEnd = " 23:59:59";

    @Override
    public Long createNormalBatch(GoodsTypeEnum gtype, long gid, Date startDay, Date endDay, Long stockId) {
        Date startDate = DateUtils.getSecondDate((String)(DateUtils.getDayStr((Date)startDay) + this.timeStart));
        Date endDate = DateUtils.getSecondDate((String)(DateUtils.getDayStr((Date)endDay) + this.timeEnd));
        return this.goodsBatchDao.insert(gtype, gid, CouponType.Normal, startDate, endDate, stockId);
    }

    @Override
    public Long createLinkBatch(GoodsTypeEnum gtype, long gid, Date startDay, Date endDay, Long stockId) {
        Date startDate = DateUtils.getSecondDate((String)(DateUtils.getDayStr((Date)startDay) + this.timeStart));
        Date endDate = DateUtils.getSecondDate((String)(DateUtils.getDayStr((Date)endDay) + this.timeEnd));
        return this.goodsBatchDao.insert(gtype, gid, CouponType.Link, startDate, endDate, stockId);
    }

    @Override
    public Long createRepeatBatch(GoodsTypeEnum gtype, long gid, Date startDay, Date endDay, Long stockId) {
        Date startDate = DateUtils.getSecondDate((String)(DateUtils.getDayStr((Date)startDay) + this.timeStart));
        Date endDate = DateUtils.getSecondDate((String)(DateUtils.getDayStr((Date)endDay) + this.timeEnd));
        return this.goodsBatchDao.insert(gtype, gid, CouponType.Repeat, startDate, endDate, stockId);
    }

    @Override
    public List<GoodsBatchEntity> findNormalBatchs(GoodsTypeEnum gtype, long gid) {
        return this.goodsBatchDao.selectNotDeletedNotExpiredGtypeGid(gtype, gid);
    }

    @Override
    public List<GoodsBatchEntity> findNotDeletedBatchs(GoodsTypeEnum gtype, long gid) {
        return this.goodsBatchDao.selectNotDeletedByGtypeGid(gtype, gid);
    }

    @Override
    public Boolean deleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        int ret;
        GoodsBatchEntity e = this.goodsBatchDao.select(batchId);
        if (e.getImporting().booleanValue()) {
            return false;
        }
        if (e.getBatchType() == 0) {
            boolean existUsedCoupon = this.goodsCouponService.findBatchExsitUsedCoupon(gtype, gid, batchId);
            if (existUsedCoupon) {
                return false;
            }
        } else {
            DubboResult ret2 = this.remoteStockService.findDto(e.getStockId().longValue());
            if (ret2.isSuccess()) {
                Long totalStock;
                StockDto dto = (StockDto)ret2.getResult();
                Long stock = dto.getStock();
                if (!stock.equals(totalStock = Long.valueOf(dto.getTotalStock()))) {
                    return false;
                }
            } else {
                throw new RuntimeGoodsException(ErrorCode.E9999999);
            }
        }
        if ((ret = this.goodsBatchDao.deleteBatch(gtype, gid, batchId)) == 1) {
            DubboResult dubbo = this.remoteStockService.find(e.getStockId().longValue());
            this.remoteStockBackendService.decreaseItemStock(e.getStockId().longValue(), ((Long)dubbo.getResult()).longValue());
            return true;
        }
        return false;
    }

    @Override
    public GoodsBatchEntity find(Long goodsBatchId) {
        return this.goodsBatchDao.select(goodsBatchId);
    }

    @Override
    public Long getSumBatchStock(GoodsTypeEnum gtype, long gid) {
        return this.getSumBatchStockBatch(gtype, gid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getSumBatchStockBatch(GoodsTypeEnum gtype, long gid) {
        long total = 0L;
        ArrayList<Long> stockIds = new ArrayList<Long>();
        try {
            DBTimeProfile.enter((String)"findNormalBatchs");
            List<GoodsBatchEntity> list = this.findNormalBatchs(gtype, gid);
            for (GoodsBatchEntity goodsBatchEntity : list) {
                if (goodsBatchEntity.getStatus() == 4 || goodsBatchEntity.getStatus() == 3) continue;
                stockIds.add(goodsBatchEntity.getStockId());
            }
        }
        finally {
            DBTimeProfile.release();
        }
        try {
            DBTimeProfile.enter((String)"remoteStockService.findBatch");
            if (!stockIds.isEmpty()) {
                DubboResult stockRet = this.remoteStockService.findBatch(stockIds);
                if (!stockRet.isSuccess()) {
                    log.error("remoteStockService.findBatch error,msg=" + stockRet.getMsg());
                }
                for (Map.Entry entry : ((Map)stockRet.getResult()).entrySet()) {
                    total += ((Long)entry.getValue()).longValue();
                }
            }
        }
        finally {
            DBTimeProfile.release();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getTotalAllBatchStock(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)"GoodsBatchServiceImpl.getTotalAllBatchStock");
            List<GoodsBatchEntity> list = this.findNotDeletedBatchs(gtype, gid);
            ArrayList<Long> stockIds = new ArrayList<Long>();
            for (GoodsBatchEntity e : list) {
                if (e.getStatus() == 4) continue;
                stockIds.add(e.getStockId());
            }
            Map<Long, StockDto> stocks = this.stockService.findStockByStockIds(stockIds);
            long total = 0L;
            for (GoodsBatchEntity e : list) {
                if (e.getStatus() == 4) continue;
                StockDto dto = stocks.get(e.getStockId());
                long tatalStock = dto == null ? 0L : dto.getTotalStock();
                total += tatalStock;
            }
            Long l = total;
            return l;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public void markBatchStatusUsed(long batchId) {
        this.goodsBatchDao.updateStatusUsed(batchId);
    }

    @Override
    public void markBatchStatusUsed(GoodsTypeEnum gtype, long gid, long batchId) {
        this.goodsBatchDao.updateStatusUsed(batchId);
    }

    @Override
    public void markBatchStatusUsing(long batchId) {
        this.goodsBatchDao.updateStatusUsing(batchId);
    }

    @Override
    public void markBatchStatusUsing(GoodsTypeEnum gtype, long gid, long batchId) {
        this.goodsBatchDao.updateStatusUsing(batchId);
    }

    @Override
    public void markBatchStatusNotUsed(long batchId) {
        this.goodsBatchDao.updateStatusNotUsed(batchId);
    }

    @Override
    public Boolean updateValidDate(GoodsTypeEnum gtype, long gid, long batchId, Date startDay, Date endDay) {
        Date endDate;
        Date startDate = DateUtils.getSecondDate((String)(DateUtils.getDayStr((Date)startDay) + this.timeStart));
        if (this.goodsBatchDao.updateValidDate(batchId, startDate, endDate = DateUtils.getSecondDate((String)(DateUtils.getDayStr((Date)endDay) + this.timeEnd))) == 1) {
            return true;
        }
        return false;
    }

    @Override
    public boolean updateGoodsType(GoodsTypeEnum gtype, long gid, int dstType) {
        if (gtype.equals((Object)GoodsTypeEnum.ADVERT)) {
            int row = this.goodsBatchDao.updateBatchType(gid, dstType);
            return row >= 1;
        }
        return false;
    }

    @Override
    public Boolean physicalDeleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        GoodsBatchEntity e = this.goodsBatchDao.select(batchId);
        int row = this.goodsBatchDao.physicalDeleteBatch(gtype, gid, batchId);
        if (row >= 1) {
            DubboResult ret = this.remoteStockService.find(e.getStockId().longValue());
            this.remoteStockBackendService.decreaseItemStock(e.getStockId().longValue(), ((Long)ret.getResult()).longValue());
            return true;
        }
        return false;
    }

    @Override
    public List<GoodsBatchEntity> findGoodsBatchs(GoodsTypeEnum gtype, List<Long> gids) {
        return this.goodsBatchDao.selectGoodsBatchs(gtype, gids);
    }

    private String getRetrieveLockKey(GoodsTypeEnum gtype, Long gid, Long goodsBatchId) {
        return (Object)((Object)RedisKeyFactory.K204) + String.valueOf(gid) + "_" + gtype.getGtype() + "_" + goodsBatchId + "_lock";
    }

    @Override
    public Long retrieveGoodsBatch(final GoodsTypeEnum gtype, final Long gid, final Long batchId, final Long count) throws GoodsException {
        Long rst;
        final GoodsBatchEntity batch = this.find(batchId);
        if (batch == null) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u6279\u6b21\u4e0d\u5b58\u5728");
        }
        final int oriStatus = batch.getStatus();
        if (1 != oriStatus && 2 != oriStatus) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "[\u5df2\u4f7f\u7528,\u672a\u4f7f\u7528]\u7684\u6279\u6b21\u624d\u80fd\u56de\u6536");
        }
        if (!this.redisCacheService.getLock(this.getRetrieveLockKey(gtype, gid, batchId), 300)) {
            throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u6279\u6b21\u5df2\u88ab\u9501");
        }
        try {
            this.markBatchStatusUsed(batchId);
            final Long count1 = rst = this.createRetrieveLog(gtype, gid, batchId, 0, 0, "");
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        GoodsBatchServiceImpl.this.doRetrieveGoodsCoupon(batch, oriStatus, gtype, gid, batchId, count, count1);
                    }
                    catch (Exception e) {
                        log.error("doRetrieveGoodsCoupon", (Throwable)e);
                    }
                    finally {
                        GoodsBatchServiceImpl.this.updateToOriStatus(batchId, oriStatus);
                        GoodsBatchServiceImpl.this.redisCacheService.releaseLock(GoodsBatchServiceImpl.this.getRetrieveLockKey(gtype, gid, batchId));
                    }
                }
            });
        }
        catch (Exception e) {
            this.updateToOriStatus(batchId, oriStatus);
            log.error("\u56de\u6536\u6279\u6b21\u51fa\u9519:", (Throwable)e);
            throw e;
        }
        return rst;
    }

    private void updateToOriStatus(Long batchId, int oriStatus) {
        if (oriStatus == 1) {
            this.markBatchStatusNotUsed(batchId);
        } else if (oriStatus == 2) {
            this.markBatchStatusUsing(batchId);
        }
    }

    private void doRetrieveGoodsCoupon(GoodsBatchEntity batch, int oriStatus, GoodsTypeEnum gtype, Long gid, Long batchId, Long count, Long logid) throws GoodsException {
        int successRetrieveCount = 0;
        this.position = 0L;
        String filePath = this.getFileName(gid, batchId);
        try {
            DubboResult dubboResult = this.remoteStockService.find(batch.getStockId().longValue());
            if (dubboResult.isSuccess()) {
                Long stockNum = (Long)dubboResult.getResult();
                if (stockNum != null) {
                    if (stockNum == 0L) {
                        this.goodsCouponRetrieveLogService.updateStatusFail(logid);
                        throw new GoodsException(ErrorCode.E0202006);
                    }
                    if (stockNum < count) {
                        count = stockNum;
                    }
                } else {
                    this.goodsCouponRetrieveLogService.updateStatusFail(logid);
                    throw new GoodsException(ErrorCode.E0202006);
                }
            }
            long forCount = this.caculateForCount(count);
            String key = filePath + ".txt";
            this.appendUploadUtil.setKey(key);
            boolean isLastPage = false;
            if (forCount == 1L) {
                List<GoodsCouponEntity> list = this.goodsCouponService.findPageByStatus(gtype, gid, batchId, GoodsCouponStatusEnum.STATUS_NEW.getCode(), 0, (int)count.longValue());
                isLastPage = true;
                successRetrieveCount += this.deleteGoodsCoupons(gid, batchId, list, logid, isLastPage);
            } else {
                try {
                    int i = 0;
                    while ((long)i < forCount) {
                        List<GoodsCouponEntity> list;
                        if ((long)i == forCount - 1L) {
                            list = this.goodsCouponService.findPageByStatus(gtype, gid, batchId, GoodsCouponStatusEnum.STATUS_NEW.getCode(), 0, (int)(count - (long)successRetrieveCount));
                            isLastPage = true;
                        } else {
                            list = this.goodsCouponService.findPageByStatus(gtype, gid, batchId, GoodsCouponStatusEnum.STATUS_NEW.getCode(), 0, 999);
                        }
                        successRetrieveCount += this.deleteGoodsCoupons(gid, batchId, list, logid, isLastPage);
                        ++i;
                    }
                }
                catch (Exception e) {
                    log.error("\u5206\u9875\u56de\u6536\u6279\u6b21\u51fa\u9519", (Throwable)e);
                }
            }
            this.completeRetrieve(gid, batchId, count, batch, successRetrieveCount, logid, key);
            log.info("\u6210\u529f\u56de\u6536\u5238\u7801\u603b\u6570" + successRetrieveCount + "\u6761");
        }
        catch (Exception e) {
            log.error("\u56de\u6536\u5238\u7801\u5931\u8d25\u3002", (Throwable)e);
            throw e;
        }
    }

    private int deleteGoodsCoupons(Long gid, Long batchId, List<GoodsCouponEntity> list, Long logid, boolean isLastPage) {
        int rst = 0;
        if (!CollectionUtils.isEmpty(list)) {
            log.info("\u5206\u9875\u56de\u6536\u5238\u7801\u6570\u91cf:" + list.size());
            try {
                List<Long> deleteIds = this.appendContenToOss(list, isLastPage);
                rst = this.goodsCouponService.deleteGoodsCouponByIds(gid, batchId, deleteIds);
            }
            catch (Exception e) {
                log.error("appendContenToOss, deleteGoodsCouponByIds", (Throwable)e);
                rst = 0;
            }
        } else {
            log.info("\u6ca1\u6709\u53ef\u56de\u6536\u7684\u5238\u7801");
        }
        return rst;
    }

    private void completeRetrieve(Long gid, Long batchId, Long count, GoodsBatchEntity batch, int successRetrieveCount, Long logId, String filePath) {
        this.remoteStockBackendService.decreaseItemStock(batch.getStockId().longValue(), (long)successRetrieveCount);
        this.updateLogStatus(logId, successRetrieveCount, count, filePath);
    }

    private void updateLogStatus(Long logId, int successRetrieveCount, Long count, String fileUrl) {
        String url = FILEURLPREFIX + fileUrl;
        log.info("update the fileUrl to the tb_goods_coupon_retrieve_log " + url);
        if (successRetrieveCount != 0 && count == (long)successRetrieveCount) {
            this.goodsCouponRetrieveLogService.updateStatusSuccess(logId, url, successRetrieveCount);
        } else if (successRetrieveCount != 0 && count > (long)successRetrieveCount) {
            this.goodsCouponRetrieveLogService.updateStatusPart(logId, url, successRetrieveCount);
        }
    }

    private long caculateForCount(Long count) {
        long forCount = count % 999L == 0L ? count / 999L : count / 999L + 1L;
        return forCount;
    }

    private String getFileName(Long gid, Long batchId) {
        return "tuia/manager/coupon-retrieve/" + gid + "_" + batchId + "_" + new Date().getTime();
    }

    private Long createRetrieveLog(GoodsTypeEnum gtype, Long gid, Long batchId, int successRetrieveCount, Integer retrieveStatus, String filePath) {
        GoodsCouponRetrieveLogEntity entity = new GoodsCouponRetrieveLogEntity();
        entity.setBatchId(batchId);
        entity.setGid(gid);
        entity.setStatus(retrieveStatus);
        entity.setGoodsType(gtype.getGtype());
        entity.setRecoveryAmount(successRetrieveCount);
        entity.setFileUrl(filePath);
        return this.goodsCouponRetrieveLogService.create(entity);
    }

    private List<Long> appendContenToOss(List<GoodsCouponEntity> list, boolean isLastPage) throws GoodsException {
        ArrayList<Long> rst = new ArrayList<Long>(1000);
        StringBuilder content = new StringBuilder();
        int i = 0;
        for (GoodsCouponEntity entity : list) {
            ++i;
            if (!StringUtils.isEmpty((Object)entity.getCode())) {
                content.append(entity.getCode());
            }
            if (!StringUtils.isEmpty((Object)entity.getPassword())) {
                content.append("\t");
                content.append(entity.getPassword());
            }
            if (!isLastPage || i != list.size()) {
                content.append("\n");
            }
            rst.add(entity.getId());
        }
        this.position = this.appendUploadUtil.upload(content.toString(), this.position);
        return rst;
    }

    @Override
    public GoodsBatchEntity findByStartDayAndDay(GoodsTypeEnum gtype, Long gid, Date startDay, Date endDay) {
        Date startDate = DateUtils.getSecondDate((String)(DateUtils.getDayStr((Date)startDay) + this.timeStart));
        Date endDate = DateUtils.getSecondDate((String)(DateUtils.getDayStr((Date)endDay) + this.timeEnd));
        return this.goodsBatchDao.selectByStartDayAndDay(gtype, gid, startDate, endDate);
    }

    @Override
    public List<ACGStockDto> findStockByGids(GoodsTypeEnum gtype, List<Long> gids) {
        List<GoodsBatchEntity> batchs = this.goodsBatchDao.selectGoodsBatchs(gtype, gids);
        ArrayList<Long> stockIds = new ArrayList<Long>();
        for (GoodsBatchEntity entity : batchs) {
            stockIds.add(entity.getStockId());
        }
        if (stockIds.isEmpty()) {
            return new ArrayList<ACGStockDto>();
        }
        Map<Long, StockDto> stockMap = this.stockService.findStockByStockIds(stockIds);
        HashMap<Long, StockDto> batchStockMap = new HashMap<Long, StockDto>();
        for (GoodsBatchEntity entity : batchs) {
            batchStockMap.put(entity.getId(), stockMap.get(entity.getStockId()));
        }
        HashMap<Long, StockDto> goodsStockMap = new HashMap<Long, StockDto>();
        Date now = new Date();
        for (GoodsBatchEntity entity : batchs) {
            StockDto batchStock = (StockDto)batchStockMap.get(entity.getId());
            if (batchStock == null) continue;
            StockDto goodsStock = (StockDto)goodsStockMap.get(entity.getGid());
            if (goodsStock == null) {
                goodsStock = new StockDto();
            }
            Long stock = goodsStock.getStock();
            Long totalStock = goodsStock.getTotalStock();
            if (3 != entity.getStatus() && 4 != entity.getStatus() && entity.getEndDay().after(now)) {
                stock = stock + batchStock.getStock();
            }
            if (4 != entity.getStatus()) {
                totalStock = totalStock + batchStock.getTotalStock();
            }
            goodsStock.setStock(stock.longValue());
            goodsStock.setTotalStock(totalStock.longValue());
            goodsStockMap.put(entity.getGid(), goodsStock);
        }
        ArrayList<ACGStockDto> acgs = new ArrayList<ACGStockDto>();
        for (Long gid : gids) {
            StockDto stock = (StockDto)goodsStockMap.get(gid);
            if (stock == null) {
                stock = new StockDto();
            }
            ACGStockDto dto = new ACGStockDto();
            dto.setAcgId(gid);
            dto.setStock(Long.valueOf(stock.getStock()));
            dto.setTotalStock(Long.valueOf(stock.getTotalStock()));
            acgs.add(dto);
        }
        return acgs;
    }

    @Override
    public ACGStockDto findStockByGid(GoodsTypeEnum gtype, Long gid) {
        List<GoodsBatchEntity> batchs = this.goodsBatchDao.selectNotDeletedByGtypeGid(gtype, gid);
        ArrayList<Long> stockIds = new ArrayList<Long>();
        for (GoodsBatchEntity entity : batchs) {
            stockIds.add(entity.getStockId());
        }
        if (stockIds.isEmpty()) {
            return new ACGStockDto();
        }
        Map<Long, StockDto> stockMap = this.stockService.findStockByStockIds(stockIds);
        HashMap<Long, StockDto> batchStockMap = new HashMap<Long, StockDto>();
        for (GoodsBatchEntity entity : batchs) {
            batchStockMap.put(entity.getId(), stockMap.get(entity.getStockId()));
        }
        Date now = new Date();
        Long stock = 0L;
        Long totalStock = 0L;
        for (GoodsBatchEntity entity : batchs) {
            StockDto batchStock = (StockDto)batchStockMap.get(entity.getId());
            if (batchStock == null) continue;
            if (3 != entity.getStatus() && 4 != entity.getStatus() && entity.getEndDay().after(now)) {
                stock = stock + batchStock.getStock();
            }
            if (4 == entity.getStatus()) continue;
            totalStock = totalStock + batchStock.getTotalStock();
        }
        ACGStockDto gstock = new ACGStockDto();
        gstock.setAcgId(gid);
        gstock.setStock(stock);
        gstock.setTotalStock(totalStock);
        return gstock;
    }

    @Override
    public List<GoodsBatchDto> findBatchsNoCode(GoodsTypeEnum gtype, List<Long> gids) {
        List<GoodsBatchEntity> ret = this.goodsBatchDao.selectGoodsBatchs(gtype, gids);
        ArrayList<GoodsBatchEntity> batchs = new ArrayList<GoodsBatchEntity>();
        ArrayList<Long> stockIds = new ArrayList<Long>();
        for (GoodsBatchEntity entity : ret) {
            if (entity.getStatus() == 4) continue;
            batchs.add(entity);
            stockIds.add(entity.getStockId());
        }
        if (stockIds.isEmpty()) {
            return new ArrayList<GoodsBatchDto>();
        }
        Map<Long, StockDto> stockMap = this.stockService.findStockByStockIds(stockIds);
        HashMap<Long, StockDto> batchStockMap = new HashMap<Long, StockDto>();
        for (GoodsBatchEntity entity : batchs) {
            batchStockMap.put(entity.getId(), stockMap.get(entity.getStockId()));
        }
        List batchDtos = BeanUtils.copyList(batchs, GoodsBatchDto.class);
        for (GoodsBatchDto dto : batchDtos) {
            StockDto batchStock = (StockDto)batchStockMap.get(dto.getId());
            if (batchStock == null) {
                batchStock = new StockDto();
            }
            dto.setStock(Long.valueOf(batchStock.getStock()));
            dto.setTotalStock(Long.valueOf(batchStock.getTotalStock()));
        }
        return batchDtos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsBatchEntity refreshGoodsBatchs(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)"switchGoodsBatch");
            List<GoodsBatchEntity> batchs = this.findNormalBatchs(gtype, gid);
            Map<Long, StockDto> stocks = this.stockService.findGoodsBatchStocks(batchs);
            for (GoodsBatchEntity e : batchs) {
                StockDto stock = stocks.get(e.getStockId());
                boolean markUsed = stock != null && stock.getStock() <= 0L && e.getStatus() != 3;
                if (!markUsed) continue;
                this.markBatchStatusUsed(gtype, gid, e.getId());
            }
            batchs = this.findNormalBatchs(gtype, gid);
            ArrayList<GoodsBatchEntity> backups = new ArrayList<GoodsBatchEntity>();
            Date min = null;
            for (GoodsBatchEntity e : batchs) {
                boolean usable;
                boolean bl = usable = e.getStatus() == 1 || e.getStatus() == 2;
                if (!usable) continue;
                backups.add(e);
                boolean isMin = min == null || e.getStartDay().before(min);
                if (!isMin) continue;
                min = e.getStartDay();
            }
            for (GoodsBatchEntity e : backups) {
                if (!e.getStartDay().equals(min)) continue;
                this.markBatchStatusUsing(gtype, gid, e.getId());
                e.setStatus(2);
                GoodsBatchEntity goodsBatchEntity = e;
                return goodsBatchEntity;
            }
            GoodsBatchEntity goodsBatchEntity = null;
            return goodsBatchEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsBatchEntity refreshGoodsBatchsNow(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)"switchGoodsBatch");
            List<GoodsBatchEntity> batchs = this.findNotDeletedBatchs(gtype, gid);
            this.refreshByStock(batchs);
            batchs = this.findNormalBatchs(gtype, gid);
            ArrayList<GoodsBatchEntity> backups = new ArrayList<GoodsBatchEntity>();
            Date min = null;
            for (GoodsBatchEntity e : batchs) {
                boolean usable;
                boolean bl = usable = e.getStatus() == 1 || e.getStatus() == 2;
                if (!usable) continue;
                backups.add(e);
                boolean isMin = min == null || e.getStartDay().before(min);
                if (!isMin) continue;
                min = e.getStartDay();
            }
            for (GoodsBatchEntity e : backups) {
                if (!e.getStartDay().equals(min)) continue;
                this.markBatchStatusUsing(gtype, gid, e.getId());
                e.setStatus(2);
                GoodsBatchEntity goodsBatchEntity = e;
                return goodsBatchEntity;
            }
            GoodsBatchEntity goodsBatchEntity = null;
            return goodsBatchEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private void refreshByStock(List<GoodsBatchEntity> batchs) {
        for (GoodsBatchEntity entity : batchs) {
            if (entity.getEndDay().before(new Date())) continue;
            Long stock = (Long)this.remoteStockBackendService.find(entity.getStockId().longValue()).getResult();
            if (stock < 1L) {
                this.markBatchStatusUsed(entity.getId());
                continue;
            }
            if (entity.getStatus() <= 2) continue;
            this.markBatchStatusNotUsed(entity.getId());
        }
    }
}

