/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.dao.GoodsBatchDao;
import cn.com.duiba.goods.center.biz.dao.GoodsCouponDao;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.service.RedisCacheService;
import cn.com.duiba.goods.center.biz.service.stock.StockService;
import cn.com.duiba.goods.center.biz.util.ConsumeStockTypeUtil;
import cn.com.duiba.goods.center.biz.util.RedisKeyFactory;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerBackendService;
import cn.com.duiba.stock.service.api.constant.STErrorCode;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsCouponService")
public class GoodsCouponServiceImpl
implements GoodsCouponService {
    private static Logger log = LoggerFactory.getLogger(GoodsCouponServiceImpl.class);
    private Lock lock = new ReentrantLock();
    @Autowired
    private GoodsCouponDao goodsCouponDao;
    @Autowired
    private GoodsBatchDao goodsBatchDao;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private StockService stockService;
    @Autowired
    protected GoodsCouponService goodsCouponService;
    @Autowired
    protected GoodsBatchService goodsBatchService;
    @Autowired
    private RemoteIDMakerBackendService remoteIDMakerBackendService;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    protected RedisCacheService redisCacheService;

    @Override
    public GoodsCouponEntity find(Long goodsCouponId) {
        return this.goodsCouponDao.selectByCouponId(goodsCouponId);
    }

    @Override
    public Boolean updateLinkBatch(GoodsTypeEnum gtype, long gid, Long batchId, String link) {
        int ret = this.goodsCouponDao.updateLinkCoupon(gtype, gid, batchId, link);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public void importLinkCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, String link) {
        this.goodsCouponDao.insertLinkCoupon(gtype, gid, goodsBatchId, goodsCouponId, link);
    }

    @Override
    public void importRepeatCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, String code, String password) {
        this.goodsCouponDao.insertRepeatCoupon(gtype, gid, goodsBatchId, goodsCouponId, code, password);
    }

    @Override
    public Boolean updateRepeatBatch(GoodsTypeEnum gtype, long gid, Long batchId, String code, String password) {
        int ret = this.goodsCouponDao.updateRepeatCoupon(gtype, gid, batchId, code, password);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public Integer importNormalCoupons(GoodsBatchEntity batch, List<GoodsCouponDao.CouponFormat> coupons) {
        if (coupons.size() > 1000000) {
            throw new RuntimeGoodsException(ErrorCode.E9999999, new Throwable("\u8d85\u51fa100W\uff0c\u62d2\u7edd\u5bfc\u5165"));
        }
        int maxRecords = 20000;
        int size = coupons.size();
        int batchs = size % 20000 == 0 ? size / 20000 : size / 20000 + 1;
        ArrayList group = new ArrayList(batchs);
        HashMap<Integer, AtomicInteger> countMap = new HashMap<Integer, AtomicInteger>();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < batchs; ++i) {
            ArrayList l = new ArrayList(20000);
            group.add(l);
            countMap.put(i, new AtomicInteger());
        }
        block1: for (GoodsCouponDao.CouponFormat cf : coupons) {
            if (set.add(cf.getCode())) {
                for (int i = 0; i < group.size(); ++i) {
                    List cflist = (List)group.get(i);
                    if (((AtomicInteger)countMap.get(i)).get() >= 20000) continue;
                    ((AtomicInteger)countMap.get(i)).incrementAndGet();
                    cflist.add(cf);
                    continue block1;
                }
                continue;
            }
            log.warn("\u91cd\u590d\u5238\u7801 code=" + cf.getCode());
        }
        int totalSuccess = 0;
        for (List list : group) {
            if (list.isEmpty()) continue;
            totalSuccess += this.goodsCouponDao.insertBatchImport(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype()), batch.getGid(), batch.getId(), list);
        }
        DubboResult stockRet = this.remoteStockBackendService.increaseItemStock(batch.getStockId().longValue(), (long)totalSuccess);
        if (!stockRet.isSuccess() && !((Boolean)stockRet.getResult()).booleanValue()) {
            log.error("remoteStockBackendService.increaseItemStock fail ,msg=" + stockRet.getMsg());
        }
        return totalSuccess;
    }

    @Override
    public Page<GoodsCouponEntity> findPage(GoodsTypeEnum gtype, long gid, long batchId, int pageSize, int pageIndex, int total) {
        Page page = new Page(pageSize, pageIndex);
        int count = total;
        int start = (pageIndex - 1) * pageSize;
        int limit = pageSize;
        List<GoodsCouponEntity> list = this.goodsCouponDao.selectPageByBatchId(gtype, gid, batchId, start, limit);
        page.setTotalPages(count % pageSize == 0 ? count / pageSize : count / pageSize + 1);
        page.setList(list);
        page.setTotalCount(count);
        return page;
    }

    @Override
    public List<GoodsCouponEntity> findPageByStatus(GoodsTypeEnum gtype, long gid, long batchId, Integer status, int start, int limit) {
        if (status == null) {
            return this.goodsCouponDao.selectPageByBatchId(gtype, gid, batchId, start, limit);
        }
        return this.goodsCouponDao.selectPageByBatchIdAndStatus(gtype, gid, batchId, status, start, limit);
    }

    @Override
    public void completeCoupon(Long couponId, long orderId) {
        this.goodsCouponDao.updateCoupnoMarkUsed(couponId, orderId);
    }

    @Override
    public Boolean rollbackNormalCoupon(Long couponId) {
        int ret = this.goodsCouponDao.updateCouponMarkRollback(couponId);
        return ret == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<GoodsCouponEntity> loadCouponByBatchId(GoodsTypeEnum gtype, long gid, long batchId, int limit) {
        try {
            DBTimeProfile.enter((String)"selectBatchNotUsed");
            List<GoodsCouponEntity> list = this.goodsCouponDao.selectBatchNotUsed(gtype, gid, batchId, limit);
            return list;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean takeCoupon4Point(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, long consumerId, String bizNum) {
        try {
            DBTimeProfile.enter((String)"takeCoupon4Point");
            if (GoodsTypeEnum.ADVERT.getGtype() == gtype.getGtype()) {
                Long bizId = StringUtils.isNumeric((String)bizNum) ? Long.valueOf(bizNum) : null;
                int ret = this.goodsCouponDao.updateAdvertCouponMarkUsed(goodsCouponId, consumerId, bizId);
                boolean bl = ret > 0;
                return bl;
            }
            int ret = this.goodsCouponDao.updateCouponMarkLocked(gtype, gid, goodsBatchId, goodsCouponId, consumerId);
            boolean bl = ret == 1;
            return bl;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public GoodsCouponEntity findOneByGoodsBatchId(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        return this.goodsCouponDao.selectOneByGoodsBatchId(gtype, gid, goodsBatchId);
    }

    @Override
    public List<GoodsCouponEntity> searchByCode(GoodsTypeEnum gtype, long gid, long goodsBatchId, String code) {
        return this.goodsCouponDao.selectSearchByCode(gtype, gid, goodsBatchId, code);
    }

    @Override
    public boolean deleteGoodsCoupon(GoodsTypeEnum gtype, long gid, long batchId) {
        GoodsBatchEntity e = this.goodsBatchDao.select(batchId);
        int ret = this.goodsCouponDao.deleteGoodsCoupon(gtype, gid, batchId);
        if (ret > 0) {
            this.remoteStockBackendService.decreaseItemStock(e.getStockId().longValue(), (long)ret);
            return true;
        }
        return false;
    }

    @Override
    public int deleteGoodsCouponByIds(long gid, Long batchId, List<Long> ids) {
        return this.goodsCouponDao.deleteGoodsCouponByIds(gid, ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean deleteBatchUnusedCoupons(GoodsBatchEntity batch) {
        try {
            if (!this.lock.tryLock()) {
                Boolean bl = false;
                return bl;
            }
            if (batch.getBatchType() == 0) {
                int ret = this.goodsCouponDao.deleteBatchUnusedCoupons(batch.getGtype(), batch.getGid(), batch.getId());
                if (ret > 0) {
                    this.remoteStockBackendService.decreaseItemStock(batch.getStockId().longValue(), (long)ret);
                    Boolean bl = true;
                    return bl;
                }
            } else {
                DubboResult stockRet = this.remoteStockService.find(batch.getStockId().longValue());
                this.remoteStockBackendService.decreaseItemStock(batch.getStockId().longValue(), ((Long)stockRet.getResult()).longValue());
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Boolean deleteUnusedCoupon(GoodsTypeEnum gtype, long gid, long couponId, long batchId) {
        int ret = this.goodsCouponDao.deleteUnusedCoupon(gtype.getGtype(), gid, couponId);
        if (ret > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean findBatchExsitUsedCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        Long ret = this.goodsCouponDao.selectByBatchExistUsed(gtype.getGtype(), gid, goodsBatchId);
        if (ret != null) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean deleteBatchUnusedCoupons(GoodsTypeEnum gtype, long gid, long batchId, List<Long> couponIds) {
        if (couponIds == null || couponIds.isEmpty() || couponIds.size() > 5000) {
            throw new RuntimeGoodsException(ErrorCode.E9999999);
        }
        try {
            if (!this.lock.tryLock()) {
                throw new RuntimeGoodsException(ErrorCode.E9999999);
            }
            GoodsBatchEntity e = this.goodsBatchDao.select(batchId);
            int ret = this.goodsCouponDao.deleteBatchUnusedCouponsByIds(gtype.getGtype(), gid, batchId, couponIds);
            if (ret > 0) {
                this.remoteStockBackendService.decreaseItemStock(e.getStockId().longValue(), (long)ret);
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    @Override
    public List<GoodsCouponEntity> findUnusedCoupons(GoodsTypeEnum gtype, long gid, long batchId, int limit) {
        if (limit > 5000) {
            throw new RuntimeGoodsException(ErrorCode.E9999999);
        }
        return this.goodsCouponDao.findUnusedCoupons(gtype.getGtype(), gid, batchId, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsCouponEntity takeNormalCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, Long consumerId, Long appId, String bizNum) {
        try {
            DBTimeProfile.enter((String)"takeNormalCoupon");
            boolean consumeSucc = this.consumeStocks(gtype, batch, bizNum, appId);
            if (!consumeSucc) {
                GoodsCouponEntity goodsCouponEntity = null;
                return goodsCouponEntity;
            }
            GoodsCouponEntity entity = this.goodsCouponDao.selectOneCouponNotUsed(gtype, batch.getGid(), batch.getId());
            boolean success = this.takeCoupon4Point(gtype, batch.getGid(), batch.getId(), entity.getGoodsCouponId(), consumerId, bizNum);
            if (success) {
                GoodsCouponEntity goodsCouponEntity = entity;
                return goodsCouponEntity;
            }
            GoodsCouponEntity goodsCouponEntity = null;
            return goodsCouponEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsCouponEntity takeLinkCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, Long consumerId, Long appId, String bizNum) {
        try {
            DBTimeProfile.enter((String)"takeLinkCoupon");
            boolean consumeSucc = this.consumeStocks(gtype, batch, bizNum, appId);
            if (!consumeSucc) {
                GoodsCouponEntity goodsCouponEntity = null;
                return goodsCouponEntity;
            }
            GoodsCouponEntity e = this.getLinkOrRepeatCouponCache(batch.getId());
            if (e != null) {
                GoodsCouponEntity goodsCouponEntity = e;
                return goodsCouponEntity;
            }
            e = this.goodsCouponDao.selectOneByGoodsBatchId(gtype, batch.getGid(), batch.getId());
            if (e != null) {
                this.setLinkOrRepeatCouponCache(batch.getId(), e);
            }
            GoodsCouponEntity goodsCouponEntity = e;
            return goodsCouponEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsCouponEntity takeRepeatCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, Long consumerId, Long appId, String bizNum) {
        try {
            DBTimeProfile.enter((String)"takeRepeatCoupon");
            boolean consumeSucc = this.consumeStocks(gtype, batch, bizNum, appId);
            if (!consumeSucc) {
                GoodsCouponEntity goodsCouponEntity = null;
                return goodsCouponEntity;
            }
            GoodsCouponEntity e = this.getLinkOrRepeatCouponCache(batch.getId());
            if (e != null) {
                GoodsCouponEntity goodsCouponEntity = e;
                return goodsCouponEntity;
            }
            e = this.goodsCouponDao.selectOneByGoodsBatchId(gtype, batch.getGid(), batch.getId());
            if (e != null) {
                this.setLinkOrRepeatCouponCache(batch.getId(), e);
            }
            GoodsCouponEntity goodsCouponEntity = e;
            return goodsCouponEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    protected boolean consumeStocks(GoodsTypeEnum gtype, GoodsBatchEntity batch, String bizNum, Long appId) {
        List<Long> stockIds = this.stockService.getNeedCountDownOtherStockIds(gtype.getGtype(), batch.getGid(), appId);
        stockIds.add(batch.getStockId());
        try {
            DBTimeProfile.enter((String)"remoteStockService.consumeStock");
            DubboResult stockRet = this.remoteStockService.consumeStock(ConsumeStockTypeUtil.getConsumeStockTypes(gtype).getType(), bizNum, stockIds);
            if (stockRet.isSuccess() && ((Boolean)stockRet.getResult()).booleanValue()) {
                boolean bl = true;
                return bl;
            }
            if (STErrorCode.SS_0400001.getCode().equals(stockRet.getReturnCode())) {
                this.goodsBatchService.markBatchStatusUsed(gtype, batch.getGid(), batch.getId());
                throw new RuntimeGoodsException(ErrorCode.E0202005);
            }
            throw new RuntimeGoodsException(ErrorCode.E0404011, (Throwable)new GoodsException(stockRet.getReturnCode(), stockRet.getMsg()));
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackStocks(GoodsTypeEnum gtype, String bizNum) {
        try {
            DBTimeProfile.enter((String)"remoteStockService.rollbackStock");
            log.warn("rollbackStocks gtype=" + gtype + ",bizNum=" + bizNum);
            DubboResult stockRet = this.remoteStockService.rollbackStock(ConsumeStockTypeUtil.getConsumeStockTypes(gtype).getType(), bizNum);
            if (!stockRet.isSuccess()) {
                log.error("rollbackStocks error: gtype=" + gtype + ",bizNum=" + bizNum);
            }
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private GoodsCouponEntity getLinkOrRepeatCouponCache(long batchId) {
        String key = (Object)((Object)RedisKeyFactory.K205) + String.valueOf(batchId);
        String string = this.redisCacheService.get(key);
        if (string != null) {
            return (GoodsCouponEntity)JSONObject.parseObject((String)string, GoodsCouponEntity.class);
        }
        return null;
    }

    private void setLinkOrRepeatCouponCache(Long batchId, GoodsCouponEntity entity) {
        String key = (Object)((Object)RedisKeyFactory.K205) + String.valueOf(batchId);
        String string = JSONObject.toJSONString((Object)entity);
        this.redisCacheService.set(key, string, 3600);
    }

    protected void clearLinkOrRepeat(long batchId) {
        String key = (Object)((Object)RedisKeyFactory.K205) + String.valueOf(batchId);
        this.redisCacheService.delete(key);
    }
}

