/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.biz.cache.IPCache;
import cn.com.duiba.goods.center.biz.dao.AddrLimitDao;
import cn.com.duiba.goods.center.biz.dao.item.IpLibraryDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.entity.IpLibraryEntity;
import cn.com.duiba.goods.center.biz.service.RedisCacheService;
import cn.com.duiba.goods.center.biz.service.item.AddrLimitService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.util.RedisKeyFactory;
import cn.com.duiba.service.domain.vo.AddrLimitJsonVO;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AddrLimitServiceImpl
implements AddrLimitService {
    @Resource
    private AddrLimitDao addrLimitDao;
    @Autowired
    private IpLibraryDao ipLibraryDao;
    @Autowired
    private RedisCacheService redisCacheService;
    @Autowired
    private AppItemService appItemService;

    @Override
    public List<AddrLimitDto> findAddrLimitByAppItemId(Long appItemId) {
        return this.addrLimitDao.findAddrLimitByAppItemId(appItemId);
    }

    @Override
    public List<AddrLimitDto> findAddrLimitByItemId(Long itemId) {
        return this.addrLimitDao.findAddrLimitByItemId(itemId);
    }

    @Override
    public Integer findTypeByAppItemId(Long appItemId) {
        return this.addrLimitDao.findTypeByAppItemId(appItemId);
    }

    @Override
    public Integer findTypeByItemId(Long itemId) {
        return this.addrLimitDao.findTypeByItemId(itemId);
    }

    @Override
    public Integer batchInsertAddrLimit(List<AddrLimitDto> addrLimitList) {
        return this.addrLimitDao.batchInsertAddrLimit(addrLimitList);
    }

    @Override
    public Integer deleteAddrLimit(Long itemId, Long appItemId) {
        return this.addrLimitDao.deleteAddrLimit(itemId, appItemId);
    }

    @Override
    public List<AddrLimitDto> findAddrLimitByAppItemIds(List<Long> appItemIds) {
        return this.addrLimitDao.findAddrLimitByAppItemIds(appItemIds);
    }

    @Override
    public List<AddrLimitDto> findAddrLimitByItemIds(List<Long> itemIds) {
        return this.addrLimitDao.findAddrLimitByItemIds(itemIds);
    }

    @Override
    public IPCache findCodeByIpLong(Long ipLong) {
        String key = (Object)((Object)RedisKeyFactory.K203) + String.valueOf(ipLong);
        String value = this.redisCacheService.get(key);
        if (value == null) {
            IpLibraryEntity entity = this.ipLibraryDao.findCodeByIpLong(ipLong);
            if (entity == null) {
                this.redisCacheService.set(key, "NULL", 60);
                return null;
            }
            IPCache cache = new IPCache();
            cache.setCode(entity.getCode());
            cache.setEndIpNum(entity.getEndIpNum());
            this.redisCacheService.set(key, JSONObject.toJSONString((Object)cache), 60);
            return cache;
        }
        if ("NULL".equals(value)) {
            return null;
        }
        return (IPCache)JSONObject.parseObject((String)value, IPCache.class);
    }

    @Override
    public void devAppItemAddAddrLimit(AppItemEntity appItem, String limitType, String limitAreas) {
        if (StringUtils.isBlank((String)limitAreas)) {
            return;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)limitAreas);
        appItem.setOperationsType(appItem.getOperationsType());
        if (jsonArray.isEmpty()) {
            appItem.ungrantOpTypeAppItem(9);
        } else {
            appItem.grantOpTypeAppItem(9);
        }
        this.appItemService.updateOperationsTypeById(appItem.getId(), appItem.getOperationsType());
        ArrayList<AddrLimitDto> addrLimitJsonList = new ArrayList<AddrLimitDto>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            AddrLimitJsonVO jsonVO = (AddrLimitJsonVO)JSONObject.toJavaObject((JSON)jsonObject, AddrLimitJsonVO.class);
            AddrLimitDto addrLimitDO = new AddrLimitDto();
            addrLimitDO.setAppItemId(appItem.getId());
            addrLimitDO.setProvince(jsonVO.getProvinceName());
            addrLimitDO.setCity(jsonVO.getCityName());
            addrLimitDO.setProCode(jsonVO.getProvinceCode());
            addrLimitDO.setCityCode(jsonVO.getCityCode());
            addrLimitDO.setGmtCreate(new Date());
            addrLimitDO.setGmtModified(new Date());
            if (limitType.equals("whitelist")) {
                addrLimitDO.setType(AddrLimitDto.TYPE_WHITE_LIST);
            } else {
                addrLimitDO.setType(AddrLimitDto.TYPE_BLACK_LIST);
            }
            addrLimitJsonList.add(addrLimitDO);
        }
        if (!addrLimitJsonList.isEmpty()) {
            List<AddrLimitDto> addrLimits = this.findAddrLimitByAppItemId(appItem.getId());
            if (null != addrLimits && !addrLimits.isEmpty()) {
                this.deleteAddrLimit(null, appItem.getId());
            }
            this.batchInsertAddrLimit(addrLimitJsonList);
        }
    }
}

