/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.biz.dao.item.AppBannerDao;
import cn.com.duiba.goods.center.biz.service.item.AppBannerService;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AppBannerServiceImpl
implements AppBannerService {
    @Resource(name="stringRedisTemplate03")
    private StringRedisTemplate stringRedisTemplate;
    @Resource(name="stringRedisTemplate03")
    private AdvancedCacheClient advancedCacheClient;
    @Autowired
    private AppBannerDao appBannerDao;

    @Override
    public Integer disableByAppIdAndAppItemId(Long appId, Long appItemId) {
        List<Long> ids = this.appBannerDao.findIdsByAppIdAndAppItemId(appId, appItemId);
        int ret = this.appBannerDao.disableByAppIdAndAppItemId(appId, appItemId);
        ArrayList<String> keys = new ArrayList<String>();
        for (Long id : ids) {
            keys.add(this.getCacheKeyById(id));
        }
        this.stringRedisTemplate.delete(keys);
        return ret;
    }

    @Override
    public void removeCacheByAppId(Long appId) {
        this.advancedCacheClient.remove(this.getCacheKeyByAppId(appId));
        String cacheKey = "item.MS_HOME_ITEM_-" + appId;
        this.advancedCacheClient.set(cacheKey, (Object)System.currentTimeMillis(), 3600, TimeUnit.SECONDS);
    }

    private String getCacheKeyByAppId(Long appId) {
        return "chaos.keyAppBanners_" + appId;
    }

    private String getCacheKeyById(Long id) {
        return "chaos.keyAppBannerById_" + id;
    }
}

