/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.constant.DevCustomizedConstants;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemAppSpecifyDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyStockDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.bo.item.ItemKeyBo;
import cn.com.duiba.goods.center.biz.cache.EventHomeCache;
import cn.com.duiba.goods.center.biz.dao.item.AppItemDao;
import cn.com.duiba.goods.center.biz.dao.item.DeveloperBlacklistDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.entity.AppItemExtraEntity;
import cn.com.duiba.goods.center.biz.entity.DeveloperBlacklistEntity;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.AppItemClassifyService;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.item.AddrLimitService;
import cn.com.duiba.goods.center.biz.service.item.AppBannerService;
import cn.com.duiba.goods.center.biz.service.item.AppItemExtraService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemKeyService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemStockManualChangeService;
import cn.com.duiba.goods.center.biz.service.stock.ItemAppSpecifyService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="appItemService")
public class AppItemServiceImpl
implements AppItemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppItemServiceImpl.class);
    @Value(value="${goods.test.couponId}")
    private Long testCouponId;
    @Autowired
    private AppItemDao appItemDao;
    @Autowired
    private ItemService itemService;
    @Autowired
    private ItemKeyService itemKeyService;
    @Autowired
    private GoodsCouponBO goodsCouponBO;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Resource
    private EventHomeCache eventHomeCache;
    @Resource(name="stringRedisTemplate03")
    private AdvancedCacheClient advancedCacheClient;
    @Autowired
    private ItemKeyBo itemKeyBo;
    @Autowired
    private AppItemExtraService appItemExtraService;
    @Autowired
    private AddrLimitService addrLimitService;
    @Autowired
    private AppBannerService appBannerService;
    @Autowired
    private AppItemClassifyService appItemClassifyService;
    @Autowired
    private ItemStockManualChangeService itemStockManualChangeService;
    @Autowired
    private ItemAppSpecifyService itemAppSpecifyService;
    @Autowired
    private DeveloperBlacklistDao developerBlacklistDao;

    private String getKeyById(Long id) {
        return "item.appItemId_" + id;
    }

    private void cacheClear(String key) {
        try {
            this.advancedCacheClient.remove(key);
        }
        catch (Exception e) {
            LOGGER.error("cacheClear:", (Throwable)e);
        }
    }

    private void asyncClearCache(Long id) {
        this.eventHomeCache.clearAppItemCache(this.getKeyById(id));
    }

    @Override
    public AppItemEntity find(Long id) {
        Long stock;
        AppItemEntity entity = this.appItemDao.find(id);
        if (entity == null) {
            return null;
        }
        if (entity.isOpTypeAppItem(16) && (stock = this.goodsBatchService.getSumBatchStockBatch(GoodsTypeEnum.APP, entity.getId())) != null) {
            entity.setRemaining(Integer.valueOf(stock.toString()));
        }
        return entity;
    }

    @Override
    public List<AppItemEntity> findByIds(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        List<AppItemEntity> entitys = this.appItemDao.findByIds(ids);
        ArrayList<GoodsStockDto> stocks = new ArrayList<GoodsStockDto>();
        for (AppItemEntity entity : entitys) {
            if (!entity.isOpTypeAppItem(16)) continue;
            GoodsStockDto stock = new GoodsStockDto();
            stock.setGid(entity.getId());
            stock.setGtype(GoodsTypeEnum.APP);
            stocks.add(stock);
        }
        if (!stocks.isEmpty()) {
            List<GoodsStockDto> gst = this.goodsCouponBO.findGoodsStockByBatch(stocks);
            HashMap<Long, Integer> map = new HashMap<Long, Integer>();
            for (GoodsStockDto dto : gst) {
                map.put(dto.getGid(), Integer.valueOf(dto.getStock().toString()));
            }
            for (AppItemEntity entity : entitys) {
                if (!entity.isOpTypeAppItem(16)) continue;
                Integer stock = (Integer)map.get(entity.getId());
                entity.setRemaining(stock);
            }
        }
        return entitys;
    }

    @Override
    public Long insert(AppItemEntity appItemEntity) {
        this.appItemDao.insert(appItemEntity);
        this.eventHomeCache.invalidApp(appItemEntity.getAppId());
        return appItemEntity.getId();
    }

    @Override
    public Boolean update(AppItemEntity appItemEntity) {
        int ret = this.appItemDao.update(appItemEntity);
        if (ret > 0) {
            this.eventHomeCache.invalidApp(appItemEntity.getAppId());
            this.cacheClear(this.getKeyById(appItemEntity.getId()));
            return true;
        }
        return false;
    }

    @Override
    public Boolean delete(Long appId, Long appItemId) {
        int ret = this.appItemDao.deleteOrRecoverAppItem(appId, appItemId, true, "off");
        if (ret > 0) {
            this.appItemExtraService.deleteByAppItemId(appItemId);
            this.appBannerService.disableByAppIdAndAppItemId(appId, appItemId);
            this.appItemClassifyService.deleteRelationAppItem(appItemId);
            return true;
        }
        return false;
    }

    @Override
    public Integer deleteByIds(Long appId, List<Long> appItemIds) {
        int ret = this.appItemDao.deleteByIds(appId, appItemIds);
        this.eventHomeCache.invalidAppItem(appItemIds);
        for (Long id : appItemIds) {
            this.asyncClearCache(id);
        }
        return ret;
    }

    @Override
    @Transactional(value="credits")
    public Boolean updateStatus(Long appId, Long appItemId, String status) {
        AppItemEntity appItem = this.find(appItemId);
        appItem.setStatus(status);
        if (status.equals("off")) {
            this.appBannerService.disableByAppIdAndAppItemId(appId, appItemId);
            if (appItem.getType().equals("turntable") || appItem.getType().equals("fake")) {
                appItem.setDeleted(true);
            }
            appItem.setPayload(0);
        } else if (status.equals("on")) {
            int maxPayload = this.appItemDao.findAppMaxPayload(appId);
            appItem.setPayload(maxPayload + 1);
            appItem.setHomeDisplay(true);
            if (appItem.getItemId() != null && ("coupon".equals(appItem.getType()) || "object".equals(appItem.getType()))) {
                ItemEntity item = this.itemService.find(appItem.getItemId());
                if (item.getAutoOffDate() != null && item.getAutoOffDate().before(new Date())) {
                    throw new RuntimeGoodsException(ErrorCode.E0404020);
                }
                if (appItem.getAutoOffDate() != null && appItem.getAutoOffDate().before(new Date())) {
                    throw new RuntimeGoodsException(ErrorCode.E0404020);
                }
            } else if (appItem.getAutoOffDate() != null && appItem.getAutoOffDate().before(new Date())) {
                throw new RuntimeGoodsException(ErrorCode.E0404020);
            }
        } else {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        int ret = this.standUpOrDownAppItem(appItemId, status, appItem.getDeleted(), appItem.getPayload(), appItem.getHomeDisplay());
        if (ret > 0) {
            this.eventHomeCache.invalidAppItem(appItemId);
            this.cacheClear(this.getKeyById(appItemId));
            return true;
        }
        return false;
    }

    @Override
    public Integer updateStatusByIds(Long appId, List<Long> appItemIds, String status) {
        int ret = this.appItemDao.updateStatusByIds(appId, appItemIds, status);
        this.eventHomeCache.invalidAppItem(appItemIds);
        for (Long id : appItemIds) {
            this.asyncClearCache(id);
        }
        return ret;
    }

    @Override
    public Boolean decrStock(Long appId, Long appItemId) {
        int ret = this.appItemDao.decrStock(appItemId);
        if (ret > 0) {
            return true;
        }
        return false;
    }

    @Override
    public void removeCache(Long appItemId) {
        try {
            this.eventHomeCache.invalidAppItemRemaining(appItemId);
            this.cacheClear(this.getKeyById(appItemId));
        }
        catch (Exception e) {
            LOGGER.error("removeCache:appItemId=" + appItemId, (Throwable)e);
        }
    }

    @Override
    public Boolean incrStock(Long appItemId) {
        int ret = this.appItemDao.incrStock(appItemId);
        if (ret > 0) {
            this.eventHomeCache.invalidAppItemRemaining(appItemId);
            this.cacheClear(this.getKeyById(appItemId));
            return true;
        }
        return false;
    }

    @Override
    public Boolean appendStock(Long appId, Long appItemId, Long number) {
        int ret = this.appItemDao.appendStock(appItemId, number);
        if (ret > 0) {
            this.eventHomeCache.invalidAppItemRemaining(appItemId);
            this.cacheClear(this.getKeyById(appItemId));
            return true;
        }
        return false;
    }

    @Override
    public Boolean deductStock(Long appId, Long appItemId, Long number) {
        int ret = this.appItemDao.deductStock(appItemId, number);
        if (ret > 0) {
            return true;
        }
        return false;
    }

    @Override
    public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId) {
        return this.appItemDao.findByAppIdAndItemId(appId, itemId);
    }

    @Override
    public Integer findCountByItemId(Long itemId) {
        return this.appItemDao.findCountByItemId(itemId);
    }

    @Override
    public List<AppItemEntity> findByAppIdAndItemIds(Long appId, List<Long> itemIds) {
        return this.appItemDao.findByAppIdAndItemIds(appId, itemIds);
    }

    @Override
    public int updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate) {
        int ret = this.appItemDao.updateRemainingAndvalidEndDate(appItemId, totalStock, validEndDate);
        this.eventHomeCache.invalidAppItem(appItemId);
        this.cacheClear(this.getKeyById(appItemId));
        return ret;
    }

    @Override
    public int updateExpiedAppItem(Long itemId) {
        int ret = this.appItemDao.updateExpiedAppItem(itemId);
        List<Long> ids = this.appItemDao.findIdByItemId(itemId);
        for (Long id : ids) {
            this.asyncClearCache(id);
        }
        return ret;
    }

    @Override
    public int updateExpiedAppItemById(Long appItemId) {
        int ret = this.appItemDao.updateExpiedAppItemById(appItemId);
        this.eventHomeCache.invalidAppItem(appItemId);
        this.cacheClear(this.getKeyById(appItemId));
        return ret;
    }

    @Override
    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type) {
        return this.appItemDao.findAppIdsByInActivityId(activityId, type);
    }

    @Override
    public List<Long> findAppIdsByActivityId(Long relationId) {
        return this.appItemDao.findAppIdsByActivityId(relationId);
    }

    @Override
    public List<Long> findAppIdByItemIds(List<Long> itemIds) {
        return this.appItemDao.findAppIdByItemIds(itemIds);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        return this.appItemDao.findAppIdsByIds(ids);
    }

    @Override
    public List<Long> findIDBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId) {
        return this.appItemDao.findIDBySourceIdsAndSourceTypes(sourceIds, sourceTypes, appId);
    }

    @Override
    public List<AppItemEntity> findBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId) {
        return this.appItemDao.findBySourceIdsAndSourceTypes(sourceIds, sourceTypes, appId);
    }

    @Override
    public List<Long> findTopAppItemIdsDescByPayload(Long appId) {
        return this.appItemDao.findTopAppItemIdsDescByPayload(appId);
    }

    @Override
    public int updateAppItemPayload(Long appId, Long appItemId, Integer payload) {
        return this.appItemDao.updateAppItemPayload(appId, appItemId, payload);
    }

    @Override
    public int updateOfflineAppItem4Disable(Long appId) {
        List<Long> ids = this.appItemDao.findOfflineAppItemIds4Disable(appId);
        int ret = this.appItemDao.updateOfflineAppItem4Disable(appId);
        this.eventHomeCache.invalidApp(appId);
        for (Long id : ids) {
            this.asyncClearCache(id);
        }
        return ret;
    }

    @Override
    public int updateStatusByActivityIds(String status, Boolean delete, List<Long> oids) {
        int ret = this.appItemDao.updateStatusByActivityIds(status, delete, oids);
        List<Long> appItemIds = this.appItemDao.findIdsByActivityIds(oids);
        this.eventHomeCache.invalidAppItem(appItemIds);
        for (Long id : appItemIds) {
            this.asyncClearCache(id);
        }
        return ret;
    }

    @Override
    public Integer updateStatusByActivityId(String status, Boolean delete, Long activityId, Integer type) {
        int ret = this.appItemDao.updateStatusByActivityId(status, delete, activityId, type);
        this.eventHomeCache.invalidRelationActivity(activityId, type);
        List<Long> ids = this.appItemDao.findIdsByInActivityId(activityId, type);
        for (Long id : ids) {
            this.asyncClearCache(id);
        }
        return ret;
    }

    @Override
    public int findAppMaxPayload(Long appId) {
        return this.appItemDao.findAppMaxPayload(appId);
    }

    @Override
    public List<AppItemDto> findOnShelfByItemId(Long itemId) {
        return this.appItemDao.findOnShelfByItemId(itemId);
    }

    @Override
    public Integer standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay) {
        int ret = this.appItemDao.standUpOrDownAppItem(id, status, deleted, payload, homeDisplay);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClear(this.getKeyById(id));
        return ret;
    }

    @Override
    public Integer updateHdtoolAppItem(Long id, String title, String smallImage, String whiteImage, Long credits, String customPrice, String logo, Integer operationsType) {
        int ret = this.appItemDao.updateHdtoolAppItem(id, title, smallImage, whiteImage, credits, customPrice, logo, operationsType);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClear(this.getKeyById(id));
        return ret;
    }

    @Override
    public int updateMainPushAppItem(Long id, String title, String logo, String smallImage, String whiteImage, String bannerImage, Long credits, String subtitle) {
        int ret = this.appItemDao.updateMainPushAppItem(id, title, logo, smallImage, whiteImage, bannerImage, credits, subtitle);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClear(this.getKeyById(id));
        return ret;
    }

    @Override
    public List<AppItemDto> findAllBySourceTypeAndRelationIdAndDeleted(Integer sourceType, Long sourceRelationId, Boolean deleted) {
        return this.appItemDao.findAllBySourceTypeAndRelationIdAndDeleted(sourceType, sourceRelationId, deleted);
    }

    @Override
    public Page<AppItemDto> findPublishItemLimit(Map<String, Object> queryPublish) {
        Page page = new Page(0, 0);
        page.setList(this.appItemDao.findPublishItemLimit(queryPublish));
        page.setTotalCount(this.appItemDao.countPublishItemRow(queryPublish).intValue());
        return page;
    }

    @Override
    public Page<AppItemDto> findByLimit(Map<String, Object> params) {
        Page page = new Page(0, 0);
        page.setList(this.appItemDao.findByLimit(params));
        page.setTotalCount(this.appItemDao.findByLimitCount(params).intValue());
        return page;
    }

    @Override
    public int updateSubTypeById(Long appItemId, Integer subType) {
        return this.appItemDao.updateSubTypeById(appItemId, subType);
    }

    @Override
    public int updateValidEndDateById(Long appItemId, Date validEndDate) {
        return this.appItemDao.updateValidEndDateById(appItemId, validEndDate);
    }

    @Override
    public List<Long> findSelfAppItemIdsByAppId(Long appId, List<String> types, Integer warnLine) {
        return this.appItemDao.findSelfAppItemIdsByAppId(appId, types, warnLine);
    }

    @Override
    public List<AppItemDto> findAllByAppIdAndInType(Long appId, String[] types) {
        return this.appItemDao.findAllByAppIdAndInType(appId, types);
    }

    @Override
    public Integer getRemaining0Count(Long appId) {
        List<AppItemDto> ais = this.appItemDao.findAllByAppIdAndTypeIn(appId);
        List<ItemKeyDto> itemKeys = this.itemKeyBo.getBatchItemKeyByAppItem(ais, appId);
        Iterator<ItemKeyDto> it = itemKeys.iterator();
        while (it.hasNext()) {
            ItemKeyDto key = it.next();
            if (!this.itemService.isRechargeGoods(key.getItemDtoType()).booleanValue()) continue;
            it.remove();
        }
        List<ItemKeyStockDto> stocks = this.itemKeyService.batchFindStock(itemKeys, appId);
        int num = 0;
        for (ItemKeyStockDto stock : stocks) {
            if (stock.getStock() == null || stock.getStock() >= 1L) continue;
            ++num;
        }
        return num;
    }

    @Override
    public Integer findOnlineCount(Long appId) {
        return this.appItemDao.findOnlineCount(appId);
    }

    @Override
    public Long getOrAddAppItemId(String type, Long appId, Long appCreditsRate) {
        if (!this.itemService.isRechargeGoods(type).booleanValue()) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        ItemEntity item = this.itemService.findByType(type);
        AppItemEntity appItem = this.addItemToAppItem(item, appId, Boolean.TRUE, appCreditsRate);
        return appItem.getId();
    }

    private AppItemEntity addItemToAppItem(ItemEntity item, Long appId, Boolean deleted, Long appCreditsRate) {
        Date now = new Date();
        AppItemEntity entity = this.appItemDao.findByAppIdAndItemId(appId, item.getId());
        if (entity == null) {
            AppItemDto ai = new AppItemDto(true);
            ai.setAppId(appId);
            ai.setItemId(item.getId());
            ai.setDeleted(deleted);
            ai.setStatus("off");
            ai.setAddTime(now);
            ai.setTitle(item.getName());
            ai.setSubtitle(item.getSubtitle());
            ai.setCustomPrice(item.getCustomPrice());
            int minCredits = (int)((double)((long)item.getFacePrice().intValue() * appCreditsRate) / 100.0);
            if (minCredits < 1) {
                minCredits = 1;
            }
            ai.setMinFacePrice(Integer.valueOf(minCredits));
            ai.setIsOwner(Boolean.valueOf(false));
            ai.setExchangeTipTemplate(item.getExchangeTipTemplate());
            ai.setType(item.getType());
            if (item.getValidEndDate() != null && item.getValidEndDate().getTime() <= now.getTime()) {
                ai.setSubStatus("expired");
            }
            ai.setCredits(null);
            ai.setPayload(Integer.valueOf(0));
            AppItemEntity inst = (AppItemEntity)BeanUtils.copy((Object)ai, AppItemEntity.class);
            this.appItemDao.insert(inst);
            entity = inst;
        }
        return entity;
    }

    @Override
    public List<AppItemDto> findAllUpVirtaulAppItems(Long appId) {
        return this.appItemDao.findAllUpVirtaulAppItems(appId);
    }

    @Override
    @Transactional(value="credits")
    public boolean doUpdateCoupon(AppItemEntity appItem, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas, String usePrompt, String btnText) {
        if (appItem.getId() == null) {
            this.insert(appItem);
        } else {
            if (appItem.getLimitCount() == null || appItem.getLimitTimeBetween() == null || appItem.getLimitEverydayQuantity() == null) {
                this.appItemDao.setLimitNull(appItem.getId(), appItem.getLimitCount(), appItem.getLimitTimeBetween(), appItem.getLimitEverydayQuantity());
            }
            this.update(appItem);
        }
        if (StringUtils.isNotBlank((String)exchangeLimit) && exchangeLimit.equals("on") && StringUtils.isNotBlank((String)arealimitSwitch) && arealimitSwitch.equals("on")) {
            this.addrLimitService.devAppItemAddAddrLimit(appItem, arealimitType, arealimitAreas);
        }
        AppItemExtraEntity appItemExtraDO = new AppItemExtraEntity();
        appItemExtraDO.setAppItemId(appItem.getId());
        appItemExtraDO.setUsePrompt(usePrompt);
        if (StringUtils.isNotBlank((String)btnText)) {
            appItemExtraDO.setBtnText(btnText);
        } else {
            appItemExtraDO.setBtnText("\u9a6c\u4e0a\u4f7f\u7528");
        }
        this.appItemExtraService.insertOrUpdateByAppItemId(appItemExtraDO);
        return true;
    }

    @Override
    public void updateOperationsTypeById(Long id, Integer operationsType) {
        this.appItemDao.updateOperationsTypeById(id, operationsType);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClear(this.getKeyById(id));
    }

    @Override
    @Transactional(value="credits")
    public boolean doBatchDel(Long appId, List<Long> appItemIds) {
        if (appItemIds.isEmpty()) {
            return false;
        }
        for (Long appItemId : appItemIds) {
            this.appItemDao.deleteOrRecoverAppItem(appId, appItemId, true, "off");
            this.appItemExtraService.deleteByAppItemId(appItemId);
            this.appBannerService.disableByAppIdAndAppItemId(appId, appItemId);
            this.appItemClassifyService.deleteRelationAppItem(appItemId);
        }
        this.appBannerService.removeCacheByAppId(appId);
        return true;
    }

    @Override
    public int bathcStandUp(Long appId, String virtualExchangeUrl, List<Long> appItemIds) {
        if (appItemIds.isEmpty()) {
            return 0;
        }
        List<AppItemEntity> ais = this.findByIds(appItemIds);
        for (int i = ais.size() - 1; i >= 0; --i) {
            AppItemEntity appItem = ais.get(i);
            if (!appItem.getAppId().equals(appId)) {
                ais.remove(i);
                continue;
            }
            if (!appItem.getType().equals("virtual") || !StringUtils.isBlank((String)virtualExchangeUrl)) continue;
            ais.remove(i);
        }
        int temp = 0;
        for (AppItemEntity ai : ais) {
            if (!ai.getStatus().equals("off")) continue;
            int maxPayload = this.findAppMaxPayload(appId);
            this.standUpOrDownAppItem(ai.getId(), "on", false, maxPayload + 1, ai.getHomeDisplay());
            ++temp;
        }
        return temp;
    }

    @Override
    public Long addTestCoupon(Long appId) {
        ItemEntity item = this.itemService.find(this.testCouponId);
        Date today = new Date();
        AppItemDto appItem = new AppItemDto(true);
        appItem.setAppId(appId);
        appItem.setItemId(item.getId());
        appItem.setStatus("on");
        appItem.setAddTime(today);
        appItem.setTitle(item.getName());
        appItem.setSubtitle(item.getSubtitle());
        appItem.setCustomPrice(item.getCustomPrice());
        appItem.setCredits(null);
        appItem.setPayload(Integer.valueOf(this.findAppMaxPayload(appId) + 1));
        appItem.setMinFacePrice(item.getMinFacePrice());
        appItem.setLogo(item.getLogo());
        appItem.setImage(item.getImage());
        appItem.setSmallImage(item.getSmallImage());
        appItem.setMultiImage(item.getMultiImage());
        appItem.setDeleted(Boolean.valueOf(false));
        appItem.setType(item.getType());
        appItem.setOperationsType(Integer.valueOf(0));
        appItem.setExchangeTipTemplate(item.getExchangeTipTemplate());
        appItem.setIsOwner(Boolean.valueOf(false));
        if (item.getValidEndDate() != null) {
            if (item.getValidEndDate().getTime() > today.getTime()) {
                appItem.setSubStatus(null);
            } else {
                appItem.setSubStatus("expired");
            }
        }
        return this.insert((AppItemEntity)BeanUtils.copy((Object)appItem, AppItemEntity.class));
    }

    @Override
    public Boolean doUpdateOwnerObject(AppItemDto appItem, Integer preRemaining, Integer remaining, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas) {
        AppItemEntity appItemEntity = (AppItemEntity)BeanUtils.copy((Object)appItem, AppItemEntity.class);
        if (appItem.getId() == null) {
            this.insert(appItemEntity);
        } else {
            this.itemStockManualChangeService.updateRemainingByEdit(appItem.getId(), preRemaining, remaining);
            if (appItem.getLimitCount() == null || appItem.getLimitTimeBetween() == null || appItem.getLimitEverydayQuantity() == null) {
                this.appItemDao.setLimitNull(appItem.getId(), appItem.getLimitCount(), appItem.getLimitTimeBetween(), appItem.getLimitEverydayQuantity());
            }
            this.update(appItemEntity);
        }
        if (StringUtils.isNotBlank((String)exchangeLimit) && exchangeLimit.equals("on") && StringUtils.isNotBlank((String)arealimitSwitch) && arealimitSwitch.equals("on")) {
            this.addrLimitService.devAppItemAddAddrLimit(appItemEntity, arealimitType, arealimitAreas);
        }
        return true;
    }

    @Override
    public AppItemDto selectItemStore(Long appId, Long itemId) {
        return this.appItemDao.selectItemStore(appId, itemId);
    }

    @Override
    @Transactional(value="credits")
    public AppItemEntity addItem2Myrepo(Long appId, Long itemId, Long developerId, Long creditsRate) {
        ItemAppSpecifyDto itemAppSpecifyDO;
        DeveloperBlacklistEntity devBlacklist;
        Date now = new Date();
        ItemEntity item = this.itemService.find(itemId);
        if (null == item) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        if (item.getDeleted().booleanValue()) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        if (!item.getEnable().booleanValue()) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        if (item.isOpTypeItem(5) && null != (devBlacklist = this.developerBlacklistDao.findByDeveloperId(developerId))) {
            throw new RuntimeGoodsException(ErrorCode.E0404021);
        }
        if (item.isOpTypeItem(3) && null == (itemAppSpecifyDO = this.itemAppSpecifyService.findByItemIdAndAppId(itemId, appId))) {
            throw new RuntimeGoodsException(ErrorCode.E0404022);
        }
        if (item.isOpTypeItem(2)) {
            throw new RuntimeGoodsException(ErrorCode.E0404023);
        }
        AppItemEntity ai = this.findByAppIdAndItemId(appId, itemId);
        if (ai == null) {
            ai = (AppItemEntity)BeanUtils.copy((Object)new AppItemDto(true), AppItemEntity.class);
            ai.setAppId(appId);
            ai.setItemId(item.getId());
            ai.setStatus("off");
        } else {
            Integer optype = ai.getOperationsType();
            ai = (AppItemEntity)BeanUtils.copy((Object)new AppItemDto(ai.getId()), AppItemEntity.class);
            ai.setFacePrice(0);
            ai.setOperationsType(optype);
            ai.ungrantOpTypeAppItem(12);
        }
        ai.setDeleted(false);
        ai.setStatus("off");
        ai.setAddTime(now);
        ai.setCustomPrice(item.getCustomPrice());
        int minCredits = (int)((double)((long)item.getFacePrice().intValue() * creditsRate) / 100.0);
        if (minCredits < 1) {
            minCredits = 1;
        }
        ai.setMinFacePrice(minCredits);
        ai.setIsOwner(false);
        ai.setExchangeTipTemplate(item.getExchangeTipTemplate());
        ai.setType(item.getType());
        ai.setSellerId(item.getSellerId());
        if (item.getValidEndDate() != null && item.getValidEndDate().getTime() <= now.getTime()) {
            ai.setSubStatus("expired");
        }
        ai.setPayload(0);
        if (ai.getId() == null) {
            this.insert(ai);
        } else {
            this.update(ai);
            this.appItemDao.setImageNull(ai.getId());
        }
        this.appItemDao.setMyRepoMultiNull(ai.getId());
        return ai;
    }

    @Override
    public AppItemEntity doUpdateVirtual(AppItemDto appItem, Integer preRemaining, Integer remaining, boolean isOnSale) {
        AppItemEntity entity = (AppItemEntity)BeanUtils.copy((Object)appItem, AppItemEntity.class);
        if (appItem.getId() == null) {
            this.insert(entity);
        } else {
            this.itemStockManualChangeService.updateRemainingByEdit(appItem.getId(), preRemaining, remaining);
            if (appItem.getLimitCount() == null || appItem.getLimitTimeBetween() == null || appItem.getLimitEverydayQuantity() == null) {
                this.appItemDao.setLimitNull(appItem.getId(), appItem.getLimitCount(), appItem.getLimitTimeBetween(), appItem.getLimitEverydayQuantity());
            }
            this.update(entity);
        }
        if (isOnSale) {
            this.updateStatus(appItem.getAppId(), appItem.getId(), "on");
        }
        return entity;
    }

    @Override
    public List<AppItemDto> findAllByExpressTemplateId(Long expressTemplateId) {
        return this.appItemDao.findAllByExpressTemplateId(expressTemplateId);
    }

    @Override
    public List<AppItemDto> findAllByAppIdAndType(Long appId, String type) {
        return this.appItemDao.findAllByAppIdAndType(appId, type);
    }

    @Override
    public List<AppItemDto> findAllVirtualValid(Long appId) {
        return this.appItemDao.findAllVirtualValid(appId);
    }

    @Override
    public List<AppItemDto> findAppItemLimit(Map<String, Object> param, int start, int pageSize) {
        return this.appItemDao.findAppItemLimit(param, start, pageSize);
    }

    @Override
    public Long findAppItemCount(Map<String, Object> param) {
        return this.appItemDao.findAppItemCount(param);
    }

    @Override
    public void sortByAppItemIdAndRange(Long appId, Long appItemId, Integer startPayload, Integer endPayload) {
        if (Objects.equal((Object)startPayload, (Object)endPayload)) {
            return;
        }
        if (startPayload >= DevCustomizedConstants.ITEM_TOP_START) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        List<AppItemDO> appItemList = this.appItemDao.findListBetweenPayload(appId, startPayload, endPayload);
        if (CollectionUtils.isEmpty(appItemList)) {
            return;
        }
        int payload = 0;
        for (AppItemDO appItem : appItemList) {
            payload = Objects.equal((Object)appItem.getId(), (Object)appItemId) ? endPayload : (startPayload > endPayload ? appItem.getPayload() + 1 : appItem.getPayload() - 1);
            this.appItemDao.updateAppItemPayload(appId, appItem.getId(), payload);
        }
    }

    @Override
    public void setLimitNull(Long appItemId, Integer limitCount, String limitTimeBetween, Integer limitEverydayQuantity) {
        this.appItemDao.setLimitNull(appItemId, limitCount, limitTimeBetween, limitEverydayQuantity);
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        return this.appItemDao.updateAutoOffDateNull(id);
    }

    @Override
    public List<AppItemDto> findAllByAppAndIsOwner(Long appId, Boolean isOwner) {
        return this.appItemDao.findAllByAppAndIsOwner(appId, isOwner);
    }

    @Override
    public List<Long> selectHasUpItems(List<Long> ids, Long appId) {
        return this.appItemDao.selectHasUpItems(ids, appId);
    }

    @Override
    public List<AppItemDto> findAllByItemIdsAndAppId(List<Long> itemIds, Long appId) {
        return this.appItemDao.findAllByItemIdsAndAppId(itemIds, appId);
    }

    @Override
    public AppItemDto findByAppAndItemOnline(Long appId, Long itemId) {
        return this.appItemDao.findByAppAndItemOnline(appId, itemId);
    }
}

