/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponQueryParamDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.enums.GoodsCouponStatusEnum;
import cn.com.duiba.goods.center.api.remoteservice.tool.ItemKeyUtils;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.dao.GoodsBatchDao;
import cn.com.duiba.goods.center.biz.dao.item.CouponBatchDao;
import cn.com.duiba.goods.center.biz.dao.item.CouponDao;
import cn.com.duiba.goods.center.biz.entity.CouponBatchEntity;
import cn.com.duiba.goods.center.biz.entity.CouponEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.CouponFlowService;
import cn.com.duiba.goods.center.biz.service.item.ItemCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.item.ItemKeyService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemCouponGoodsServiceImpl
implements ItemCouponGoodsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemCouponGoodsServiceImpl.class);
    @Autowired
    private GoodsCouponBO goodsCouponBO;
    @Autowired
    private GoodsCouponService goodsCouponService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private GoodsBatchDao goodsBatchDao;
    @Autowired
    private CouponFlowService couponFlowService;
    @Autowired
    private CouponDao couponDao;
    @Autowired
    private CouponBatchDao couponBatchDao;
    @Autowired
    private ItemKeyService itemKeyService;
    @Autowired
    private GoodsBatchCouponBackendBO goodsBatchCouponBackendBO;
    @Autowired
    private ItemService itemService;
    @Autowired
    private AppItemService appItemService;

    @Override
    public GoodsCouponDto takeCoupon(ItemKeyDto itemKeyDto, Long consumerId, String bizNum) {
        Long gid;
        GoodsTypeEnum gtype;
        if (!ItemKeyUtils.isGoodsCoupon((ItemKeyDto)itemKeyDto)) {
            return this.takeOldCoupon(itemKeyDto);
        }
        if (itemKeyDto.isDuibaAppItemMode() || itemKeyDto.isItemMode()) {
            gtype = GoodsTypeEnum.DUIBA;
            gid = itemKeyDto.getItem().getId();
        } else if (itemKeyDto.isSelfAppItemMode()) {
            gtype = GoodsTypeEnum.APP;
            gid = itemKeyDto.getAppItem().getId();
        } else {
            throw new RuntimeGoodsException(ErrorCode.E0203013);
        }
        return this.takeGoodsCoupon(gtype, gid, consumerId, itemKeyDto.getAppId(), bizNum);
    }

    @Override
    public Boolean completeCoupon(ItemKeyDto itemKeyDto, Long couponId, long orderId) {
        if (!ItemKeyUtils.isGoodsCoupon((ItemKeyDto)itemKeyDto)) {
            this.couponFlowService.completeCoupon(couponId, orderId);
        } else {
            this.goodsCouponBO.completeCoupon(couponId, orderId);
        }
        return true;
    }

    @Override
    public Boolean rollbackCoupon(ItemKeyDto itemKeyDto, Long couponId, String bizNum) {
        boolean ret = true;
        if (!ItemKeyUtils.isGoodsCoupon((ItemKeyDto)itemKeyDto)) {
            this.couponFlowService.returnOneCoupon(couponId);
        } else {
            ret = this.goodsCouponBO.rollbackCoupon(couponId, bizNum);
        }
        return ret;
    }

    @Override
    public GoodsCouponDto findCoupon(ItemKeyDto itemKeyDto, Long couponId) {
        if (!ItemKeyUtils.isGoodsCoupon((ItemKeyDto)itemKeyDto)) {
            CouponEntity ce = this.couponDao.find(couponId);
            GoodsCouponDto dto = this.convert(itemKeyDto, ce);
            CouponBatchEntity cbe = this.couponBatchDao.find(ce.getBatchId());
            dto.setStartDay(cbe.getValidStartDate());
            dto.setOverDue(cbe.getValidEndDate());
            return dto;
        }
        GoodsCouponEntity entity = this.goodsCouponBO.findCoupon(couponId);
        GoodsCouponDto dto = (GoodsCouponDto)BeanUtils.copy((Object)entity, GoodsCouponDto.class);
        GoodsBatchEntity batch = this.goodsCouponBO.findBatch(entity.getGoodsBatchId());
        dto.setStartDay(batch.getStartDay());
        dto.setOverDue(batch.getEndDay());
        return dto;
    }

    @Override
    public GoodsBatchDto findCurrentBatch(ItemKeyDto itemKeyDto) {
        if (!ItemKeyUtils.isGoodsCoupon((ItemKeyDto)itemKeyDto)) {
            CouponBatchEntity entity = this.couponBatchDao.find(this.getOldBatchId(itemKeyDto));
            return this.convertBatch(itemKeyDto, entity);
        }
        GoodsBatchEntity entity = this.goodsCouponBO.findUsingBatch(this.getGtype(itemKeyDto), this.getGid(itemKeyDto));
        return (GoodsBatchDto)BeanUtils.copy((Object)entity, GoodsBatchDto.class);
    }

    @Override
    public GoodsBatchDto findCouponBatch(ItemKeyDto itemKeyDto, Long batchId) {
        if (!ItemKeyUtils.isGoodsCoupon((ItemKeyDto)itemKeyDto)) {
            CouponBatchEntity entity = this.couponBatchDao.find(batchId);
            return this.convertBatch(itemKeyDto, entity);
        }
        GoodsBatchEntity entity = this.goodsCouponBO.findBatch(batchId);
        return (GoodsBatchDto)BeanUtils.copy((Object)entity, GoodsBatchDto.class);
    }

    @Override
    public List<GoodsCouponDto> pageSearchByBatchIdAndStatus(GoodsCouponQueryParamDto param) {
        ArrayList resultList = Lists.newArrayList();
        ItemKeyDto itemKeyDto = null;
        if (GoodsTypeEnum.DUIBA.equals((Object)param.getGtype())) {
            itemKeyDto = this.itemKeyService.findItemKey(null, param.getGid(), param.getAppId());
        } else if (GoodsTypeEnum.APP.equals((Object)param.getGtype())) {
            itemKeyDto = this.itemKeyService.findItemKey(param.getGid(), null, param.getAppId());
        }
        int limit = param.getPageSize();
        int start = (param.getPageNum() - 1) * param.getPageSize();
        if (!ItemKeyUtils.isGoodsCoupon((ItemKeyDto)itemKeyDto)) {
            if (GoodsCouponStatusEnum.STATUS_LOCK.equals((Object)param.getStatus())) {
                return Lists.newArrayList();
            }
            Boolean used = param.getStatus() == null ? null : Boolean.valueOf(!GoodsCouponStatusEnum.STATUS_NEW.equals((Object)param.getStatus()));
            CouponBatchEntity cbe = this.couponBatchDao.find(param.getBatchId());
            List<CouponEntity> couponEntityList = this.couponDao.searchCoupon(ItemKeyUtils.getAppItemId((ItemKeyDto)itemKeyDto), ItemKeyUtils.getItemId((ItemKeyDto)itemKeyDto), null, param.getBatchId(), used == null ? null : used.toString(), start, limit);
            for (CouponEntity couponEntity : couponEntityList) {
                GoodsCouponDto dto = this.convert(itemKeyDto, couponEntity);
                dto.setStartDay(cbe.getValidStartDate());
                dto.setOverDue(cbe.getValidEndDate());
                resultList.add(dto);
            }
        } else {
            GoodsBatchEntity batch = this.goodsCouponBO.findBatch(param.getBatchId());
            Integer status = param.getStatus() == null ? null : param.getStatus().getCode();
            List<GoodsCouponEntity> resultEntityList = this.goodsCouponService.findPageByStatus(param.getGtype(), param.getGid(), param.getBatchId(), status, start, limit);
            for (GoodsCouponEntity entity : resultEntityList) {
                GoodsCouponDto dto = (GoodsCouponDto)BeanUtils.copy((Object)entity, GoodsCouponDto.class);
                dto.setStartDay(batch.getStartDay());
                dto.setOverDue(batch.getEndDay());
                resultList.add(dto);
            }
        }
        return resultList;
    }

    private Long getOldBatchId(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            return itemKey.getItem().getBatchId();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getBatchId();
        }
        throw new RuntimeGoodsException(ErrorCode.E0202008);
    }

    private GoodsTypeEnum getGtype(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            return GoodsTypeEnum.DUIBA;
        }
        if (itemKey.isSelfAppItemMode()) {
            return GoodsTypeEnum.APP;
        }
        throw new RuntimeGoodsException(ErrorCode.E0202008);
    }

    private Long getGid(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            return itemKey.getItem().getId();
        }
        if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().getId();
        }
        throw new RuntimeGoodsException(ErrorCode.E0202008);
    }

    private GoodsCouponDto takeOldCoupon(ItemKeyDto itemKeyDto) {
        Long appItemId = itemKeyDto.isSelfAppItemMode() ? itemKeyDto.getAppItem().getId() : null;
        Long itemId = itemKeyDto.getItem() != null ? itemKeyDto.getItem().getId() : null;
        LOGGER.warn("take oldCoupon appId:" + itemKeyDto.getAppId() + " appItemId:" + appItemId + " itemId:" + itemId);
        CouponEntity ce = this.couponFlowService.getOneCoupon(itemKeyDto);
        return this.convert(itemKeyDto, ce);
    }

    private GoodsCouponDto takeGoodsCoupon(GoodsTypeEnum gtype, Long gid, Long consumerId, Long appId, String bizNum) {
        GoodsCouponDto dto = this.goodsCouponBO.takeCoupon(gtype, gid, consumerId, appId, bizNum);
        if (dto == null) {
            throw new RuntimeGoodsException(ErrorCode.E0202006);
        }
        return dto;
    }

    private Integer getCouponType(ItemKeyDto itemKeyDto) {
        Integer linkType = null;
        if (itemKeyDto.isDuibaAppItemMode() || itemKeyDto.isItemMode()) {
            linkType = itemKeyDto.getItem().getSubType();
        } else if (itemKeyDto.isSelfAppItemMode()) {
            linkType = itemKeyDto.getAppItem().getSubType();
        }
        return linkType;
    }

    private GoodsCouponDto convert(ItemKeyDto itemKey, CouponEntity ce) {
        if (ce == null) {
            return null;
        }
        GoodsCouponDto dto = new GoodsCouponDto();
        Long gid = ce.getItemId() != null ? ce.getItemId() : ce.getAppItemId();
        Integer gtype = ce.getItemId() != null ? GoodsTypeEnum.DUIBA.getGtype() : GoodsTypeEnum.APP.getGtype();
        dto.setGid(gid);
        dto.setGtype(gtype);
        dto.setGmtCreate(ce.getGmtCreate());
        dto.setGmtModified(ce.getGmtModified());
        dto.setBatchId(ce.getBatchId());
        dto.setGoodsCouponId(ce.getId());
        dto.setGoodsBatchId(ce.getBatchId());
        if (1 == this.getCouponType(itemKey)) {
            dto.setLink(ce.getCode());
            dto.setPassword(ce.getCode());
        } else {
            dto.setCode(ce.getCode());
            dto.setPassword(ce.getPassword());
        }
        return dto;
    }

    private GoodsBatchDto convertBatch(ItemKeyDto itemKey, CouponBatchEntity cbe) {
        if (cbe == null) {
            return null;
        }
        GoodsBatchDto dto = new GoodsBatchDto();
        dto.setId(cbe.getId());
        dto.setGid(this.getGid(itemKey));
        dto.setGtype(Integer.valueOf(this.getGtype(itemKey).getGtype()));
        dto.setBatchType(this.getCouponType(itemKey));
        dto.setStartDay(cbe.getValidStartDate());
        dto.setEndDay(cbe.getValidEndDate());
        dto.setGmtCreate(cbe.getGmtCreate());
        dto.setGmtModified(cbe.getGmtModified());
        return dto;
    }

    private void updateCouponType(ItemKeyDto itemKeyDto, Integer subType) {
        if (GoodsTypeEnum.DUIBA == this.getGtype(itemKeyDto)) {
            this.itemService.updateSubTypeById(this.getGid(itemKeyDto), subType);
        } else if (GoodsTypeEnum.APP == this.getGtype(itemKeyDto)) {
            this.appItemService.updateSubTypeById(this.getGid(itemKeyDto), subType);
        } else {
            throw new RuntimeGoodsException(ErrorCode.E0202008);
        }
    }

    private void updateVaildEndDate(ItemKeyDto itemKeyDto) {
        GoodsTypeEnum gtype = this.getGtype(itemKeyDto);
        Long gid = this.getGid(itemKeyDto);
        Date validEndDate = this.goodsBatchDao.selectMaxEndDay(gtype, gid);
        if (GoodsTypeEnum.DUIBA == gtype) {
            this.itemService.updateValidEndDateById(gid, validEndDate);
        } else if (GoodsTypeEnum.APP == gtype) {
            this.appItemService.updateValidEndDateById(gid, validEndDate);
        } else {
            throw new RuntimeGoodsException(ErrorCode.E0202008);
        }
    }

    @Override
    public Long importCouponNormal(ItemKeyDto itemKeyDto, Long batchId, Date startDay, Date endDay, String fileUrl) throws GoodsException {
        if (!ItemKeyUtils.isGoodsCoupon((ItemKeyDto)itemKeyDto)) {
            throw new GoodsException(ErrorCode.E0404016);
        }
        GoodsTypeEnum gtype = this.getGtype(itemKeyDto);
        Long gid = this.getGid(itemKeyDto);
        Long importBatchId = batchId;
        if (batchId == null) {
            this.createBatchValidate(startDay, endDay);
            importBatchId = this.goodsBatchCouponBackendBO.createNormalBatch(gtype, gid, startDay, endDay);
            if (this.getCouponType(itemKeyDto) == null) {
                this.updateCouponType(itemKeyDto, 0);
            }
            this.updateVaildEndDate(itemKeyDto);
        }
        return this.goodsBatchCouponBackendBO.importNormalCoupons(gtype, gid, importBatchId, fileUrl);
    }

    @Override
    public boolean importCouponLink(ItemKeyDto itemKeyDto, Long batchId, Date startDay, Date endDay, String link, Long stock) throws GoodsException {
        if (!ItemKeyUtils.isGoodsCoupon((ItemKeyDto)itemKeyDto)) {
            throw new GoodsException(ErrorCode.E0404016);
        }
        GoodsTypeEnum gtype = this.getGtype(itemKeyDto);
        Long gid = this.getGid(itemKeyDto);
        if (batchId == null) {
            this.createBatchValidate(startDay, endDay);
            this.goodsBatchCouponBackendBO.createLinkBatch(gtype, gid, startDay, endDay, link, stock);
            if (this.getCouponType(itemKeyDto) == null) {
                this.updateCouponType(itemKeyDto, 1);
            }
            this.updateVaildEndDate(itemKeyDto);
            return true;
        }
        return this.goodsBatchCouponBackendBO.updateLinkBatch(gtype, gid, batchId, link, stock);
    }

    @Override
    public boolean importCouponRepeat(ItemKeyDto itemKeyDto, Long batchId, Date startDay, Date endDay, String code, String password, Long stock) throws GoodsException {
        if (!ItemKeyUtils.isGoodsCoupon((ItemKeyDto)itemKeyDto)) {
            throw new GoodsException(ErrorCode.E0404016);
        }
        GoodsTypeEnum gtype = this.getGtype(itemKeyDto);
        Long gid = this.getGid(itemKeyDto);
        if (batchId == null) {
            this.createBatchValidate(startDay, endDay);
            this.goodsBatchCouponBackendBO.createRepeatBatch(gtype, gid, startDay, endDay, code, password, stock);
            if (this.getCouponType(itemKeyDto) == null) {
                this.updateCouponType(itemKeyDto, 2);
            }
            this.updateVaildEndDate(itemKeyDto);
            return true;
        }
        return this.goodsBatchCouponBackendBO.updateRepeatBatch(gtype, gid, batchId, code, password, stock);
    }

    private void createBatchValidate(Date startDay, Date endDay) throws GoodsException {
        if (startDay == null || endDay == null) {
            throw new GoodsException(ErrorCode.E0404017);
        }
        if (startDay.getTime() < DateUtils.getTodayZeroTimeInMillis()) {
            throw new GoodsException(ErrorCode.E0404014);
        }
        if (endDay.before(startDay)) {
            throw new GoodsException(ErrorCode.E0404015);
        }
    }
}

