/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ExchangeStockWarnDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.StockWarnEmailDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.cache.EventHomeCache;
import cn.com.duiba.goods.center.biz.dao.item.AppBannerDao;
import cn.com.duiba.goods.center.biz.dao.item.AppItemMaskDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemAppSpecifyDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemAutoRecommendDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockPointDao;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.entity.PreStockPointEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.RedisCacheService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.biz.util.RedisKeyFactory;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service(value="itemService")
public class ItemServiceImpl
implements ItemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemServiceImpl.class);
    @Autowired
    private RedisCacheService redisCacheService;
    @Autowired
    private ItemDao itemDao;
    @Autowired
    private ItemAppSpecifyDao itemAppSpecifyDao;
    @Autowired
    private GoodsCouponBO goodsCouponBO;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private ItemAutoRecommendDao itemAutoRecommendDao;
    @Autowired
    private AppItemMaskDao appItemMaskDao;
    @Resource(name="creditsTransactionManager")
    private DataSourceTransactionManager creditsTransactionManager;
    @Resource
    private EventHomeCache eventHomeCache;
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private AppBannerDao appBannerDao;
    @Resource(name="stringRedisTemplate03")
    private AdvancedCacheClient advancedCacheClient;
    @Autowired
    private PreStockPointDao preStockPointDao;

    private String getCacheKeyById(Long id) {
        return "item.itemId_" + id;
    }

    @Override
    public ItemEntity findCorrectStockItem(Long id) {
        Preconditions.checkNotNull((Object)id, (Object)"id \u4e0d\u80fd\u4e3a null");
        ItemEntity item = this.itemDao.find(id);
        if (item == null) {
            return null;
        }
        if (item.isOpTypeItem(16)) {
            Long stock = this.goodsBatchService.getSumBatchStockBatch(GoodsTypeEnum.DUIBA, item.getId());
            item.setRemaining(Integer.valueOf(stock.toString()));
        }
        return item;
    }

    @Override
    public ItemEntity find(Long id) {
        ItemEntity entity = this.itemDao.find(id);
        if (entity == null) {
            return null;
        }
        if (entity.isOpTypeItem(16)) {
            Long stock = this.goodsBatchService.getSumBatchStockBatch(GoodsTypeEnum.DUIBA, entity.getId());
            entity.setRemaining(Integer.valueOf(stock.toString()));
        }
        return entity;
    }

    @Override
    public ItemEntity findByType(String type) {
        if (!this.isRechargeGoods(type).booleanValue()) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        ItemEntity entity = this.itemDao.findByType(type);
        if (entity == null) {
            return null;
        }
        return entity;
    }

    @Override
    public List<ItemEntity> findByIds(List<Long> ids) {
        List<ItemEntity> entitys = this.itemDao.findAllByIds(ids);
        ArrayList<GoodsStockDto> stocks = new ArrayList<GoodsStockDto>();
        for (ItemEntity entity : entitys) {
            if (!entity.isOpTypeItem(16)) continue;
            GoodsStockDto stock = new GoodsStockDto();
            stock.setGid(entity.getId());
            stock.setGtype(GoodsTypeEnum.DUIBA);
            stocks.add(stock);
        }
        if (!stocks.isEmpty()) {
            List<GoodsStockDto> gst = this.goodsCouponBO.findGoodsStockByBatch(stocks);
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            for (GoodsStockDto dto : gst) {
                map.put(dto.getGid(), dto.getStock());
            }
            for (ItemEntity entity : entitys) {
                Long stock = (Long)map.get(entity.getId());
                if (stock == null || !entity.isOpTypeItem(16)) continue;
                entity.setRemaining(Integer.valueOf(stock.toString()));
            }
        }
        return entitys;
    }

    @Override
    public Map<Long, ItemEntity> findByIdsToMap(List<Long> ids) {
        List<ItemEntity> entitys = this.itemDao.findAllByIds(ids);
        ArrayList<GoodsStockDto> stocks = new ArrayList<GoodsStockDto>();
        HashMap<Long, ItemEntity> maps = new HashMap<Long, ItemEntity>();
        for (ItemEntity entity : entitys) {
            maps.put(entity.getId(), entity);
            if (!entity.isOpTypeItem(16)) continue;
            GoodsStockDto stock = new GoodsStockDto();
            stock.setGid(entity.getId());
            stock.setGtype(GoodsTypeEnum.DUIBA);
            stocks.add(stock);
        }
        if (!stocks.isEmpty()) {
            List<GoodsStockDto> gst = this.goodsCouponBO.findGoodsStockByBatch(stocks);
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            for (GoodsStockDto dto : gst) {
                map.put(dto.getGid(), dto.getStock());
            }
            for (ItemEntity entity : entitys) {
                Long stock = (Long)map.get(entity.getId());
                if (stock == null || !entity.isOpTypeItem(16)) continue;
                entity.setRemaining(Integer.valueOf(stock.toString()));
            }
        }
        return maps;
    }

    @Override
    public Long insert(ItemEntity itemEntity) {
        this.itemDao.insert(itemEntity);
        this.eventHomeCache.invalidItem(itemEntity.getId());
        return itemEntity.getId();
    }

    @Override
    public Boolean update(ItemEntity itemEntity) {
        int ret = this.itemDao.update(itemEntity);
        if (ret > 0) {
            this.eventHomeCache.invalidItem(itemEntity.getId());
            this.advancedCacheClient.remove(this.getCacheKeyById(itemEntity.getId()));
            return true;
        }
        return false;
    }

    @Override
    public Boolean delete(Long itemId) {
        int ret = this.itemDao.delete(itemId);
        if (ret > 0) {
            this.eventHomeCache.invalidItem(itemId);
            this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
            return true;
        }
        return false;
    }

    @Override
    public Boolean updateEnable(Long itemId, Boolean enable) {
        int ret = this.itemDao.updateEnable(itemId, enable);
        if (ret > 0) {
            this.eventHomeCache.invalidItem(itemId);
            this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
            return true;
        }
        return false;
    }

    @Override
    public Boolean decrStock(Long itemId) {
        int ret = this.itemDao.decrStock(itemId);
        if (ret > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean incrStock(Long itemId) {
        int ret = this.itemDao.incrStock(itemId);
        if (ret > 0) {
            this.eventHomeCache.invalidItem(itemId);
            this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
            return true;
        }
        return false;
    }

    @Override
    public Boolean appendStock(Long itemId, Long number) {
        int ret = this.itemDao.appendStock(itemId, number);
        if (ret > 0) {
            this.eventHomeCache.invalidItem(itemId);
            this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
            return true;
        }
        return false;
    }

    @Override
    public Boolean deductStock(Long itemId, Long number) {
        int ret = this.itemDao.deductStock(itemId, number);
        if (ret > 0) {
            this.eventHomeCache.invalidItem(itemId);
            this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
            return true;
        }
        return false;
    }

    @Override
    public List<ItemEntity> findAutoRecommend(Long appId) {
        String key = (Object)((Object)RedisKeyFactory.K206) + String.valueOf(appId);
        List cache = (List)this.redisCacheService.getObject((Object)((Object)RedisKeyFactory.K206) + String.valueOf(appId));
        if (cache != null) {
            return cache;
        }
        List<Long> allList = this.itemAutoRecommendDao.findItemAutoRecommendNoSpecify(true, true);
        List<Long> spcefyList = this.itemAutoRecommendDao.findItemSpecify(appId);
        List<Long> appMaskingList = this.appItemMaskDao.findItemAppMasking(appId);
        List<Long> tagsMaskingList = this.itemAutoRecommendDao.findItemAppTagsMasking(appId);
        List<Long> inAppList = this.itemAutoRecommendDao.findItemInApp(appId, false, false);
        List<Long> itemIdList = ListUtils.sum(allList, spcefyList);
        itemIdList = ListUtils.subtract((List)itemIdList, appMaskingList);
        itemIdList = ListUtils.subtract((List)itemIdList, tagsMaskingList);
        if ((itemIdList = ListUtils.subtract((List)itemIdList, inAppList)) != null && itemIdList.size() > 20) {
            itemIdList = itemIdList.subList(0, 20);
        }
        ArrayList<ItemEntity> entitys = new ArrayList();
        if (itemIdList != null && !itemIdList.isEmpty()) {
            entitys = this.findByIds(itemIdList);
        }
        this.redisCacheService.setObject(key, cache, 60);
        return entitys;
    }

    @Override
    public List<ItemEntity> findAutoRecommendMap(Long appId, Map<String, Object> query) {
        query.put("appId", appId);
        query.put("autoRecommend", true);
        query.put("enable", true);
        List<Long> allList = this.itemAutoRecommendDao.findItemAutoRecommendNoSpecifyMap(query);
        List<Long> spcefyList = this.itemAutoRecommendDao.findItemSpecifyMap(query);
        List<Long> appMaskingList = this.appItemMaskDao.findItemAppMasking(appId);
        List<Long> tagsMaskingList = this.itemAutoRecommendDao.findItemAppTagsMasking(appId);
        List<Long> inAppList = this.itemAutoRecommendDao.findItemInApp(appId, false, false);
        List<Long> itemIdList = ListUtils.sum(allList, spcefyList);
        itemIdList = ListUtils.subtract((List)itemIdList, appMaskingList);
        itemIdList = ListUtils.subtract((List)itemIdList, tagsMaskingList);
        itemIdList = ListUtils.subtract((List)itemIdList, inAppList);
        if (itemIdList != null && itemIdList.size() > 20) {
            itemIdList = itemIdList.subList(0, 20);
        }
        List<ItemEntity> entitys = new ArrayList<ItemEntity>();
        if (itemIdList != null && !itemIdList.isEmpty()) {
            entitys = this.findByIds(itemIdList);
        }
        return entitys;
    }

    @Override
    public Boolean isRechargeGoods(String type) {
        if (type == null) {
            return false;
        }
        if ("alipay".equals(type)) {
            return true;
        }
        if ("alipaycode".equals(type)) {
            return true;
        }
        if ("alipayfast".equals(type)) {
            return true;
        }
        if ("phonebill".equals(type)) {
            return true;
        }
        if ("phonebillDingzhi".equals(type)) {
            return true;
        }
        if ("phoneflow".equals(type)) {
            return true;
        }
        if ("qb".equals(type)) {
            return true;
        }
        return false;
    }

    @Override
    public Long findSpecifyRemaining(Long appId, Long itemId) {
        return this.itemAppSpecifyDao.findSpecifyRemaining(itemId, appId);
    }

    @Override
    public int updateRemainingAndvalidEndDate(Long itemId, Long totalStock, Date validEndDate) {
        int ret = this.itemDao.updateRemainingAndvalidEndDate(itemId, totalStock, validEndDate);
        this.eventHomeCache.invalidItem(itemId);
        this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
        return ret;
    }

    @Override
    public List<ItemDto> findHomeItems(List<Long> itemIds) {
        return this.itemDao.findHomeItems(itemIds);
    }

    @Override
    public void removeCache(Long itemId) {
        try {
            this.eventHomeCache.invalidItem(itemId);
            this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
        }
        catch (Exception e) {
            LOGGER.error("removeCache:itemId=" + itemId, (Throwable)e);
        }
    }

    @Override
    public String getJsonValue(Long id, String key) {
        return this.itemDao.getJsonValue(id, key);
    }

    @Override
    public Integer setJsonValue(Long id, String key, String value) {
        if (StringUtils.isBlank((String)key)) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        TransactionStatus status = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        int ret = 0;
        try {
            String jsonText = this.itemDao.findJson4Update(id);
            JSONObject json = StringUtils.isBlank((String)jsonText) ? new JSONObject() : JSONObject.parseObject((String)jsonText);
            if (StringUtils.isEmpty((String)value) && StringUtils.isNotEmpty((String)json.getString(key))) {
                json.remove((Object)key);
            }
            if (null != value) {
                json.put(key, (Object)value);
            }
            ret = this.itemDao.setJsonValue(id, json.toJSONString());
        }
        catch (Exception e) {
            status.setRollbackOnly();
            throw e;
        }
        finally {
            this.creditsTransactionManager.commit(status);
        }
        this.advancedCacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public ItemEntity findBySourceRelationIdAndSourceType(Long sourceRelationId, Integer sourceType) {
        return this.itemDao.findBySourceRelationIdAndSourceType(sourceRelationId, sourceType);
    }

    @Override
    public List<ItemDto> findByInTypes(List<String> types) {
        return this.itemDao.findByInTypes(types);
    }

    @Override
    public List<ItemDto> findAllByName(String name) {
        return this.itemDao.findAllByName(name);
    }

    @Override
    public List<ItemDto> findAllByExpressTemplateId(Long expressTemplateId) {
        return this.itemDao.findAllByExpressTemplateId(expressTemplateId);
    }

    @Override
    public Integer updateAutoOffDateNull(Long id) {
        return this.itemDao.updateAutoOffDateNull(id);
    }

    @Override
    public Integer updateLimitCountNull(Long id) {
        return this.itemDao.updateLimitCountNull(id);
    }

    @Override
    public Integer updateValidEndDateById(Long id, Date validEndDate) {
        return this.itemDao.updateValidEndDateById(id, validEndDate);
    }

    @Override
    public Integer updateOperationsTypeById(Long id, Integer operationsType) {
        return this.itemDao.updateOperationsTypeById(id, operationsType);
    }

    @Override
    public List<ItemDto> findAllActivityItemAndEnable(Boolean enable) {
        return this.itemDao.findAllActivityItemAndEnable(enable);
    }

    @Override
    public List<ItemDto> findAllForDuibaSecondsKill() {
        return this.itemDao.findAllForDuibaSecondsKill();
    }

    @Override
    public List<ItemDto> findAllTargetItemList(String type, Boolean deleted, Integer subType) {
        return this.itemDao.findAllTargetItemList(type, deleted, subType);
    }

    @Override
    public Page<ItemDto> findAdminItemPage(Map<String, Object> query) {
        Page page = new Page(0, 0);
        page.setList(this.itemDao.findAdminItemPage(query));
        page.setTotalCount(this.itemDao.findAdminItemPageCount(query).intValue());
        return page;
    }

    @Override
    public Page<ItemDto> findRecommandItems(String itemName) {
        Page page = new Page(0, 0);
        page.setList(this.itemDao.findRecommandItems(itemName));
        page.setTotalCount(this.itemDao.findRecommandItemsCount(itemName).intValue());
        return page;
    }

    @Override
    public Integer updateAutoRecommendById(Long id, Boolean autoRecommend) {
        return this.itemDao.updateAutoRecommendById(id, autoRecommend);
    }

    @Override
    public Integer updatePayloadById(Long id, Integer payload) {
        return this.itemDao.updatePayloadById(id, payload);
    }

    @Override
    public List<Long> findAutoRecommendAndTagsItems(Long tagsId) {
        return this.itemDao.findAutoRecommendAndTagsItems(tagsId);
    }

    @Override
    public List<ItemDto> findAllByNameAndType4Lottery(String name, String type) {
        return this.itemDao.findAllByNameAndType4Lottery(name, type);
    }

    @Override
    public List<Long> findIdAllByEnable(Boolean enable) {
        return this.itemDao.findIdAllByEnable(enable);
    }

    @Override
    public Integer updateItemClassifyIdNullById(Long id) {
        return this.itemDao.updateItemClassifyIdNullById(id);
    }

    @Override
    public List<ItemDto> findAllByClassify(List<Long> classifyIds) {
        return this.itemDao.findAllByClassify(classifyIds);
    }

    @Override
    public List<ItemDto> findAllEnableCoupon() {
        return this.itemDao.findAllEnableCoupon();
    }

    @Override
    public Page<ExchangeStockWarnDto> findExchangeStockWarnList(Map<String, Object> queryMap) {
        Page page = new Page(0, 0);
        page.setList(this.itemDao.findExchangeStockWarnList(queryMap));
        page.setTotalCount(this.itemDao.findExchangeStockWarnListCount(queryMap).intValue());
        return page;
    }

    @Override
    public List<ExchangeStockWarnDto> findItemStockWarns(Map<String, Object> queryMap) {
        return this.itemDao.findItemStockWarns(queryMap);
    }

    @Override
    public void emptyExchangeStockWarn() {
        this.itemDao.emptyExchangeStockWarn();
    }

    @Override
    public void saveExchangeStockWarn(ExchangeStockWarnDto exchangeStockWarn) {
        this.itemDao.saveExchangeStockWarn(exchangeStockWarn);
    }

    @Override
    public List<StockWarnEmailDto> findEmailStockList(Map<String, Object> queryMap) {
        return this.itemDao.findEmailStockList(queryMap);
    }

    @Override
    public void saveEmailStockWarn(String emailStr) {
        this.itemDao.saveEmailStockWarn(emailStr);
    }

    @Override
    public void emptyEmailStockWarn() {
        this.itemDao.emptyEmailStockWarn();
    }

    @Override
    public Integer updateSubTypeById(Long id, Integer subType) {
        return this.itemDao.updateSubTypeById(id, subType);
    }

    @Override
    public Long findDuibaItemChooseCount(Map<String, Object> paramMap) {
        return this.itemDao.findDuibaItemChooseCount(paramMap);
    }

    @Override
    public List<ItemDto> findAllBlacklistItem() {
        return this.itemDao.findAllBlacklistItem();
    }

    @Override
    public List<ItemDto> findAutoOffItem() {
        return this.itemDao.findAutoOffItem();
    }

    @Override
    public Boolean changeStatus(Long itemId, boolean enable) {
        ItemEntity item = this.find(itemId);
        if (item == null) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        if (("coupon".equals(item.getType()) || "object".equals(item.getType())) && enable && item.getRemaining() <= 0) {
            throw new RuntimeGoodsException(ErrorCode.E0202006);
        }
        if ("coupon".equals(item.getType()) && enable && (StringUtils.isBlank((String)item.getName()) || StringUtils.isBlank((String)item.getDescription()) || StringUtils.isBlank((String)item.getMultiImage()) || item.getMinFacePrice() == null)) {
            throw new RuntimeGoodsException(ErrorCode.E0202006);
        }
        if ("object".equals(item.getType()) && enable && (StringUtils.isBlank((String)item.getName()) || StringUtils.isBlank((String)item.getDescription()) || StringUtils.isBlank((String)item.getMultiImage()) || item.getMinFacePrice() == null || item.getMarketPrice() == null)) {
            throw new RuntimeGoodsException(ErrorCode.E0404018);
        }
        item.setEnable(enable);
        if (item.getEnable().booleanValue()) {
            item.setPublishTime(new Date());
            if (item.getAutoOffDate() != null && item.getAutoOffDate().before(new Date())) {
                throw new RuntimeGoodsException(ErrorCode.E0404019);
            }
        }
        this.itemDao.enableById(itemId, enable, item.getPublishTime());
        if (!enable) {
            List<AppItemDto> appItems = this.appItemService.findOnShelfByItemId(itemId);
            for (AppItemDto ai : appItems) {
                this.appBannerDao.disableByAppItemId(ai.getId());
            }
        }
        return true;
    }

    @Override
    public List<Long> findAllPreStockItems(Long appId, int opType) {
        List<Long> preIds = this.itemDao.findAllPreStockItems(10);
        if (preIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<PreStockPointEntity> preEntitys = this.preStockPointDao.findByItemIdsAndNullApp(preIds);
        HashMap<Long, Long> preItems = new HashMap<Long, Long>();
        for (PreStockPointEntity pspe : preEntitys) {
            preItems.put(pspe.getItemId(), pspe.getItemId());
        }
        ArrayList<Long> preItemApp = new ArrayList<Long>();
        for (Long preId : preIds) {
            if (preItems.containsKey(preId)) continue;
            preItemApp.add(preId);
        }
        List<PreStockPointEntity> preEntitys2 = this.preStockPointDao.findAllPointAppItem(preItemApp, appId);
        for (PreStockPointEntity pspe : preEntitys2) {
            preItems.put(pspe.getItemId(), pspe.getItemId());
        }
        Iterator<Long> iter = preIds.iterator();
        while (iter.hasNext()) {
            Long id = iter.next();
            if (!preItems.containsKey(id)) continue;
            iter.remove();
        }
        return preIds;
    }

    @Override
    public List<ItemDto> findAllByIdsOrderByIdStr(List<Long> ids, String idsStr) {
        return this.itemDao.findAllByIdsOrderByIdStr(ids, idsStr);
    }
}

